/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimizations;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.optimizations.GeneralizedRabinAcceptanceOptimizations;
import owl.automaton.acceptance.optimizations.OmegaAcceptanceOptimizations;
import owl.automaton.acceptance.optimizations.ParityAcceptanceOptimizations;
import owl.automaton.algorithms.LanguageEmptiness;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.output.HoaPrinter;
import owl.run.PipelineExecutionContext;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformers;

public final class AcceptanceOptimizations {
    private static final Logger logger = Logger.getLogger(AcceptanceOptimizations.class.getName());
    private static final List<Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>>> generalizedRabinDefaultAllList = List.of(GeneralizedRabinAcceptanceOptimizations::minimizeOverlap, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, OmegaAcceptanceOptimizations::removeTransientAcceptance, GeneralizedRabinAcceptanceOptimizations::removeComplementaryInfSets, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::removeComplementaryInfSets, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::mergeBuchiTypePairs);
    private static final List<Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>>> rabinDefaultAllList = List.of(GeneralizedRabinAcceptanceOptimizations::minimizeOverlap, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, OmegaAcceptanceOptimizations::removeTransientAcceptance, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::mergeBuchiTypePairs);
    private static final List<Consumer<MutableAutomaton<?, ParityAcceptance>>> parityDefaultList = List.of(OmegaAcceptanceOptimizations::removeTransientAcceptance, ParityAcceptanceOptimizations::minimizePriorities);
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("optimize-aut").description("Heuristically removes states and acceptance sets from the given automaton.").parser(settings -> environment -> new AcceptanceOptimizationTransformer()).build();

    private AcceptanceOptimizations() {
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> optimize(Automaton<S, A> automaton) {
        MutableAutomaton<S, A> mutableAutomaton = MutableAutomatonUtil.asMutable(automaton);
        Object acceptance = mutableAutomaton.acceptance();
        if (acceptance instanceof RabinAcceptance) {
            AcceptanceOptimizations.apply(mutableAutomaton, rabinDefaultAllList);
        } else if (acceptance instanceof GeneralizedRabinAcceptance) {
            MutableAutomaton<S, A> dgra = mutableAutomaton;
            AcceptanceOptimizations.apply(dgra, generalizedRabinDefaultAllList);
        } else if (acceptance instanceof ParityAcceptance) {
            MutableAutomaton<S, A> dpa = mutableAutomaton;
            AcceptanceOptimizations.apply(dpa, parityDefaultList);
        } else {
            logger.log(Level.FINE, "Received unsupported acceptance type {0}", acceptance.getClass());
        }
        return mutableAutomaton;
    }

    private static <S, A extends OmegaAcceptance> void apply(MutableAutomaton<S, ?> automaton, List<Consumer<MutableAutomaton<?, A>>> optimizations) {
        logger.log(Level.FINE, "Optimizing automaton with {0}", optimizations);
        for (Consumer<MutableAutomaton<?, A>> optimization : optimizations) {
            logger.log(Level.FINEST, () -> String.format("Current automaton: %s", HoaPrinter.toString(automaton)));
            logger.log(Level.FINER, "Applying {0}", optimization);
            optimization.accept(automaton);
            automaton.trim();
        }
        logger.log(Level.FINEST, () -> String.format("Automaton after optimization:%n%s", HoaPrinter.toString(automaton)));
    }

    public static <S> void removeDeadStates(MutableAutomaton<S, ?> automaton) {
        List<Set<S>> sccs = SccDecomposition.computeSccs(automaton);
        for (Set<S> scc : sccs) {
            if (!SccDecomposition.isTrap(automaton, scc) || !LanguageEmptiness.isEmpty(automaton, scc.iterator().next())) continue;
            logger.log(Level.FINER, "Removing scc {0}", scc);
            automaton.removeStateIf(scc::contains);
            automaton.trim();
        }
    }

    static <S> void removeIndices(MutableAutomaton<S, ?> automaton, Set<S> states, BitSet indicesToRemove) {
        if (indicesToRemove.isEmpty() || states.isEmpty()) {
            return;
        }
        logger.log(Level.FINER, "Removing acceptance indices {0} on subset", indicesToRemove);
        IntUnaryOperator transformer = index -> indicesToRemove.get(index) ? -1 : index;
        automaton.updateEdges(states, (state, edge) -> edge.withAcceptance(transformer));
        automaton.trim();
    }

    static void removeAndRemapIndices(MutableAutomaton<?, ?> automaton, IntSet indicesToRemove) {
        if (indicesToRemove.isEmpty()) {
            automaton.trim();
            return;
        }
        int acceptanceSets = ((OmegaAcceptance)automaton.acceptance()).acceptanceSets();
        Int2IntAVLTreeMap remapping = new Int2IntAVLTreeMap();
        remapping.defaultReturnValue(Integer.MAX_VALUE);
        int newIndex = 0;
        for (int index = 0; index < acceptanceSets; ++index) {
            if (indicesToRemove.contains(index)) {
                remapping.put(index, -1);
                continue;
            }
            remapping.put(index, newIndex);
            ++newIndex;
        }
        logger.log(Level.FINER, "Remapping acceptance indices: {0}", remapping);
        automaton.updateEdges((arg_0, arg_1) -> AcceptanceOptimizations.lambda$removeAndRemapIndices$6((Int2IntMap)remapping, arg_0, arg_1));
        automaton.trim();
    }

    private static /* synthetic */ Edge lambda$removeAndRemapIndices$6(Int2IntMap remapping, Object state, Edge edge) {
        return edge.withAcceptance((IntUnaryOperator)remapping);
    }

    public static class AcceptanceOptimizationTransformer
    extends Transformers.SimpleTransformer {
        @Override
        public Object transform(Object object, PipelineExecutionContext context) {
            Preconditions.checkArgument((boolean)(object instanceof Automaton), (String)"Expected automaton, got %s", object.getClass());
            MutableAutomaton mutableAutomaton = MutableAutomatonUtil.asMutable((Automaton)object);
            try {
                AcceptanceOptimizations.removeDeadStates(mutableAutomaton);
            }
            catch (UnsupportedOperationException ex) {
                logger.log(Level.FINE, "Unsupported acceptance type {0} for emptiness-check", mutableAutomaton.acceptance().getClass());
            }
            return AcceptanceOptimizations.optimize(mutableAutomaton);
        }
    }
}

