/*
 * Decompiled with CFR 0.152.
 */
package owl.game.output;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import owl.game.output.AigTuple;
import owl.util.annotation.Tuple;

@Value.Immutable
@Tuple
public abstract class Aig {
    public static final Aig FALSE = AigTuple.create(0, null, false, null, false);

    public abstract int variable();

    @Nullable
    public abstract Aig left();

    public abstract boolean leftIsNegated();

    @Nullable
    public abstract Aig right();

    public abstract boolean rightIsNegated();

    public static Aig leaf(int variable) {
        Preconditions.checkArgument((variable > 0 ? 1 : 0) != 0, (Object)"Variables need to have positive indices");
        return AigTuple.create(variable, null, false, null, false);
    }

    public static Aig node(Aig left, Aig right) {
        return AigTuple.create(0, left, false, right, false);
    }

    public static Aig node(Aig left, boolean leftNegated, Aig right, boolean rightNegated) {
        return AigTuple.create(0, left, leftNegated, right, rightNegated);
    }

    public boolean isLeaf() {
        return this.left() == null && this.right() == null;
    }

    public boolean isConstant() {
        return this == FALSE;
    }

    public boolean isVariable() {
        return this.isLeaf() && !this.isConstant();
    }
}

