/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formulas;
import owl.ltl.FrequencyG;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.PropositionalVisitor;
import owl.ltl.visitors.Visitor;

public abstract class Formula
implements Comparable<Formula> {
    private static final List<Class<? extends Formula>> ORDER = List.of(BooleanConstant.class, Literal.class, Conjunction.class, Disjunction.class, Biconditional.class, FOperator.class, FrequencyG.class, GOperator.class, XOperator.class, MOperator.class, ROperator.class, UOperator.class, WOperator.class);
    private final int hashCode;

    Formula(int hashCode) {
        this.hashCode = hashCode;
    }

    public abstract int accept(IntVisitor var1);

    public abstract <R> R accept(Visitor<R> var1);

    public abstract <R, P> R accept(BinaryVisitor<P, R> var1, P var2);

    public final BitSet atomicPropositions(final boolean includeNested) {
        final BitSet atomicPropositions = new BitSet();
        this.accept(new PropositionalVisitor<Void>(){

            @Override
            public Void visit(Biconditional biconditional) {
                biconditional.left.accept(this);
                biconditional.right.accept(this);
                return null;
            }

            @Override
            public Void visit(BooleanConstant booleanConstant) {
                return null;
            }

            @Override
            public Void visit(Conjunction conjunction) {
                conjunction.children.forEach(x -> x.accept(this));
                return null;
            }

            @Override
            public Void visit(Disjunction disjunction) {
                disjunction.children.forEach(x -> x.accept(this));
                return null;
            }

            @Override
            protected Void visit(TemporalOperator formula) {
                if (formula instanceof Literal) {
                    atomicPropositions.set(((Literal)formula).getAtom());
                } else if (includeNested) {
                    formula.children().forEach(x -> x.accept(this));
                }
                return null;
            }
        });
        return atomicPropositions;
    }

    public final boolean allMatch(Predicate<Formula> predicate) {
        if (!predicate.test(this)) {
            return false;
        }
        for (Formula child : this.children()) {
            if (child.allMatch(predicate)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(Predicate<Formula> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        for (Formula child : this.children()) {
            if (!child.anyMatch(predicate)) continue;
            return true;
        }
        return false;
    }

    public abstract Set<Formula> children();

    @Override
    public final int compareTo(Formula o) {
        int heightComparison = Integer.compare(this.height(), o.height());
        if (heightComparison != 0) {
            return heightComparison;
        }
        int classComparison = Integer.compare(Formula.classIndex(this), Formula.classIndex(o));
        if (classComparison != 0) {
            return classComparison;
        }
        return this.compareToImpl(o);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Formula other = (Formula)o;
        return other.hashCode == this.hashCode && this.equalsImpl(other);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final int height() {
        return Formulas.height(this.children()) + 1;
    }

    public abstract boolean isPureEventual();

    public abstract boolean isPureUniversal();

    public final boolean isSuspendable() {
        return this.isPureEventual() && this.isPureUniversal();
    }

    public abstract Formula nnf();

    public abstract Formula not();

    public final <E extends TemporalOperator> Set<E> subformulas(Class<E> clazz) {
        return this.subformulas(clazz::isInstance, clazz::cast);
    }

    public final Set<TemporalOperator> subformulas(Predicate<? super TemporalOperator> predicate) {
        return this.subformulas(predicate, x -> x);
    }

    public final <E extends TemporalOperator> Set<E> subformulas(final Predicate<? super TemporalOperator> predicate, final Function<? super TemporalOperator, E> cast) {
        final HashSet subformulas = new HashSet();
        this.accept(new PropositionalVisitor<Void>(){

            @Override
            public Void visit(Biconditional biconditional) {
                biconditional.left.accept(this);
                biconditional.right.accept(this);
                return null;
            }

            @Override
            public Void visit(BooleanConstant booleanConstant) {
                return null;
            }

            @Override
            public Void visit(Conjunction conjunction) {
                conjunction.children.forEach(c -> c.accept(this));
                return null;
            }

            @Override
            public Void visit(Disjunction disjunction) {
                disjunction.children.forEach(c -> c.accept(this));
                return null;
            }

            @Override
            protected Void visit(TemporalOperator formula) {
                if (predicate.test(formula)) {
                    subformulas.add((TemporalOperator)cast.apply(formula));
                }
                formula.children().forEach(x -> x.accept(this));
                return null;
            }
        });
        return subformulas;
    }

    public abstract Formula substitute(Function<? super TemporalOperator, ? extends Formula> var1);

    public abstract Formula temporalStep();

    public abstract Formula temporalStep(int var1, boolean var2);

    public abstract Formula temporalStep(BitSet var1);

    public abstract Formula temporalStepUnfold(BitSet var1);

    public abstract Formula unfold();

    public abstract Formula unfoldTemporalStep(BitSet var1);

    protected abstract int compareToImpl(Formula var1);

    protected abstract boolean equalsImpl(Formula var1);

    private static int classIndex(Formula formula) {
        int index = ORDER.indexOf(formula.getClass());
        assert (index >= 0);
        return index;
    }

    public static abstract class TemporalOperator
    extends Formula {
        TemporalOperator(int hashCode) {
            super(hashCode);
        }

        @Override
        public final Formula substitute(Function<? super TemporalOperator, ? extends Formula> substitution) {
            return substitution.apply(this);
        }

        @Override
        public final Formula temporalStep() {
            return this instanceof XOperator ? ((XOperator)this).operand : this;
        }

        @Override
        public final Formula temporalStep(int atom, boolean valuation) {
            Literal literal;
            if (this instanceof Literal && (literal = (Literal)this).getAtom() == atom) {
                return BooleanConstant.of(valuation ^ literal.isNegated());
            }
            return this;
        }

        @Override
        public final Formula temporalStep(BitSet valuation) {
            if (this instanceof Literal) {
                Literal literal = (Literal)this;
                return BooleanConstant.of(valuation.get(literal.getAtom()) ^ literal.isNegated());
            }
            return this.temporalStep();
        }

        @Override
        public final Formula temporalStepUnfold(BitSet valuation) {
            return this.temporalStep(valuation).unfold();
        }
    }

    public static abstract class LogicalOperator
    extends Formula {
        LogicalOperator(int hashCode) {
            super(hashCode);
        }

        @Override
        public final Formula temporalStep() {
            return this.substitute(Formula::temporalStep);
        }

        @Override
        public final Formula temporalStep(int atom, boolean valuation) {
            return this.substitute(x -> x.temporalStep(atom, valuation));
        }

        @Override
        public final Formula temporalStep(BitSet valuation) {
            return this.substitute(x -> x.temporalStep(valuation));
        }

        @Override
        public final Formula temporalStepUnfold(BitSet valuation) {
            return this.substitute(x -> x.temporalStepUnfold(valuation));
        }

        @Override
        public final Formula unfold() {
            return this.substitute(Formula::unfold);
        }

        @Override
        public final Formula unfoldTemporalStep(BitSet valuation) {
            return this.substitute(x -> x.unfoldTemporalStep(valuation));
        }
    }

    public static abstract class ModalOperator
    extends TemporalOperator {
        ModalOperator(int hashCode) {
            super(hashCode);
        }
    }
}

