/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.UOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;
import owl.util.annotation.CEntryPoint;

public final class ROperator
extends BinaryModalOperator {
    public ROperator(Formula leftOperand, Formula rightOperand) {
        super(ROperator.class, leftOperand, rightOperand);
    }

    @CEntryPoint
    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (rightOperand instanceof BooleanConstant || rightOperand instanceof GOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.TRUE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.FALSE)) {
            return GOperator.of(rightOperand);
        }
        if (leftOperand instanceof ROperator && rightOperand.equals(((ROperator)leftOperand).right)) {
            return leftOperand;
        }
        return new ROperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "R";
    }

    @Override
    public Formula nnf() {
        return ROperator.of(this.left.nnf(), this.right.nnf());
    }

    @Override
    public Formula not() {
        return UOperator.of(this.left.not(), this.right.not());
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.right.unfold(), Disjunction.of(this.left.unfold(), (Formula)this));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Conjunction.of(this.right.unfoldTemporalStep(valuation), Disjunction.of(this.left.unfoldTemporalStep(valuation), (Formula)this));
    }
}

