/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.fgx2dpa;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.collections.ValuationSet;
import owl.ltl.Formula;
import owl.translations.fgx2dpa.PromisedSet;
import owl.translations.fgx2dpa.State;
import owl.translations.fgx2dpa.StateReduction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StateReduction", generator="Immutables")
@Immutable
final class StateReductionTuple
extends StateReduction {
    private final Formula formula;
    private final ImmutableList<PromisedSet> permutation;
    private final ImmutableMap<State, ValuationSet> successors;
    private final transient int hashCode;

    private StateReductionTuple(Formula formula, Iterable<? extends PromisedSet> permutation, Map<? extends State, ? extends ValuationSet> successors) {
        this.formula = Objects.requireNonNull(formula, "formula");
        this.permutation = ImmutableList.copyOf(permutation);
        this.successors = ImmutableMap.copyOf(successors);
        this.hashCode = this.computeHashCode();
    }

    @Override
    Formula formula() {
        return this.formula;
    }

    ImmutableList<PromisedSet> permutation() {
        return this.permutation;
    }

    ImmutableMap<State, ValuationSet> successors() {
        return this.successors;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StateReductionTuple && this.equalTo((StateReductionTuple)another);
    }

    private boolean equalTo(StateReductionTuple another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.formula.equals(another.formula) && this.permutation.equals(another.permutation) && this.successors.equals(another.successors);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.formula.hashCode();
        h += (h << 5) + this.permutation.hashCode();
        h += (h << 5) + this.successors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StateReduction").omitNullValues().add("formula", (Object)this.formula).add("permutation", this.permutation).add("successors", this.successors).toString();
    }

    public static StateReductionTuple create(Formula formula, List<PromisedSet> permutation, Map<State, ValuationSet> successors) {
        return StateReductionTuple.create(formula, permutation, successors);
    }

    public static StateReductionTuple create(Formula formula, Iterable<? extends PromisedSet> permutation, Map<? extends State, ? extends ValuationSet> successors) {
        return new StateReductionTuple(formula, permutation, successors);
    }
}

