/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2nba;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.TwoPartAutomaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.optimizations.AcceptanceOptimizations;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.Either;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.Factories;
import owl.factories.ValuationSetFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.run.Environment;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2nba.ProductState;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricNBAConstruction<B extends GeneralizedBuchiAcceptance>
implements Function<LabelledFormula, Automaton<Either<Formula, ProductState>, B>> {
    private final Class<B> acceptanceClass;
    private final Environment environment;

    private SymmetricNBAConstruction(Environment environment, Class<B> acceptanceClass) {
        this.acceptanceClass = acceptanceClass;
        this.environment = environment;
        assert (BuchiAcceptance.class.equals(acceptanceClass) || GeneralizedBuchiAcceptance.class.equals(acceptanceClass));
    }

    public static <B extends GeneralizedBuchiAcceptance> Function<LabelledFormula, Automaton<Either<Formula, ProductState>, B>> of(Environment environment, Class<B> clazz) {
        return new SymmetricNBAConstruction<B>(environment, clazz);
    }

    @Override
    public Automaton<Either<Formula, ProductState>, B> apply(LabelledFormula input) {
        LabelledFormula formula = SyntacticFragments.normalize(input, SyntacticFragment.NNF);
        Factories factories = this.environment.factorySupplier().getFactories(formula.variables(), false);
        SymmetricNBA automaton = new SymmetricNBA(factories, formula);
        MutableAutomaton mutableAutomaton = MutableAutomatonFactory.copy(automaton);
        AcceptanceOptimizations.removeDeadStates(mutableAutomaton);
        return mutableAutomaton;
    }

    private final class SymmetricNBA
    extends TwoPartAutomaton<Formula, ProductState, B> {
        private final Set<Fixpoints> knownFixpoints;
        private final Map<Fixpoints, Set<SymmetricEvaluatedFixpoints>> evaluationMap;
        private final Map<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.NonDeterministicAutomata> automataMap;
        private final NonDeterministicConstructions.Tracking trackingAutomaton;
        private final int acceptanceSets;
        private final Factories factories;
        private final Set<Formula> initialStatesA;
        private final Set<ProductState> initialStatesB;
        private final String name;

        private SymmetricNBA(Factories factories, LabelledFormula formula) {
            HashMap<Fixpoints, Set<SymmetricEvaluatedFixpoints>> evaluationMap = new HashMap<Fixpoints, Set<SymmetricEvaluatedFixpoints>>();
            HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.NonDeterministicAutomata> automataMap = new HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.NonDeterministicAutomata>();
            this.trackingAutomaton = new NonDeterministicConstructions.Tracking(factories, formula.formula());
            this.factories = factories;
            HashSet<Fixpoints> knownFixpoints = new HashSet<Fixpoints>();
            for (Formula initialFormula : this.trackingAutomaton.initialStates()) {
                knownFixpoints.addAll(Selector.selectSymmetric(initialFormula, false));
            }
            this.knownFixpoints = Set.copyOf(knownFixpoints);
            int acceptanceSets = 1;
            for (Fixpoints fixpoints : this.knownFixpoints) {
                Fixpoints simplified = fixpoints.simplified();
                if (evaluationMap.containsKey(simplified)) continue;
                Set<SymmetricEvaluatedFixpoints> evaluatedSet = SymmetricEvaluatedFixpoints.build(simplified, factories);
                evaluationMap.put(simplified, evaluatedSet);
                for (SymmetricEvaluatedFixpoints evaluated : evaluatedSet) {
                    if (automataMap.containsKey(evaluated)) continue;
                    SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata = evaluated.nonDeterministicAutomata(factories, SymmetricNBAConstruction.this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class));
                    automataMap.put(evaluated, automata);
                    if (automata.gfCoSafetyAutomaton == null) continue;
                    acceptanceSets = Math.max(acceptanceSets, automata.gfCoSafetyAutomaton.acceptance().acceptanceSets());
                }
            }
            this.acceptanceSets = acceptanceSets;
            this.automataMap = Map.copyOf(automataMap);
            this.evaluationMap = Map.copyOf(evaluationMap);
            this.initialStatesA = new HashSet<Formula>();
            this.initialStatesB = new HashSet<ProductState>();
            for (Formula initialFormula : this.trackingAutomaton.initialStates()) {
                if (SyntacticFragments.isGfCoSafety(initialFormula)) {
                    this.initialStatesB.addAll(this.moveAtoB(initialFormula));
                    continue;
                }
                this.initialStatesA.add(initialFormula);
            }
            this.name = "LTL to NBA (symmetric) for formula: " + formula;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.factories.vsFactory;
        }

        @Override
        public B acceptance() {
            return (GeneralizedBuchiAcceptance)SymmetricNBAConstruction.this.acceptanceClass.cast(GeneralizedBuchiAcceptance.of(this.acceptanceSets));
        }

        @Override
        protected Set<Formula> initialStatesA() {
            return this.initialStatesA;
        }

        @Override
        protected Set<ProductState> initialStatesB() {
            return this.initialStatesB;
        }

        @Override
        protected ValuationTree<Edge<Formula>> edgeTreeA(Formula state) {
            return this.trackingAutomaton.edgeTree(state).map(x -> this.buildEdgeA(Edges.successors(x)));
        }

        @Override
        protected Set<Edge<Formula>> edgesA(Formula state, BitSet valuation) {
            return this.buildEdgeA(this.trackingAutomaton.successors(state, valuation));
        }

        private Set<Edge<Formula>> buildEdgeA(Set<Formula> successors) {
            HashSet<Edge<Formula>> edges = new HashSet<Edge<Formula>>();
            BitSet acceptance = new BitSet();
            acceptance.set(0, this.acceptanceSets);
            for (Formula successor : successors) {
                assert (!BooleanConstant.FALSE.equals(successor));
                if (SyntacticFragment.SAFETY.contains(successor)) {
                    edges.add(Edge.of(successor, acceptance));
                    continue;
                }
                edges.add(Edge.of(successor));
            }
            return edges;
        }

        @Override
        protected ValuationTree<Edge<ProductState>> edgeTreeB(ProductState state) {
            SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata = Objects.requireNonNull(state.automata);
            Formula safetyState = Objects.requireNonNull(state.safety);
            NonDeterministicConstructions.Safety safetyAutomaton = automata.safetyAutomaton;
            if (automata.gfCoSafetyAutomaton == null) {
                return safetyAutomaton.edgeTree(safetyState).map(x -> x.stream().map(y -> {
                    ProductState successor = new ProductState((Formula)y.successor(), null, state.evaluatedFixpoints, automata);
                    BitSet acceptance = new BitSet();
                    acceptance.set(0, this.acceptanceSets);
                    return Edge.of(successor, acceptance);
                }).collect(Collectors.toUnmodifiableSet()));
            }
            RoundRobinState<Formula> livenessState = Objects.requireNonNull(state.liveness);
            NonDeterministicConstructions.GfCoSafety livenessAutomaton = automata.gfCoSafetyAutomaton;
            return ValuationTrees.cartesianProduct(safetyAutomaton.edgeTree(safetyState), livenessAutomaton.edgeTree(livenessState), (safetyEdge, livenessEdge) -> {
                assert (livenessEdge.largestAcceptanceSet() < this.acceptanceSets);
                ProductState successor = new ProductState((Formula)safetyEdge.successor(), (RoundRobinState)livenessEdge.successor(), state.evaluatedFixpoints, automata);
                BitSet acceptance = new BitSet();
                livenessEdge.acceptanceSetIterator().forEachRemaining(acceptance::set);
                acceptance.set(livenessAutomaton.acceptance().acceptanceSets(), this.acceptanceSets);
                return Edge.of(successor, acceptance);
            });
        }

        @Override
        protected Set<ProductState> moveAtoB(Formula state) {
            if (SyntacticFragment.CO_SAFETY.contains(state) || SyntacticFragment.SAFETY.contains(state) || SyntacticFragments.isFSafety(state) && !state.isSuspendable()) {
                return Set.of();
            }
            Set<Formula.ModalOperator> allModalOperators = state.subformulas(Formula.ModalOperator.class);
            Set availableFixpoints = this.knownFixpoints.stream().filter(x -> x.allFixpointsPresent(allModalOperators)).map(Fixpoints::simplified).collect(Collectors.toSet());
            if (state instanceof Conjunction) {
                for (Formula x2 : state.children()) {
                    if (!SyntacticFragment.CO_SAFETY.contains(x2) || !allModalOperators.stream().noneMatch(y -> {
                        if (x2.equals(y)) return false;
                        if (!y.anyMatch(x2::equals)) return false;
                        return true;
                    })) continue;
                    return Set.of();
                }
            }
            HashSet<ProductState> bStates = new HashSet<ProductState>();
            Maps.filterKeys(this.evaluationMap, availableFixpoints::contains).forEach((fixpoints, set) -> {
                for (SymmetricEvaluatedFixpoints symmetricEvaluatedFixpoints : set) {
                    Formula remainder = state.unfold().substitute(new Rewriter.ToSafety((Fixpoints)fixpoints));
                    if (BooleanConstant.FALSE.equals(state)) {
                        return;
                    }
                    SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata = this.automataMap.get(symmetricEvaluatedFixpoints);
                    Set<Formula> safety = automata.safetyAutomaton.initialStatesWithRemainder(remainder);
                    for (Formula safetyState : safety) {
                        if (automata.gfCoSafetyAutomaton == null) {
                            bStates.add(new ProductState(safetyState, null, symmetricEvaluatedFixpoints, automata));
                            continue;
                        }
                        for (RoundRobinState<Formula> gfCoSafetyState : automata.gfCoSafetyAutomaton.initialStates()) {
                            bStates.add(new ProductState(safetyState, gfCoSafetyState, symmetricEvaluatedFixpoints, automata));
                        }
                    }
                }
            });
            return bStates;
        }

        @Override
        protected Set<Edge<Either<Formula, ProductState>>> deduplicate(Set<Edge<Either<Formula, ProductState>>> edges) {
            Formula initialComponentSafetyLanguage = BooleanConstant.FALSE;
            HashSet<Edge<Either<Formula, ProductState>>> initialComponentEdges = new HashSet<Edge<Either<Formula, ProductState>>>();
            HashSet<Edge> acceptingComponentEdges = new HashSet<Edge>();
            for (Edge<Either<Formula, ProductState>> edge : edges) {
                if (edge.successor().isLeft()) {
                    initialComponentEdges.add(edge);
                    Formula formula = edge.successor().fromLeft().orElseThrow();
                    if (!SyntacticFragment.SAFETY.contains(formula)) continue;
                    initialComponentSafetyLanguage = Disjunction.of(initialComponentSafetyLanguage, formula);
                    continue;
                }
                acceptingComponentEdges.add(edge);
            }
            if (initialComponentSafetyLanguage.equals(BooleanConstant.FALSE)) {
                return edges;
            }
            EquivalenceClass initialComponentLanguage = this.factories.eqFactory.of(initialComponentSafetyLanguage);
            acceptingComponentEdges.removeIf(x -> {
                ProductState productState = (ProductState)((Either)x.successor()).fromRight().orElseThrow();
                if (productState.liveness != null) {
                    return false;
                }
                EquivalenceClass stateLanguage = this.factories.eqFactory.of(productState.safety);
                return stateLanguage.implies(initialComponentLanguage);
            });
            if (acceptingComponentEdges.size() + initialComponentEdges.size() == edges.size()) {
                return edges;
            }
            return Sets.union(initialComponentEdges, acceptingComponentEdges);
        }
    }
}

