/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;

final class DefaultImplementations {
    private DefaultImplementations() {
    }

    static <S> Set<S> visit(Automaton<S, ?> automaton, Automaton.EdgeVisitor<S> visitor) {
        HashSet<S> exploredStates = new HashSet<S>(automaton.initialStates());
        ArrayDeque<S> workQueue = new ArrayDeque<S>(exploredStates);
        Set powerSet = BitSets.powerSet((int)automaton.factory().atomicPropositions().size());
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            visitor.enter(state);
            for (BitSet valuation : powerSet) {
                for (Edge<S> edge : automaton.edges(state, valuation)) {
                    S successor = edge.successor();
                    if (exploredStates.add(successor)) {
                        workQueue.add(successor);
                    }
                    visitor.visit(state, valuation, edge);
                }
            }
            visitor.exit(state);
        }
        return exploredStates;
    }

    static <S> Set<S> visit(Automaton<S, ?> automaton, Automaton.EdgeMapVisitor<S> visitor) {
        HashSet exploredStates = new HashSet(automaton.initialStates());
        ArrayDeque workQueue = new ArrayDeque(exploredStates);
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            Map<Edge<S>, ValuationSet> edges = automaton.edgeMap(state);
            edges.keySet().forEach(edge -> {
                Object successor = edge.successor();
                if (exploredStates.add(successor)) {
                    workQueue.add(successor);
                }
            });
            visitor.enter(state);
            visitor.visit(state, edges);
            visitor.exit(state);
        }
        return exploredStates;
    }

    static <S> Set<S> visit(Automaton<S, ?> automaton, Automaton.EdgeTreeVisitor<S> visitor) {
        HashSet exploredStates = new HashSet(automaton.initialStates());
        ArrayDeque workQueue = new ArrayDeque(exploredStates);
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            ValuationTree<Edge<S>> edges = automaton.edgeTree(state);
            edges.flatValues().forEach(edge -> {
                Object successor = edge.successor();
                if (exploredStates.add(successor)) {
                    workQueue.add(successor);
                }
            });
            visitor.enter(state);
            visitor.visit(state, edges);
            visitor.exit(state);
        }
        return exploredStates;
    }

    static <S> Set<S> getReachableStates(Automaton<S, ?> automaton) {
        HashSet<S> reachableStates = new HashSet<S>(automaton.initialStates());
        ArrayDeque<S> workQueue = new ArrayDeque<S>(reachableStates);
        while (!workQueue.isEmpty()) {
            for (S successor : automaton.successors(workQueue.remove())) {
                if (!reachableStates.add(successor)) continue;
                workQueue.add(successor);
            }
        }
        return reachableStates;
    }
}

