/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.AutoValue_Views_Filter;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.ValuationSetFactory;
import owl.run.modules.OwlModule;

public final class Views {
    public static final OwlModule<OwlModule.Transformer> COMPLETE_MODULE = OwlModule.of("complete", "Make the transition relation of an automaton complete by adding a sink-state.", (commandLine, environment) -> OwlModule.AutomatonTransformer.of(automaton -> Views.complete(automaton, new MutableAutomatonUtil.Sink())));

    private Views() {
    }

    public static <S> Automaton<S, ?> complete(Automaton<S, ?> automaton, S trapState) {
        Object acceptance = automaton.acceptance();
        if (acceptance instanceof AllAcceptance) {
            acceptance = CoBuchiAcceptance.INSTANCE;
        } else if (acceptance instanceof ParityAcceptance && ((OmegaAcceptance)acceptance).acceptanceSets() <= 1) {
            acceptance = ((ParityAcceptance)acceptance).withAcceptanceSets(2);
        }
        Object finalAcceptance = acceptance;
        BitSet rejectingSet = ((OmegaAcceptance)acceptance).rejectingSet().orElseThrow(() -> Views.lambda$complete$2((OmegaAcceptance)finalAcceptance));
        return new Complete(automaton, Edge.of(trapState, rejectingSet), acceptance);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> filtered(Automaton<S, A> automaton, Filter<S> filter) {
        return new AutomatonView<S, A>(automaton, filter);
    }

    public static <S, T, A extends OmegaAcceptance> Automaton<T, A> quotientAutomaton(Automaton<S, A> automaton, Function<S, T> mappingFunction) {
        HashMap<S, T> mapping = new HashMap<S, T>();
        ImmutableListMultimap.Builder reverseMappingBuilder = ImmutableListMultimap.builder();
        for (S state : automaton.states()) {
            T mappedState = mappingFunction.apply(state);
            mapping.put(state, mappedState);
            reverseMappingBuilder.put(mappedState, state);
        }
        return new QuotientAutomaton(automaton, Map.copyOf(mapping), reverseMappingBuilder.build());
    }

    private static /* synthetic */ NoSuchElementException lambda$complete$2(OmegaAcceptance finalAcceptance) {
        return new NoSuchElementException("No rejecting set for " + finalAcceptance);
    }

    private static class QuotientAutomaton<S, T, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton.NonDeterministicEdgeTreeAutomaton<T, A> {
        private final Automaton<S, A> automaton;
        private final Map<S, T> mapping;
        private final ImmutableListMultimap<T, S> reverseMapping;

        private QuotientAutomaton(Automaton<S, A> automaton, Map<S, T> mapping, ImmutableListMultimap<T, S> reverseMapping) {
            super(automaton.factory(), automaton.initialStates().stream().map(mapping::get).collect(Collectors.toSet()), automaton.acceptance());
            this.automaton = automaton;
            this.mapping = Map.copyOf(mapping);
            this.reverseMapping = reverseMapping;
        }

        @Override
        public Set<Edge<T>> edges(T state, BitSet valuation) {
            return this.reverseMapping.get(state).stream().flatMap(sState -> this.automaton.edges(sState, valuation).stream()).map(sEdge -> sEdge.withSuccessor(this.mapping.get(sEdge.successor()))).collect(Collectors.toSet());
        }

        @Override
        public ValuationTree<Edge<T>> edgeTree(T state) {
            return ValuationTrees.cartesianProduct(this.reverseMapping.get(state).stream().map(this.automaton::edgeTree).collect(Collectors.toList())).map(x -> {
                HashSet<Edge<T>> set = new HashSet<Edge<T>>();
                for (List edges : x) {
                    for (Edge edge : edges) {
                        set.add(edge.withSuccessor(this.mapping.get(edge.successor())));
                    }
                }
                return set;
            });
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.automaton.preferredEdgeAccess();
        }
    }

    private static final class AutomatonView<S, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton<S, A> {
        private final Automaton<S, A> backingAutomaton;
        @Nullable
        private final Predicate<S> stateFilter;
        @Nullable
        private final BiPredicate<S, Edge<S>> edgeFilter;

        private AutomatonView(Automaton<S, A> automaton, Filter<S> settings) {
            super(automaton.factory(), AutomatonView.initialStates(automaton, settings), automaton.acceptance());
            if (automaton instanceof AutomatonView) {
                AutomatonView castedAutomaton = (AutomatonView)automaton;
                this.backingAutomaton = castedAutomaton.backingAutomaton;
                this.stateFilter = AutomatonView.and(castedAutomaton.stateFilter, settings.stateFilter());
                this.edgeFilter = AutomatonView.and(castedAutomaton.edgeFilter, settings.edgeFilter());
            } else {
                this.backingAutomaton = automaton;
                this.stateFilter = settings.stateFilter();
                this.edgeFilter = settings.edgeFilter();
            }
        }

        @Nullable
        static <T> Predicate<T> and(@Nullable Predicate<T> predicate1, @Nullable Predicate<T> predicate2) {
            if (predicate1 == null) {
                return predicate2;
            }
            if (predicate2 == null) {
                return predicate1;
            }
            return predicate1.and(predicate2);
        }

        @Nullable
        static <T, U> BiPredicate<T, U> and(@Nullable BiPredicate<T, U> predicate1, @Nullable BiPredicate<T, U> predicate2) {
            if (predicate1 == null) {
                return predicate2;
            }
            if (predicate2 == null) {
                return predicate1;
            }
            return predicate1.and(predicate2);
        }

        private static <S> Set<S> initialStates(Automaton<S, ?> automaton, Filter<S> settings) {
            Set<S> initialStates = settings.initialStates();
            if (initialStates != null) {
                return initialStates;
            }
            Predicate<S> stateFilter = settings.stateFilter();
            if (stateFilter == null) {
                return automaton.initialStates();
            }
            return Sets.filter(automaton.initialStates(), stateFilter::test);
        }

        private boolean stateFilter(S state) {
            return this.stateFilter == null || this.stateFilter.test(state);
        }

        private Predicate<Edge<S>> edgeFilter(S state) {
            return edge -> (this.edgeFilter == null || this.edgeFilter.test(state, (Edge<S>)edge)) && this.stateFilter(edge.successor());
        }

        private boolean filterRequired() {
            return this.stateFilter != null || this.edgeFilter != null;
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.backingAutomaton.preferredEdgeAccess();
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            return this.filterRequired() ? this.backingAutomaton.edges(state, valuation).stream().filter(this.edgeFilter(state)).collect(Collectors.toSet()) : this.backingAutomaton.edges(state, valuation);
        }

        @Override
        public Set<Edge<S>> edges(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            return this.filterRequired() ? this.backingAutomaton.edges(state).stream().filter(this.edgeFilter(state)).collect(Collectors.toSet()) : this.backingAutomaton.edges(state);
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            return this.filterRequired() ? Maps.filterKeys(this.backingAutomaton.edgeMap(state), x -> this.edgeFilter(state).test((Edge<Object>)x)) : this.backingAutomaton.edgeMap(state);
        }

        @Override
        public ValuationTree<Edge<S>> edgeTree(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            ValuationTree<Edge<S>> edges = this.backingAutomaton.edgeTree(state);
            Function<Set, Set> mapper = this.filterRequired() ? x -> Sets.filter((Set)x, y -> this.edgeFilter(state).test((Edge<Object>)y)) : null;
            return mapper == null ? edges : edges.map(mapper);
        }
    }

    @AutoValue
    public static abstract class Filter<S> {
        @Nullable
        abstract Set<S> initialStates();

        @Nullable
        abstract Predicate<S> stateFilter();

        @Nullable
        abstract BiPredicate<S, Edge<S>> edgeFilter();

        public static <S> Builder<S> builder() {
            return new AutoValue_Views_Filter.Builder();
        }

        public static <S> Filter<S> of(Set<S> initialStates) {
            Builder<S> builder = Filter.builder();
            return builder.initialStates(initialStates).build();
        }

        public static <S> Filter<S> of(Set<S> initialStates, Predicate<S> stateFilter) {
            Builder<S> builder = Filter.builder();
            return builder.initialStates(initialStates).stateFilter(stateFilter).build();
        }

        public static <S> Filter<S> of(Predicate<S> stateFilter) {
            Builder<S> builder = Filter.builder();
            return builder.stateFilter(stateFilter).build();
        }

        public static <S> Filter<S> of(Predicate<S> stateFilter, BiPredicate<S, Edge<S>> edgeFilter) {
            Builder<S> builder = Filter.builder();
            return builder.stateFilter(stateFilter).edgeFilter(edgeFilter).build();
        }

        @AutoValue.Builder
        public static abstract class Builder<S> {
            public abstract Builder<S> initialStates(@Nullable Set<S> var1);

            public abstract Builder<S> stateFilter(@Nullable Predicate<S> var1);

            public abstract Builder<S> edgeFilter(@Nullable BiPredicate<S, Edge<S>> var1);

            public abstract Filter<S> build();
        }
    }

    private static class Complete<S, A extends OmegaAcceptance, B extends OmegaAcceptance>
    implements Automaton<S, B> {
        private final Edge<S> sinkEdge;
        private final Set<Edge<S>> sinkEdgeSet;
        private final Automaton<S, A> automaton;
        private final S sink;
        private final Set<S> sinkSet;
        private final B acceptance;
        @Nullable
        private Map<S, ValuationSet> incompleteStates;

        Complete(Automaton<S, A> automaton, Edge<S> sinkEdge, B acceptance) {
            this.automaton = automaton;
            this.sink = sinkEdge.successor();
            this.sinkSet = Set.of(this.sink);
            this.sinkEdge = sinkEdge;
            this.sinkEdgeSet = Set.of(sinkEdge);
            this.acceptance = acceptance;
        }

        @Override
        public B acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.automaton.factory();
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.automaton.preferredEdgeAccess();
        }

        @Override
        public Set<S> initialStates() {
            return this.automaton.initialStates();
        }

        @Override
        public Set<S> states() {
            if (this.incompleteStates == null) {
                this.incompleteStates = AutomatonUtil.getIncompleteStates(this.automaton);
            }
            if (this.incompleteStates.isEmpty()) {
                return this.automaton.states();
            }
            return Sets.union(this.automaton.states(), this.sinkSet);
        }

        @Override
        public Set<S> successors(S state) {
            if (this.sink.equals(state)) {
                return this.sinkSet;
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Sets.union(this.automaton.states(), this.sinkSet);
            }
            return Edges.successors(this.edgeMap(state).keySet());
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            if (this.sink.equals(state)) {
                return this.sinkEdgeSet;
            }
            Set<Edge<S>> edges = this.automaton.edges(state, valuation);
            return edges.isEmpty() ? this.sinkEdgeSet : edges;
        }

        @Override
        public Set<Edge<S>> edges(S state) {
            if (this.sink.equals(state)) {
                return this.sinkEdgeSet;
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Sets.union(this.automaton.edges(state), this.sinkEdgeSet);
            }
            return this.preferredEdgeAccess().get(0) == Automaton.PreferredEdgeAccess.EDGE_TREE ? this.edgeTree(state).flatValues() : this.edgeMap(state).keySet();
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            ValuationSet valuationSet;
            ValuationSetFactory factory = this.automaton.factory();
            if (this.sink.equals(state)) {
                return Map.of(this.sinkEdge, factory.universe());
            }
            if (this.incompleteStates != null && !this.incompleteStates.containsKey(state)) {
                return this.automaton.edgeMap(state);
            }
            HashMap<Edge<S>, ValuationSet> edges = new HashMap<Edge<S>, ValuationSet>(this.automaton.edgeMap(state));
            ValuationSet valuationSet2 = valuationSet = this.incompleteStates == null ? edges.values().stream().reduce(factory.empty(), ValuationSet::union).complement() : this.incompleteStates.get(state);
            if (!valuationSet.isEmpty()) {
                edges.put(this.sinkEdge, valuationSet);
            }
            return edges;
        }

        @Override
        public ValuationTree<Edge<S>> edgeTree(S state) {
            if (this.sink.equals(state)) {
                return ValuationTree.of(this.sinkEdgeSet);
            }
            ValuationTree<Edge<S>> valuationTree = this.automaton.edgeTree(state);
            if (this.incompleteStates != null && !this.incompleteStates.containsKey(state)) {
                return valuationTree;
            }
            return valuationTree.map(x -> x.isEmpty() ? this.sinkEdgeSet : x);
        }

        @Override
        public boolean is(Automaton.Property property) {
            return property == Automaton.Property.COMPLETE || this.automaton.is(property);
        }
    }
}

