/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnegative;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;

public class GeneralizedCoBuchiAcceptance
extends OmegaAcceptance {
    @Nonnegative
    public final int size;

    GeneralizedCoBuchiAcceptance(int size) {
        this.size = size;
    }

    public static GeneralizedCoBuchiAcceptance of(int size) {
        return size == 1 ? CoBuchiAcceptance.INSTANCE : new GeneralizedCoBuchiAcceptance(size);
    }

    @Override
    public final int acceptanceSets() {
        return this.size;
    }

    @Override
    public final BooleanExpression<AtomAcceptance> booleanExpression() {
        return BooleanExpressions.createDisjunction(IntStream.range(0, this.size).mapToObj(BooleanExpressions::mkFin));
    }

    @Override
    public String name() {
        return "generalized-co-Buchi";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(Integer.valueOf(this.size));
    }

    @Override
    public Optional<BitSet> acceptingSet() {
        return this.size == 0 ? Optional.empty() : Optional.of(new BitSet(0));
    }

    @Override
    public Optional<BitSet> rejectingSet() {
        BitSet set = new BitSet();
        set.set(0, this.size);
        return Optional.of(set);
    }
}

