/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import jhoafparser.parser.generated.ParseException;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.hoa.HoaReader;
import owl.cinterface.CDoubleArray;
import owl.cinterface.CDoubleArrayList;
import owl.cinterface.CIntArray;
import owl.cinterface.CIntArrayList;
import owl.cinterface.CInterface;
import owl.cinterface.DecomposedDPA;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2dpa.LTL2DPAFunction;

@CContext(value=CInterface.CDirectives.class)
public final class CAutomaton {
    private static final String NAMESPACE = "automaton_";

    private CAutomaton() {
    }

    @CEntryPoint(name="automaton_parse", documentation={"Read a (deterministic) automaton from a char* serialised in the HOA format.", "Decodes a 0 terminated C char* to a Java string using the platform's default charset.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle parse(IsolateThread thread, CCharPointer cCharPointer) throws ParseException {
        String hoa = CTypeConversion.toJavaString((CCharPointer)cCharPointer);
        String fieldName = "controllable-AP: ";
        int controllableAPStringIndex = hoa.indexOf(fieldName);
        BitSet controllableAPIndices = new BitSet();
        if (controllableAPStringIndex >= 0) {
            String begin = hoa.substring(controllableAPStringIndex + fieldName.length());
            String indices = begin.substring(0, begin.indexOf(10));
            for (String index : indices.split("\\s+")) {
                controllableAPIndices.set(Integer.parseInt(index));
            }
        }
        AtomicInteger uncontrollableApSize = new AtomicInteger(-1);
        Function<List<String>, ValuationSetFactory> factoryFunction = atomicPropositions -> {
            ArrayList<String> uncontrollableAp = new ArrayList<String>();
            ArrayList<String> controllableAp = new ArrayList<String>();
            int s = atomicPropositions.size();
            for (int i = 0; i < s; ++i) {
                if (controllableAPIndices.get(i)) {
                    controllableAp.add((String)atomicPropositions.get(i));
                    continue;
                }
                uncontrollableAp.add((String)atomicPropositions.get(i));
            }
            uncontrollableApSize.set(uncontrollableAp.size());
            uncontrollableAp.addAll(controllableAp);
            return CInterface.ENVIRONMENT.factorySupplier().getValuationSetFactory(uncontrollableAp);
        };
        DeterministicAutomatonWrapper<HoaReader.HoaState, ?> automaton = DeterministicAutomatonWrapper.of(HoaReader.read(hoa, factoryFunction), uncontrollableApSize.get());
        return ObjectHandles.getGlobal().create(automaton);
    }

    @CEntryPoint(name="automaton_of", documentation={"Translate the given formula to deterministic parity automaton. For greater performance it ", "is recommended to use the decomposed DPA construction and reassemble the DPA later.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula) {
        LabelledFormula formula = (LabelledFormula)ObjectHandles.getGlobal().get(cLabelledFormula);
        DeterministicAutomatonWrapper<?, ?> automaton = DeterministicAutomatonWrapper.of(formula);
        return ObjectHandles.getGlobal().create(automaton);
    }

    @CEntryPoint(name="automaton_acceptance_condition", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnAcceptance.class)
    public static Acceptance acceptanceCondition(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).acceptance;
    }

    @CEntryPoint(name="automaton_acceptance_condition_sets", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int acceptanceConditionSets(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return ((OmegaAcceptance)CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.acceptance()).acceptanceSets();
    }

    @CEntryPoint(name="automaton_atomic_propositions", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int atomicPropositions(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.factory().atomicPropositions().size();
    }

    @CEntryPoint(name="automaton_atomic_propositions_uncontrollable_size", documentation={"Atomic propositions of the range [0, s[ are uncontrollable and [s, l[ are controllable, where s is the value returned by this method. -1 is the default return value, when this value cannot be determined."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int atomicPropositionsUncontrollableSize(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).uncontrollableApSize;
    }

    @CEntryPoint(name="automaton_atomic_propositions_label", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnUnsignedWord.class)
    public static UnsignedWord atomicPropositions(IsolateThread thread, ObjectHandle cDeterministicAutomaton, int index, CCharPointer buffer, UnsignedWord bufferSize) {
        return CTypeConversion.toCString((CharSequence)CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.factory().atomicPropositions().get(index), (CCharPointer)buffer, (UnsignedWord)bufferSize);
    }

    @CEntryPoint(name="automaton_edge_tree_masking", documentation={"Return true if edge masking could speed up computation."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static boolean edgeTreeMasking(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.preferredEdgeAccess().get(0) == Automaton.PreferredEdgeAccess.EDGES;
    }

    @CEntryPoint(name="automaton_edge_tree", documentation={"Serialise the edges leaving the given state into a tree buffer, edge buffer, and an ", "optional score buffer. If the scores are not required, the pointer may be set to NULL.", "The pointer returned via the sized_{int,double}_array_t structures must be freed using", "the method `free_unmanaged_memory`."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnVoid.class)
    public static void edgeTree(IsolateThread thread, ObjectHandle cDeterministicAutomaton, int state, CIntArray cTreeBuffer, CIntArray cEdgeBuffer, CDoubleArray cScoreBuffer) {
        boolean computeScores = cScoreBuffer.isNonNull();
        cTreeBuffer.elements((CIntPointer)WordFactory.nullPointer());
        cTreeBuffer.length(Integer.MIN_VALUE);
        cEdgeBuffer.elements((CIntPointer)WordFactory.nullPointer());
        cEdgeBuffer.length(Integer.MIN_VALUE);
        if (cScoreBuffer.isNonNull()) {
            cScoreBuffer.elements((CDoublePointer)WordFactory.nullPointer());
            cScoreBuffer.length(Integer.MIN_VALUE);
        }
        SerialisedEdgeTree tree = CAutomaton.get(cDeterministicAutomaton).edgeTree(state, computeScores);
        tree.tree.moveToArray(cTreeBuffer);
        tree.edges.moveToArray(cEdgeBuffer);
        if (tree.scores != null) {
            tree.scores.moveToArray(cScoreBuffer);
        }
    }

    @CEntryPoint(name="automaton_is_singleton", documentation={"Returns true if the automaton only has one state, the initial state."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnBoolean.class)
    public static boolean isSingleton(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        Set<Integer> initialStateSuccessors = CAutomaton.get((ObjectHandle)cDeterministicAutomaton).initialStateSuccessors;
        return initialStateSuccessors != null && DecomposedDPA.Tree.Leaf.ALLOWED_CONJUNCTION_STATES_PATTERN.containsAll(initialStateSuccessors);
    }

    private static DeterministicAutomatonWrapper<?, ?> get(ObjectHandle cDeterministicAutomaton) {
        return (DeterministicAutomatonWrapper)ObjectHandles.getGlobal().get(cDeterministicAutomaton);
    }

    static class SerialisedEdgeTree {
        final CIntArrayList tree = new CIntArrayList();
        final CIntArrayList edges = new CIntArrayList();
        @Nullable
        final CDoubleArrayList scores;

        SerialisedEdgeTree(boolean computeScores) {
            this.scores = computeScores ? new CDoubleArrayList() : null;
        }
    }

    static final class DeterministicAutomatonWrapper<S, T> {
        static final int ACCEPTING = -2;
        static final int REJECTING = -1;
        static final int INITIAL = 0;
        static final int UNKNOWN = Integer.MIN_VALUE;
        final Automaton<S, ?> automaton;
        final Acceptance acceptance;
        final int uncontrollableApSize;
        private final Predicate<S> acceptingSink;
        private final List<S> index2StateMap;
        private final Object2IntMap<S> state2indexMap;
        private final ToDoubleFunction<Edge<S>> qualityScore;
        private final Function<S, T> canonicalizer;
        private final Object2IntMap<T> canonicalObjectId;
        @Nullable
        final ValuationTree<Edge<S>> initialStateEdgeTree;
        @Nullable
        final Set<Integer> initialStateSuccessors;
        @Nullable
        ValuationSet filter;

        private <A extends OmegaAcceptance> DeterministicAutomatonWrapper(Automaton<S, A> automaton, Acceptance acceptance, Class<A> acceptanceClassBound, Predicate<S> acceptingSink, Function<S, T> canonicalizer, ToDoubleFunction<Edge<S>> qualityScore, int uncontrollableApSize) {
            Preconditions.checkArgument((automaton.initialStates().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)acceptanceClassBound.isInstance(automaton.acceptance()));
            assert (automaton.is(Automaton.Property.DETERMINISTIC));
            this.automaton = automaton;
            this.acceptance = acceptance;
            this.acceptingSink = acceptingSink;
            this.qualityScore = qualityScore;
            this.index2StateMap = new ArrayList<S>();
            this.index2StateMap.add(this.automaton.onlyInitialState());
            this.state2indexMap = new Object2IntOpenHashMap();
            this.state2indexMap.put(this.automaton.onlyInitialState(), 0);
            this.state2indexMap.defaultReturnValue(Integer.MIN_VALUE);
            this.canonicalObjectId = new Object2IntOpenHashMap();
            this.canonicalObjectId.defaultReturnValue(Integer.MIN_VALUE);
            this.canonicalizer = canonicalizer;
            this.uncontrollableApSize = uncontrollableApSize;
            if (automaton.preferredEdgeAccess().get(0) == Automaton.PreferredEdgeAccess.EDGE_TREE) {
                this.initialStateEdgeTree = automaton.edgeTree(this.automaton.onlyInitialState());
                HashSet<Integer> reachableStatesIndices = new HashSet<Integer>();
                for (Set<Edge<S>> edges : this.initialStateEdgeTree.values()) {
                    if (edges.isEmpty()) {
                        reachableStatesIndices.add(-1);
                        continue;
                    }
                    reachableStatesIndices.add(this.index(((Edge)Iterables.getOnlyElement(edges)).successor()));
                }
                this.initialStateSuccessors = Set.of((Integer[])reachableStatesIndices.toArray(Integer[]::new));
            } else {
                this.initialStateEdgeTree = null;
                this.initialStateSuccessors = null;
            }
        }

        static <S, A extends OmegaAcceptance> DeterministicAutomatonWrapper<S, ?> of(Automaton<S, A> automaton, int uncontrollableApSize) {
            return new DeterministicAutomatonWrapper(automaton, Acceptance.fromOmegaAcceptance(automaton.acceptance()), automaton.acceptance().getClass(), x -> false, Function.identity(), x -> 0.5, uncontrollableApSize);
        }

        static DeterministicAutomatonWrapper<?, ?> of(LabelledFormula formula) {
            Collection<Formula> formulasDisj;
            Collection<Formula> formulasConj;
            LabelledFormula nnfFormula;
            LabelledFormula labelledFormula = nnfFormula = SyntacticFragment.NNF.contains(formula) ? formula : formula.nnf();
            if (SyntacticFragments.isSafety(nnfFormula.formula())) {
                return new DeterministicAutomatonWrapper(DeterministicConstructionsPortfolio.safety(CInterface.ENVIRONMENT, nnfFormula), Acceptance.SAFETY, AllAcceptance.class, EquivalenceClass::isTrue, Function.identity(), edge -> ((EquivalenceClass)edge.successor()).trueness(), -1);
            }
            if (SyntacticFragments.isCoSafety(nnfFormula.formula())) {
                return new DeterministicAutomatonWrapper(DeterministicConstructionsPortfolio.coSafety(CInterface.ENVIRONMENT, nnfFormula), Acceptance.CO_SAFETY, BuchiAcceptance.class, EquivalenceClass::isTrue, Function.identity(), edge -> ((EquivalenceClass)edge.successor()).trueness(), -1);
            }
            Collection<Formula> collection = formulasConj = nnfFormula.formula() instanceof Conjunction ? nnfFormula.formula().operands : Set.of(nnfFormula.formula());
            if (formulasConj.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
                return new DeterministicAutomatonWrapper<RoundRobinState, LabelledFormula>(DeterministicConstructionsPortfolio.gfCoSafety(CInterface.ENVIRONMENT, nnfFormula, false), Acceptance.BUCHI, GeneralizedBuchiAcceptance.class, x -> false, x -> nnfFormula, x -> x.inSet(0) ? 1.0 : 0.5, -1);
            }
            Collection<Formula> collection2 = formulasDisj = nnfFormula.formula() instanceof Disjunction ? nnfFormula.formula().operands : Set.of(nnfFormula.formula());
            if (formulasDisj.stream().allMatch(SyntacticFragments::isFgSafety)) {
                return new DeterministicAutomatonWrapper<RoundRobinState, LabelledFormula>(DeterministicConstructionsPortfolio.fgSafety(CInterface.ENVIRONMENT, nnfFormula, false), Acceptance.CO_BUCHI, GeneralizedCoBuchiAcceptance.class, x -> false, x -> nnfFormula, x -> x.inSet(0) ? 0.0 : 0.5, -1);
            }
            if (SyntacticFragments.isSafetyCoSafety(nnfFormula.formula())) {
                return new DeterministicAutomatonWrapper<DeterministicConstructions.BreakpointStateRejecting, EquivalenceClass>(DeterministicConstructionsPortfolio.safetyCoSafety(CInterface.ENVIRONMENT, nnfFormula), Acceptance.BUCHI, BuchiAcceptance.class, x -> x.all().isFalse() && x.all().isFalse(), DeterministicConstructions.BreakpointStateRejecting::all, x -> x.inSet(0) ? 1.0 : ((DeterministicConstructions.BreakpointStateRejecting)x.successor()).rejecting().trueness(), -1);
            }
            if (SyntacticFragments.isCoSafetySafety(nnfFormula.formula())) {
                return new DeterministicAutomatonWrapper<DeterministicConstructions.BreakpointStateAccepting, EquivalenceClass>(DeterministicConstructionsPortfolio.coSafetySafety(CInterface.ENVIRONMENT, nnfFormula), Acceptance.CO_BUCHI, CoBuchiAcceptance.class, x -> x.all().isTrue() && x.accepting().isTrue(), DeterministicConstructions.BreakpointStateAccepting::all, x -> x.inSet(0) ? 0.0 : ((DeterministicConstructions.BreakpointStateAccepting)x.successor()).accepting().trueness(), -1);
            }
            LTL2DPAFunction function = new LTL2DPAFunction(CInterface.ENVIRONMENT, EnumSet.of(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC));
            Automaton<?, ParityAcceptance> automaton = function.apply(nnfFormula);
            if (automaton.acceptance().parity() == ParityAcceptance.Parity.MIN_ODD) {
                return new DeterministicAutomatonWrapper<AnnotatedState, EquivalenceClass>(automaton, Acceptance.PARITY_MIN_ODD, ParityAcceptance.class, x -> ((EquivalenceClass)x.state()).isTrue(), AnnotatedState::state, x -> ((EquivalenceClass)((AnnotatedState)x.successor()).state()).trueness(), -1);
            }
            assert (automaton.acceptance().parity() == ParityAcceptance.Parity.MIN_EVEN);
            return new DeterministicAutomatonWrapper<AnnotatedState, EquivalenceClass>(automaton, Acceptance.PARITY_MIN_EVEN, ParityAcceptance.class, x -> ((EquivalenceClass)x.state()).isFalse(), AnnotatedState::state, x -> 1.0 - ((EquivalenceClass)((AnnotatedState)x.successor()).state()).trueness(), -1);
        }

        int normalise(int stateIndex) {
            if (stateIndex == -2) {
                return -2;
            }
            if (stateIndex == -1) {
                return -1;
            }
            T canonicalObject = this.canonicalizer.apply(this.index2StateMap.get(stateIndex));
            return this.canonicalObjectId.computeIntIfAbsent(canonicalObject, x -> this.canonicalObjectId.size());
        }

        private int index(@Nullable S state) {
            if (state == null) {
                return -1;
            }
            if (this.acceptingSink.test(state)) {
                return -2;
            }
            int index = this.state2indexMap.getInt(state);
            if (index == Integer.MIN_VALUE) {
                this.index2StateMap.add(state);
                this.state2indexMap.put(state, this.index2StateMap.size() - 1);
                index = this.index2StateMap.size() - 1;
            }
            return index;
        }

        private void serialise(ValuationTree<Edge<S>> edgeTree, SerialisedEdgeTree buffers, int treeBufferWriteBackPosition, Object2IntMap<ValuationTree<Edge<S>>> cachedPositions) {
            CIntArrayList treeBuffer = buffers.tree;
            int position = cachedPositions.getInt(edgeTree);
            if (position == Integer.MIN_VALUE) {
                if (edgeTree instanceof ValuationTree.Node) {
                    ValuationTree.Node node = (ValuationTree.Node)edgeTree;
                    position = treeBuffer.size();
                    treeBuffer.add(node.variable, -1, -1);
                    this.serialise(node.falseChild, buffers, position + 1, cachedPositions);
                    this.serialise(node.trueChild, buffers, position + 2, cachedPositions);
                } else {
                    Edge edge = (Edge)Iterables.getOnlyElement(((ValuationTree.Leaf)edgeTree).value, null);
                    CIntArrayList edgeBuffer = buffers.edges;
                    position = -(edgeBuffer.size() / 2 + 1);
                    if (edge == null) {
                        edgeBuffer.add(-1, -1);
                    } else {
                        edgeBuffer.add(this.index(edge.successor()), edge.largestAcceptanceSet());
                    }
                    CDoubleArrayList scoreBuffer = buffers.scores;
                    if (scoreBuffer != null) {
                        scoreBuffer.add(edge == null ? 0.0 : this.qualityScore.applyAsDouble(edge));
                    }
                }
                cachedPositions.put(edgeTree, position);
            }
            if (treeBufferWriteBackPosition >= 0) {
                treeBuffer.set(treeBufferWriteBackPosition, position);
            }
        }

        private static ValuationSet deserialise(CIntPointer tree, int length, ValuationSetFactory factory) {
            ValuationSet[] cache = new ValuationSet[length / 3];
            assert (3 * cache.length == length);
            for (int i = cache.length - 1; i >= 0; --i) {
                ValuationSet falseChildSet;
                int atomicProposition = tree.read(3 * i);
                int falseChild = tree.read(3 * i + 1);
                int trueChild = tree.read(3 * i + 2);
                ValuationSet valuationSet = falseChild >= 0 ? cache[falseChild / 3] : (falseChildSet = falseChild == -1 ? factory.empty() : factory.universe());
                ValuationSet trueChildSet = trueChild >= 0 ? cache[trueChild / 3] : (trueChild == -1 ? factory.empty() : factory.universe());
                ValuationSet trueBranch = factory.of(atomicProposition);
                ValuationSet falseBranch = trueBranch.complement();
                cache[i] = trueBranch.intersection(trueChildSet).union(falseBranch.intersection(falseChildSet));
            }
            return cache[0];
        }

        SerialisedEdgeTree edgeTree(int stateIndex, boolean computeScores) {
            ValuationTree<Edge<Object>> edgeTree;
            ValuationSet filter = this.filter;
            S state = this.index2StateMap.get(stateIndex);
            if (filter == null) {
                edgeTree = stateIndex == 0 && this.initialStateEdgeTree != null ? this.initialStateEdgeTree : this.automaton.edgeTree(state);
            } else if (this.automaton.preferredEdgeAccess().get(0) == Automaton.PreferredEdgeAccess.EDGES) {
                assert (this.initialStateEdgeTree == null);
                ValuationSetFactory factory = this.automaton.factory();
                HashMap<Edge<S>, ValuationSet> labelledEdges = new HashMap<Edge<S>, ValuationSet>();
                for (BitSet valuation : BitSets.powerSet((int)factory.atomicPropositions().size())) {
                    Edge<S> edge;
                    if (!filter.contains(valuation) || (edge = this.automaton.edge(state, valuation)) == null) continue;
                    labelledEdges.merge(edge, factory.of(valuation), ValuationSet::union);
                }
                edgeTree = factory.inverse(labelledEdges);
            } else {
                edgeTree = filter.filter(stateIndex == 0 && this.initialStateEdgeTree != null ? this.initialStateEdgeTree : this.automaton.edgeTree(state));
            }
            SerialisedEdgeTree serialisedEdgeTree = new SerialisedEdgeTree(computeScores);
            Object2IntOpenHashMap cachedPositions = new Object2IntOpenHashMap();
            cachedPositions.defaultReturnValue(Integer.MIN_VALUE);
            this.serialise(edgeTree, serialisedEdgeTree, -1, (Object2IntMap<ValuationTree<Edge<S>>>)cachedPositions);
            return serialisedEdgeTree;
        }
    }

    @CEnum(value="acceptance_t")
    public static enum Acceptance {
        BUCHI,
        CO_BUCHI,
        CO_SAFETY,
        PARITY,
        PARITY_MAX_EVEN,
        PARITY_MAX_ODD,
        PARITY_MIN_EVEN,
        PARITY_MIN_ODD,
        SAFETY,
        WEAK,
        BOTTOM;


        @CEnumValue
        public native int getCValue();

        @CEnumLookup
        public static native Acceptance fromCValue(int var0);

        public static Acceptance fromOmegaAcceptance(OmegaAcceptance acceptance) {
            if (acceptance instanceof AllAcceptance) {
                return SAFETY;
            }
            if (acceptance instanceof BuchiAcceptance) {
                return BUCHI;
            }
            if (acceptance instanceof CoBuchiAcceptance) {
                return CO_BUCHI;
            }
            if (acceptance instanceof ParityAcceptance) {
                ParityAcceptance parityAcceptance = (ParityAcceptance)acceptance;
                if (parityAcceptance.parity().even()) {
                    if (parityAcceptance.parity().max()) {
                        return PARITY_MAX_EVEN;
                    }
                    return PARITY_MIN_EVEN;
                }
                if (parityAcceptance.parity().max()) {
                    return PARITY_MAX_ODD;
                }
                return PARITY_MIN_ODD;
            }
            throw new IllegalArgumentException();
        }

        public Acceptance lub(Acceptance other) {
            if (this == BOTTOM || this == other) {
                return other;
            }
            switch (this) {
                case CO_SAFETY: {
                    return other == SAFETY ? WEAK : other;
                }
                case SAFETY: {
                    return other == CO_SAFETY ? WEAK : other;
                }
                case WEAK: {
                    return other == SAFETY || other == CO_SAFETY ? this : other;
                }
                case BUCHI: 
                case CO_BUCHI: {
                    return other == CO_SAFETY || other == SAFETY || other == WEAK ? this : PARITY;
                }
            }
            return PARITY;
        }

        public boolean isLessThanParity() {
            return this == BUCHI || this == CO_BUCHI || this.isLessOrEqualWeak();
        }

        public boolean isLessOrEqualWeak() {
            return this == CO_SAFETY || this == SAFETY || this == WEAK || this == BOTTOM;
        }
    }
}

