/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.collect.Iterables;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.graalvm.nativeimage.c.type.CIntPointer;
import owl.automaton.edge.Edge;
import owl.cinterface.CAutomaton;
import owl.cinterface.CDecomposedDPA;
import owl.cinterface.CInterface;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.ltl.rewriter.LiteralMapper;
import owl.ltl.rewriter.PullUpXVisitor;
import owl.ltl.util.FormulaIsomorphism;
import owl.ltl.visitors.PropositionalVisitor;

public final class DecomposedDPA {
    final Tree structure;
    final List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> automata;
    private final ImmutableIntArray leafIndices;
    private final Map<ImmutableIntArray, CDecomposedDPA.RealizabilityStatus> profiles = new HashMap<ImmutableIntArray, CDecomposedDPA.RealizabilityStatus>();

    private DecomposedDPA(Tree structure, List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> automata) {
        this.automata = automata;
        this.leafIndices = ImmutableIntArray.copyOf((IntStream)structure.leafIndices());
        this.structure = structure;
    }

    static DecomposedDPA of(LabelledFormula labelledFormula) {
        List<String> atomicPropositions = labelledFormula.atomicPropositions();
        TreeBuilder builder = new TreeBuilder(atomicPropositions);
        Tree tree = labelledFormula.formula().accept(builder);
        ValuationSetFactory globalFactory = CInterface.ENVIRONMENT.factorySupplier().getValuationSetFactory(atomicPropositions);
        Map<Tree, ValuationSet> filters = tree.computeFilter(builder.automata, null, globalFactory);
        tree.installFilter(builder.automata, null, builder.automataSharedWithDifferentAtomicPropositions, filters);
        return new DecomposedDPA(tree, List.copyOf(builder.automata));
    }

    boolean declare(CDecomposedDPA.RealizabilityStatus newStatus, CIntPointer profile, int length) {
        assert (newStatus == CDecomposedDPA.RealizabilityStatus.REALIZABLE || newStatus == CDecomposedDPA.RealizabilityStatus.UNREALIZABLE);
        CDecomposedDPA.RealizabilityStatus oldStatus = this.profiles.put(this.normalise(profile, length), newStatus);
        assert (oldStatus == null || oldStatus == newStatus);
        return oldStatus == null;
    }

    CDecomposedDPA.RealizabilityStatus query(CIntPointer profile, int length) {
        return this.profiles.getOrDefault(this.normalise(profile, length), CDecomposedDPA.RealizabilityStatus.UNKNOWN);
    }

    ImmutableIntArray normalise(CIntPointer profile, int length) {
        ImmutableIntArray.Builder builder = ImmutableIntArray.builder((int)length);
        int i = 0;
        Iterator iterator = this.leafIndices.asList().iterator();
        while (iterator.hasNext()) {
            int reference = (Integer)iterator.next();
            builder.add(this.automata.get(reference).normalise(profile.read(i)));
            ++i;
        }
        assert (length == i) : "Length mismatch.";
        return builder.build();
    }

    private static boolean isSingleStep(Formula formula) {
        if (formula instanceof Conjunction) {
            return formula.operands.stream().allMatch(DecomposedDPA::isSingleStep);
        }
        return formula instanceof GOperator && SyntacticFragment.SINGLE_STEP.contains(((GOperator)formula).operand());
    }

    static class Annotator
    extends PropositionalVisitor<Map<Formula, CAutomaton.Acceptance>> {
        static final Annotator INSTANCE = new Annotator();

        Annotator() {
        }

        @Override
        protected Map<Formula, CAutomaton.Acceptance> visit(Formula.TemporalOperator formula) {
            if (SyntacticFragments.isSafety(formula)) {
                return Map.of(formula, CAutomaton.Acceptance.SAFETY);
            }
            if (SyntacticFragments.isCoSafety(formula)) {
                return Map.of(formula, CAutomaton.Acceptance.CO_SAFETY);
            }
            if (SyntacticFragments.isSafetyCoSafety(formula)) {
                return Map.of(formula, CAutomaton.Acceptance.BUCHI);
            }
            if (SyntacticFragments.isCoSafetySafety(formula)) {
                return Map.of(formula, CAutomaton.Acceptance.CO_BUCHI);
            }
            return Map.of(formula, CAutomaton.Acceptance.PARITY);
        }

        @Override
        public Map<Formula, CAutomaton.Acceptance> visit(Biconditional biconditional) {
            HashMap<Formula, CAutomaton.Acceptance> acceptanceMap = new HashMap<Formula, CAutomaton.Acceptance>();
            acceptanceMap.putAll(biconditional.leftOperand().accept(this));
            acceptanceMap.putAll(biconditional.rightOperand().accept(this));
            CAutomaton.Acceptance leftAcceptance = (CAutomaton.Acceptance)((Object)acceptanceMap.get(biconditional.leftOperand()));
            CAutomaton.Acceptance rightAcceptance = (CAutomaton.Acceptance)((Object)acceptanceMap.get(biconditional.rightOperand()));
            if (leftAcceptance.lub(rightAcceptance).isLessOrEqualWeak()) {
                acceptanceMap.put(biconditional, CAutomaton.Acceptance.WEAK);
            } else {
                acceptanceMap.put(biconditional, CAutomaton.Acceptance.PARITY);
            }
            return acceptanceMap;
        }

        @Override
        public Map<Formula, CAutomaton.Acceptance> visit(BooleanConstant booleanConstant) {
            return Map.of(booleanConstant, CAutomaton.Acceptance.BOTTOM);
        }

        @Override
        public Map<Formula, CAutomaton.Acceptance> visit(Conjunction conjunction) {
            return this.visitPropositional(conjunction);
        }

        @Override
        public Map<Formula, CAutomaton.Acceptance> visit(Disjunction disjunction) {
            return this.visitPropositional(disjunction);
        }

        @Override
        public Map<Formula, CAutomaton.Acceptance> visit(Literal literal) {
            return Map.of(literal, CAutomaton.Acceptance.WEAK);
        }

        private Map<Formula, CAutomaton.Acceptance> visitPropositional(Formula.NaryPropositionalOperator formula) {
            CAutomaton.Acceptance acceptance = CAutomaton.Acceptance.BOTTOM;
            HashMap<Formula, CAutomaton.Acceptance> acceptanceMap = new HashMap<Formula, CAutomaton.Acceptance>();
            for (Formula child : formula.operands) {
                Map<Formula, CAutomaton.Acceptance> childDecisions = child.accept(this);
                acceptanceMap.putAll(childDecisions);
                acceptance = acceptance.lub((CAutomaton.Acceptance)((Object)acceptanceMap.get(child)));
            }
            acceptanceMap.put(formula, acceptance);
            return acceptanceMap;
        }
    }

    static abstract class Tree {
        Tree() {
        }

        abstract IntStream leafIndices();

        abstract Map<Tree, ValuationSet> computeFilter(List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> var1, @Nullable CDecomposedDPA.Structure.NodeType var2, ValuationSetFactory var3);

        abstract void installFilter(List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> var1, @Nullable ValuationSet var2, BitSet var3, Map<Tree, ValuationSet> var4);

        static final class Node
        extends Tree {
            final CDecomposedDPA.Structure.NodeType label;
            final List<Tree> children;

            Node(CDecomposedDPA.Structure.NodeType nodeType, List<Tree> children) {
                this.label = nodeType;
                this.children = List.copyOf(children);
            }

            @Override
            IntStream leafIndices() {
                return this.children.stream().flatMapToInt(Tree::leafIndices);
            }

            @Override
            Map<Tree, ValuationSet> computeFilter(List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> referencedAutomata, @Nullable CDecomposedDPA.Structure.NodeType context, ValuationSetFactory globalFactory) {
                if (this.label == CDecomposedDPA.Structure.NodeType.BICONDITIONAL) {
                    return Map.of();
                }
                assert (this.label == CDecomposedDPA.Structure.NodeType.CONJUNCTION || this.label == CDecomposedDPA.Structure.NodeType.DISJUNCTION);
                HashMap<Tree, ValuationSet> computedFilters = new HashMap<Tree, ValuationSet>();
                ValuationSet filter = globalFactory.universe();
                for (Tree child : this.children) {
                    Map<Tree, ValuationSet> computation = child.computeFilter(referencedAutomata, this.label, globalFactory);
                    computedFilters.putAll(computation);
                    ValuationSet childFilter = computation.get(child);
                    if (childFilter == null) continue;
                    filter = filter.intersection(childFilter);
                }
                if (!filter.isUniverse()) {
                    computedFilters.put(this, filter);
                }
                return computedFilters;
            }

            @Override
            void installFilter(List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> referencedAutomata, @Nullable ValuationSet globalFilter, BitSet sharedAutomata, Map<Tree, ValuationSet> computedFilters) {
                ValuationSet localFilter = computedFilters.get(this);
                ValuationSet filter = globalFilter == null ? localFilter : (localFilter == null ? globalFilter : globalFilter.intersection(localFilter));
                for (Tree child : this.children) {
                    child.installFilter(referencedAutomata, filter, sharedAutomata, computedFilters);
                }
            }
        }

        static final class Leaf
        extends Tree {
            static final Set<Integer> ALLOWED_CONJUNCTION_STATES_PATTERN = Set.of(Integer.valueOf(-1), Integer.valueOf(0));
            static final Set<Integer> ALLOWED_DISJUNCTION_STATES_PATTERN = Set.of(Integer.valueOf(-2), Integer.valueOf(0));
            final int index;
            final Formula formula;
            final ImmutableIntArray globalToLocalMapping;
            final ImmutableIntArray localToGlobalMapping;

            Leaf(int index, Formula formula, ImmutableIntArray globalToLocalMapping) {
                int[] localToGlobalMapping = new int[globalToLocalMapping.length()];
                int maxLocal = -1;
                for (int global = 0; global < localToGlobalMapping.length; ++global) {
                    int local = globalToLocalMapping.get(global);
                    if (local == -1) continue;
                    maxLocal = Math.max(maxLocal, local);
                    localToGlobalMapping[local] = global;
                }
                this.index = index;
                this.formula = formula;
                this.globalToLocalMapping = globalToLocalMapping;
                this.localToGlobalMapping = ImmutableIntArray.copyOf((int[])localToGlobalMapping).subArray(0, maxLocal + 1);
                assert (Leaf.isConsistent(this.globalToLocalMapping, this.localToGlobalMapping));
            }

            private static boolean isConsistent(ImmutableIntArray globalToLocalMapping, ImmutableIntArray localToGlobalMapping) {
                for (int global = 0; global < globalToLocalMapping.length(); ++global) {
                    int local = globalToLocalMapping.get(global);
                    if (local == -1 || global == localToGlobalMapping.get(local)) continue;
                    return false;
                }
                for (int local = 0; local < localToGlobalMapping.length(); ++local) {
                    int global = localToGlobalMapping.get(local);
                    if (local == globalToLocalMapping.get(global)) continue;
                    return false;
                }
                return true;
            }

            @Override
            IntStream leafIndices() {
                return IntStream.of(this.index);
            }

            @Override
            Map<Tree, ValuationSet> computeFilter(List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> referencedAutomata, @Nullable CDecomposedDPA.Structure.NodeType context, ValuationSetFactory globalFactory) {
                ValuationTree filter;
                if (context == null) {
                    return Map.of();
                }
                if (context != CDecomposedDPA.Structure.NodeType.CONJUNCTION && context != CDecomposedDPA.Structure.NodeType.DISJUNCTION) {
                    throw new AssertionError();
                }
                CAutomaton.DeterministicAutomatonWrapper<?, ?> automaton = referencedAutomata.get(this.index);
                Set<Integer> initialStateSuccessors = automaton.initialStateSuccessors;
                if (initialStateSuccessors == null) {
                    return Map.of();
                }
                if (context == CDecomposedDPA.Structure.NodeType.CONJUNCTION && ALLOWED_CONJUNCTION_STATES_PATTERN.containsAll(initialStateSuccessors)) {
                    filter = automaton.initialStateEdgeTree.map(x -> x.isEmpty() ? Set.of() : Set.of(Boolean.valueOf(true)));
                } else if (context == CDecomposedDPA.Structure.NodeType.DISJUNCTION && automaton.acceptance == CAutomaton.Acceptance.CO_SAFETY && ALLOWED_DISJUNCTION_STATES_PATTERN.containsAll(initialStateSuccessors)) {
                    Object initialState = automaton.automaton.onlyInitialState();
                    filter = automaton.initialStateEdgeTree.map(x -> initialState.equals(((Edge)Iterables.getOnlyElement((Iterable)x)).successor()) ? Set.of(Boolean.valueOf(true)) : Set.of());
                } else {
                    return Map.of();
                }
                return Map.of(this, filter.inverse(globalFactory, arg_0 -> ((ImmutableIntArray)this.localToGlobalMapping).get(arg_0)).getOrDefault(Boolean.TRUE, globalFactory.empty()));
            }

            @Override
            void installFilter(List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> referencedAutomata, @Nullable ValuationSet globalFilter, BitSet sharedAutomata, Map<Tree, ValuationSet> computedFilters) {
                if (globalFilter == null || computedFilters.containsKey(this)) {
                    return;
                }
                if (sharedAutomata.get(this.index)) {
                    return;
                }
                CAutomaton.DeterministicAutomatonWrapper<?, ?> referencedAutomaton = referencedAutomata.get(this.index);
                BitSet unusedAtomicPropositions = new BitSet();
                for (int i = 0; i < this.globalToLocalMapping.length(); ++i) {
                    if (this.globalToLocalMapping.get(i) != -1) continue;
                    unusedAtomicPropositions.set(i);
                }
                int globalApSize = globalFilter.factory().atomicPropositions().size();
                unusedAtomicPropositions.set(this.globalToLocalMapping.length(), globalApSize);
                ValuationSet newFilter = globalFilter.project(unusedAtomicPropositions).relabel(x -> x < this.globalToLocalMapping.length() ? this.globalToLocalMapping.get(x) : -1);
                if (newFilter.isUniverse()) {
                    return;
                }
                referencedAutomaton.filter = referencedAutomaton.filter == null ? newFilter : referencedAutomaton.filter.intersection(newFilter);
            }
        }
    }

    private static final class TreeBuilder
    extends PropositionalVisitor<Tree> {
        private final List<String> atomicPropositions;
        private final Map<Formula, CAutomaton.Acceptance> annotations = new HashMap<Formula, CAutomaton.Acceptance>();
        private final List<CAutomaton.DeterministicAutomatonWrapper<?, ?>> automata = new ArrayList();
        private final Map<Formula, Tree.Leaf> lookup = new HashMap<Formula, Tree.Leaf>();
        private final BitSet automataSharedWithDifferentAtomicPropositions = new BitSet();

        private TreeBuilder(List<String> atomicPropositions) {
            this.atomicPropositions = List.copyOf(atomicPropositions);
        }

        private Tree.Leaf createLeaf(Formula formula) {
            assert (SyntacticFragment.NNF.contains(formula));
            Tree.Leaf leaf = this.lookup.get(formula);
            if (leaf != null) {
                return leaf;
            }
            for (Map.Entry<Formula, Tree.Leaf> entry : this.lookup.entrySet()) {
                int[] mapping = FormulaIsomorphism.compute(formula, entry.getKey());
                if (mapping == null) continue;
                leaf = entry.getValue();
                int[] newMapping = Arrays.copyOf(mapping, mapping.length);
                for (int i = 0; i < newMapping.length; ++i) {
                    int j = newMapping[i];
                    if (j == -1) continue;
                    newMapping[i] = leaf.globalToLocalMapping.get(j);
                    assert (newMapping[i] != -1);
                }
                this.automataSharedWithDifferentAtomicPropositions.set(leaf.index);
                return new Tree.Leaf(leaf.index, formula, ImmutableIntArray.copyOf((int[])newMapping));
            }
            LiteralMapper.ShiftedLabelledFormula shiftedFormula = LiteralMapper.shiftLiterals(LabelledFormula.of(formula, this.atomicPropositions));
            leaf = new Tree.Leaf(this.automata.size(), formula, shiftedFormula.mapping);
            this.automata.add(CAutomaton.DeterministicAutomatonWrapper.of(shiftedFormula.formula));
            this.lookup.put(formula, leaf);
            return leaf;
        }

        private static boolean isInterestingOperator(Formula o) {
            return o instanceof Formula.TemporalOperator && !(o instanceof XOperator);
        }

        private List<Tree> createLeaves(Formula.NaryPropositionalOperator formula) {
            if (!this.annotations.containsKey(formula)) {
                this.annotations.putAll(formula.accept(Annotator.INSTANCE));
            }
            class Clusters {
                private final List<Set<Formula>> clusterList = new ArrayList<Set<Formula>>();

                Clusters() {
                }

                private void insert(Formula formula) {
                    HashSet<Formula> cluster = new HashSet<Formula>();
                    cluster.add(formula);
                    this.clusterList.removeIf(x -> {
                        Set temporalOperators2;
                        Set<Formula.TemporalOperator> temporalOperators1 = formula.subformulas(x$0 -> TreeBuilder.isInterestingOperator(x$0), Formula.TemporalOperator.class::cast);
                        if (!Collections.disjoint(temporalOperators1, temporalOperators2 = x.stream().flatMap(y -> y.subformulas(x$0 -> TreeBuilder.isInterestingOperator(x$0), Formula.TemporalOperator.class::cast).stream()).collect(Collectors.toSet()))) {
                            cluster.addAll((Collection<Formula>)x);
                            return true;
                        }
                        return false;
                    });
                    this.clusterList.add(cluster);
                }
            }
            Clusters safety = new Clusters();
            HashMap<Integer, Clusters> safetySingleStep = new HashMap<Integer, Clusters>();
            Clusters coSafety = new Clusters();
            TreeSet<Formula> weakOrBuchiOrCoBuchi = new TreeSet<Formula>();
            TreeSet<Formula> parity = new TreeSet<Formula>();
            block5: for (Formula x2 : formula.operands) {
                switch (this.annotations.get(x2)) {
                    case SAFETY: {
                        PullUpXVisitor.XFormula rewrittenX = x2.accept(PullUpXVisitor.INSTANCE);
                        if (DecomposedDPA.isSingleStep(rewrittenX.rawFormula())) {
                            safetySingleStep.computeIfAbsent(rewrittenX.depth(), ignore -> new Clusters()).insert(XOperator.of(rewrittenX.rawFormula(), rewrittenX.depth()));
                            continue block5;
                        }
                        safety.insert(x2);
                        continue block5;
                    }
                    case CO_SAFETY: {
                        coSafety.insert(x2);
                        continue block5;
                    }
                    case PARITY: {
                        parity.add(x2);
                        continue block5;
                    }
                }
                assert (this.annotations.get(x2).isLessThanParity());
                weakOrBuchiOrCoBuchi.add(x2);
            }
            ArrayList<Tree> children = new ArrayList<Tree>();
            Function<Collection, Formula> merger = formula instanceof Conjunction ? Conjunction::of : Disjunction::of;
            safetySingleStep.values().forEach(x -> x.clusterList.forEach(y -> {
                assert (!y.isEmpty());
                children.add(this.createLeaf((Formula)merger.apply((Collection)y)));
            }));
            safety.clusterList.forEach(x -> {
                assert (!x.isEmpty());
                children.add(this.createLeaf((Formula)merger.apply((Collection)x)));
            });
            coSafety.clusterList.forEach(x -> {
                assert (!x.isEmpty());
                children.add(this.createLeaf((Formula)merger.apply((Collection)x)));
            });
            for (Formula child : weakOrBuchiOrCoBuchi) {
                children.add(child.accept(this));
            }
            if (parity.size() == 1) {
                children.add(((Formula)parity.first()).accept(this));
            } else if (parity.size() > 1) {
                Formula mergedFormula = merger.apply(parity).nnf();
                children.add(this.createLeaf(mergedFormula));
            }
            return children;
        }

        @Override
        protected Tree visit(Formula.TemporalOperator formula) {
            return this.createLeaf(formula);
        }

        @Override
        public Tree visit(Literal literal) {
            return this.createLeaf(literal);
        }

        private boolean keepTreeStructureBiconditional(Formula formula) {
            if (formula instanceof Conjunction || formula instanceof Disjunction) {
                if (formula.operands.stream().filter(x -> this.annotations.get(x) == CAutomaton.Acceptance.PARITY).count() > 1L) {
                    return false;
                }
            } else {
                return false;
            }
            return formula.accept(new PropositionalVisitor<Boolean>(){

                @Override
                protected Boolean visit(Formula.TemporalOperator formula) {
                    return (SyntacticFragments.isAlmostAll(formula) || SyntacticFragments.isInfinitelyOften(formula)) && SyntacticFragment.SINGLE_STEP.contains(((Formula)formula.operands.get((int)0)).operands.get(0));
                }

                @Override
                public Boolean visit(Literal literal) {
                    return false;
                }

                @Override
                public Boolean visit(Biconditional biconditional) {
                    return biconditional.leftOperand().accept(this) != false && biconditional.rightOperand().accept(this) != false;
                }

                @Override
                public Boolean visit(Conjunction conjunction) {
                    return conjunction.operands.stream().allMatch(this::apply);
                }

                @Override
                public Boolean visit(Disjunction disjunction) {
                    return disjunction.operands.stream().allMatch(this::apply);
                }
            });
        }

        @Override
        public Tree visit(Biconditional biconditional) {
            if (this.annotations.get(biconditional.leftOperand()) == CAutomaton.Acceptance.PARITY && this.annotations.get(biconditional.rightOperand()) == CAutomaton.Acceptance.PARITY) {
                if (this.keepTreeStructureBiconditional(biconditional.leftOperand()) || this.keepTreeStructureBiconditional(biconditional.rightOperand())) {
                    return new Tree.Node(CDecomposedDPA.Structure.NodeType.BICONDITIONAL, List.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this)));
                }
                Formula nnf = biconditional.nnf();
                this.annotations.putAll(nnf.accept(Annotator.INSTANCE));
                return nnf.accept(this);
            }
            return new Tree.Node(CDecomposedDPA.Structure.NodeType.BICONDITIONAL, List.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this)));
        }

        @Override
        public Tree visit(BooleanConstant booleanConstant) {
            return this.createLeaf(booleanConstant);
        }

        @Override
        public Tree visit(Conjunction conjunction) {
            List<Tree> leaves = this.createLeaves(conjunction);
            return leaves.size() == 1 ? leaves.get(0) : new Tree.Node(CDecomposedDPA.Structure.NodeType.CONJUNCTION, leaves);
        }

        @Override
        public Tree visit(Disjunction disjunction) {
            List<Tree> leaves = this.createLeaves(disjunction);
            return leaves.size() == 1 ? leaves.get(0) : new Tree.Node(CDecomposedDPA.Structure.NodeType.DISJUNCTION, leaves);
        }
    }
}

