/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.naturals.bitset.BitSets;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.factories.jbdd.GcManagedFactory;

final class ValuationFactory
extends GcManagedFactory<BddValuationSet>
implements ValuationSetFactory {
    private static final BooleanExpression<AtomLabel> FALSE = new BooleanExpression(false);
    private static final BooleanExpression<AtomLabel> TRUE = new BooleanExpression(true);
    private final List<String> atomicPropositions;
    private final BddValuationSet empty;
    private final BddValuationSet universe;
    private final int trueNode;
    private final int falseNode;

    ValuationFactory(Bdd factory, List<String> atomicPropositions) {
        super(factory);
        this.atomicPropositions = List.copyOf(atomicPropositions);
        factory.createVariables(this.atomicPropositions.size());
        assert (factory.numberOfVariables() == this.atomicPropositions.size());
        this.trueNode = factory.trueNode();
        this.falseNode = factory.falseNode();
        this.universe = this.create(this.trueNode);
        this.empty = this.create(this.falseNode);
    }

    @Override
    public List<String> atomicPropositions() {
        return this.atomicPropositions;
    }

    @Override
    public ValuationSet empty() {
        return this.empty;
    }

    @Override
    public ValuationSet of(int literal) {
        return this.create(this.bdd.variableNode(literal));
    }

    @Override
    public ValuationSet of(BitSet valuation, BitSet restrictedAlphabet) {
        return this.create(this.createBdd(valuation, restrictedAlphabet));
    }

    @Override
    public ValuationSet of(BitSet valuation) {
        return this.create(this.createBdd(valuation));
    }

    @Override
    public ValuationSet universe() {
        return this.universe;
    }

    @Override
    public boolean contains(ValuationSet set, BitSet valuation) {
        return this.bdd.evaluate(this.getNode(set), valuation);
    }

    @Override
    public boolean implies(ValuationSet one, ValuationSet other) {
        return this.bdd.implies(this.getNode(one), this.getNode(other));
    }

    @Override
    public void forEach(ValuationSet set, Consumer<? super BitSet> action) {
        this.bdd.forEachSolution(this.getNode(set), action);
    }

    @Override
    public void forEach(ValuationSet set, BitSet restriction, Consumer<? super BitSet> action) {
        int variables = this.bdd.numberOfVariables();
        BitSet restrictedVariables = BitSets.copyOf((BitSet)restriction);
        restrictedVariables.flip(0, variables);
        int restrict = this.bdd.restrict(this.getNode(set), restrictedVariables, new BitSet());
        this.bdd.forEachPath(restrict, (solution, solutionSupport) -> {
            assert (!solution.intersects(restrictedVariables));
            solutionSupport.xor(restriction);
            BitSets.powerSet((BitSet)solutionSupport).forEach(nonRelevantValuation -> {
                solution.or((BitSet)nonRelevantValuation);
                action.accept((BitSet)solution);
                solution.andNot((BitSet)nonRelevantValuation);
            });
            solutionSupport.xor(restriction);
        });
    }

    @Override
    public boolean intersects(ValuationSet set, ValuationSet other) {
        return !this.bdd.implies(this.getNode(set), this.bdd.not(this.getNode(other)));
    }

    @Override
    public ValuationSet intersection(ValuationSet set1, ValuationSet set2) {
        return this.create(this.bdd.and(this.getNode(set1), this.getNode(set2)));
    }

    @Override
    public ValuationSet union(ValuationSet set1, ValuationSet set2) {
        return this.create(this.bdd.or(this.getNode(set1), this.getNode(set2)));
    }

    @Override
    public BooleanExpression<AtomLabel> toExpression(ValuationSet set) {
        return this.toExpression(this.getNode(set));
    }

    @Override
    public <S> ValuationTree<S> inverse(Map<S, ValuationSet> sets) {
        if (sets.isEmpty()) {
            return ValuationTree.of(List.of());
        }
        int offset = this.atomicPropositions.size();
        int requiredVariables = sets.size() - (this.bdd.numberOfVariables() - offset);
        if (requiredVariables > 0) {
            this.bdd.createVariables(requiredVariables);
        }
        int node = this.bdd.trueNode();
        List list = List.copyOf(sets.entrySet());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Map.Entry<S, ValuationSet> entry = list.get(i2);
            int relation = this.bdd.reference(this.bdd.equivalence(this.bdd.variableNode(offset + i2), this.getNode(entry.getValue())));
            node = this.bdd.consume(this.bdd.and(node, relation), node, relation);
        }
        ValuationTree<Object> result = this.inverseMemoized(node, new HashMap<Integer, ValuationTree<S>>(), i -> ((Map.Entry)list.get(i - offset)).getKey(), offset + list.size());
        this.bdd.dereference(node);
        return result;
    }

    @Override
    public Iterator<BitSet> iterator(ValuationSet set) {
        return this.bdd.solutionIterator(this.getNode(set));
    }

    private <S> ValuationTree<S> inverseMemoized(int node, Map<Integer, ValuationTree<S>> cache, IntFunction<S> mapper, int maxSize) {
        assert (node != this.bdd.trueNode());
        assert (node != this.bdd.falseNode());
        ValuationTree<Object> tree = cache.get(node);
        if (tree != null) {
            return tree;
        }
        int variable = this.bdd.variable(node);
        tree = variable < this.atomicPropositions().size() ? ValuationTree.of(variable, this.inverseMemoized(this.bdd.high(node), cache, mapper, maxSize), this.inverseMemoized(this.bdd.low(node), cache, mapper, maxSize)) : ValuationTree.of(this.getOnlySatisfyingAssignment(node, maxSize - 1).stream().mapToObj(mapper).collect(Collectors.toUnmodifiableSet()));
        cache.put(node, tree);
        return tree;
    }

    private BitSet getOnlySatisfyingAssignment(int node, int largestVariable) {
        assert (node != this.bdd.trueNode());
        assert (node != this.bdd.falseNode());
        int variable = this.bdd.variable(node);
        if (variable < largestVariable) {
            int high = this.bdd.high(node);
            if (high == this.bdd.falseNode()) {
                return this.getOnlySatisfyingAssignment(this.bdd.low(node), largestVariable);
            }
            assert (this.bdd.low(node) == this.bdd.falseNode());
            assert (high != this.bdd.trueNode());
            BitSet assignment = this.getOnlySatisfyingAssignment(high, largestVariable);
            assignment.set(variable);
            return assignment;
        }
        assert (variable == largestVariable);
        assert (this.bdd.trueNode() == this.bdd.low(node) || this.bdd.falseNode() == this.bdd.low(node));
        assert (this.bdd.trueNode() == this.bdd.high(node) || this.bdd.falseNode() == this.bdd.high(node));
        if (this.bdd.high(node) == this.bdd.trueNode()) {
            BitSet set = new BitSet();
            set.set(variable);
            return set;
        }
        return new BitSet();
    }

    private BooleanExpression<AtomLabel> toExpression(int node) {
        if (node == this.bdd.falseNode()) {
            return FALSE;
        }
        if (node == this.bdd.trueNode()) {
            return TRUE;
        }
        BooleanExpression letter = new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)this.bdd.variable(node)));
        BooleanExpression pos = this.toExpression(this.bdd.high(node));
        BooleanExpression neg = this.toExpression(this.bdd.low(node));
        if (pos.isTRUE()) {
            pos = letter;
        } else if (!pos.isFALSE()) {
            pos = letter.and(pos);
        }
        if (neg.isTRUE()) {
            neg = letter.not();
        } else if (!neg.isFALSE()) {
            neg = letter.not().and(neg);
        }
        if (pos.isFALSE()) {
            return neg;
        }
        if (neg.isFALSE()) {
            return pos;
        }
        return pos.or(neg);
    }

    private BddValuationSet create(int node) {
        return this.canonicalize(new BddValuationSet(this, node));
    }

    private int createBdd(BitSet set, BitSet base) {
        assert (base.length() <= this.atomicPropositions.size());
        int node = this.bdd.trueNode();
        int i = base.nextSetBit(0);
        while (i != -1) {
            node = this.createBddUpdateHelper(set, i, node);
            i = base.nextSetBit(i + 1);
        }
        return node;
    }

    private int createBdd(BitSet set) {
        int node = this.bdd.trueNode();
        for (int i = 0; i < this.atomicPropositions.size(); ++i) {
            node = this.createBddUpdateHelper(set, i, node);
        }
        return node;
    }

    private int createBddUpdateHelper(BitSet set, int var, int node) {
        int variableNode = this.bdd.variableNode(var);
        assert (this.bdd.isVariable(variableNode));
        return this.bdd.and(node, set.get(var) ? variableNode : this.bdd.not(variableNode));
    }

    private int getNode(ValuationSet vs) {
        assert (this.equals(vs.factory()));
        int node = ((BddValuationSet)vs).node;
        assert (this.bdd.getReferenceCount(node) > 0 || this.bdd.getReferenceCount(node) == -1);
        return node;
    }

    private <E> ValuationTree<E> filter(ValuationTree<E> tree, int bddNode) {
        if (bddNode == this.falseNode) {
            return ValuationTree.of();
        }
        if (bddNode == this.trueNode) {
            return tree;
        }
        int bddVariable = this.bdd.variable(bddNode);
        int bddHigh = this.bdd.high(bddNode);
        int bddLow = this.bdd.low(bddNode);
        if (tree instanceof ValuationTree.Leaf) {
            return ValuationTree.of(bddVariable, this.filter(tree, bddHigh), this.filter(tree, bddLow));
        }
        ValuationTree.Node node = (ValuationTree.Node)tree;
        if (bddVariable == node.variable) {
            return ValuationTree.of(node.variable, this.filter(node.trueChild, bddHigh), this.filter(node.falseChild, bddLow));
        }
        if (bddVariable < node.variable) {
            return ValuationTree.of(bddVariable, this.filter(tree, bddHigh), this.filter(tree, bddLow));
        }
        return ValuationTree.of(node.variable, this.filter(node.trueChild, bddNode), this.filter(node.falseChild, bddNode));
    }

    static final class BddValuationSet
    extends ValuationSet
    implements GcManagedFactory.BddNode {
        private final ValuationFactory factory;
        private final int node;

        private BddValuationSet(ValuationFactory bdd, int node) {
            this.factory = bdd;
            this.node = node;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.factory;
        }

        @Override
        public ValuationSet complement() {
            return this.factory.create(this.factory.bdd.not(this.node));
        }

        @Override
        public ValuationSet project(BitSet quantifiedAtomicPropositions) {
            return this.factory.create(this.factory.bdd.exists(this.node, quantifiedAtomicPropositions));
        }

        @Override
        public ValuationSet relabel(IntUnaryOperator mapping) {
            int size = this.factory.atomicPropositions.size();
            int[] subsitutions = new int[this.factory.atomicPropositions.size()];
            for (int i = 0; i < size; ++i) {
                int j = mapping.applyAsInt(i);
                if (j == -1) {
                    subsitutions[i] = -1;
                    continue;
                }
                if (0 <= j && j < size) {
                    subsitutions[i] = this.factory.bdd.variableNode(j);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid mapping: {0} -> {1}", i, j));
            }
            return this.factory.create(this.factory.bdd.compose(this.node, subsitutions));
        }

        @Override
        public <E> ValuationTree<E> filter(ValuationTree<E> tree) {
            return this.factory.filter(tree, this.node);
        }

        @Override
        public int node() {
            return this.node;
        }

        @Override
        public BigInteger size() {
            return this.factory.bdd.countSatisfyingAssignments(this.node);
        }

        public boolean equals(Object obj) {
            assert (!(obj instanceof ValuationSet) || ((ValuationSet)obj).factory() == this.factory());
            return this == obj;
        }
    }
}

