/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.algorithms;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.translations.LTL2NAFunction;

public final class LanguageAnalysis {
    private LanguageAnalysis() {
    }

    public static boolean isSatisfiable(Formula formula) {
        if (formula instanceof Disjunction) {
            return formula.operands.stream().anyMatch(LanguageAnalysis::isSatisfiable);
        }
        LabelledFormula labelledFormula = LanguageAnalysis.attachDummyAlphabet(formula);
        LTL2NAFunction translation = new LTL2NAFunction(GeneralizedBuchiAcceptance.class, Environment.of(false));
        return !LanguageEmptiness.isEmpty(translation.apply(labelledFormula));
    }

    public static boolean isUnsatisfiable(Formula formula) {
        return !LanguageAnalysis.isSatisfiable(formula);
    }

    public static boolean isUniversal(Formula formula) {
        return LanguageAnalysis.isUnsatisfiable(formula.not());
    }

    private static LabelledFormula attachDummyAlphabet(Formula formula) {
        return LabelledFormula.of(formula, IntStream.range(0, formula.atomicPropositions(true).length()).mapToObj(i -> "p" + i).collect(Collectors.toUnmodifiableList()));
    }
}

