/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerPrint;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.extensions.ToStateAcceptanceFixed;
import jhoafparser.storage.StoredAutomatonManipulator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.hoa.HoaWriter;
import owl.run.modules.OwlModule;

public final class OutputWriters {
    public static final OwlModule<OwlModule.OutputWriter> AUTOMATON_STATS_MODULE = OwlModule.of("aut-stat", "Writes several stats of a given automaton to the given format string", () -> {
        Option format = new Option("f", "format", true, "The format string. Uses a reduced set of the spot syntax\n%A, %a   Number of acceptance sets\n%C, %c   Number of SCCs\n%D, %d   1 if the automaton is deterministic, 0 otherwise\n%G, %g   acceptance condition (in HOA syntax)\n%S, %s   Number of states\n%H, %h   The automaton in HOA format on a single line\n%M, %m   Name of the automaton\n%n       Newline\n%X, %x   Number of atomic propositions");
        format.setRequired(true);
        return new Options().addOption(format);
    }, (commandLine, environment) -> new AutomatonStats(commandLine.getOptionValue("format")));
    public static final OwlModule<OwlModule.OutputWriter> HOA_OUTPUT_MODULE = OwlModule.of("hoa", "Writes the HOA format representation of an automaton.", () -> {
        Option option = new Option("s", "state-acceptance", false, "Output an automaton with state-acceptance instead of transition acceptance.");
        return new Options().addOption(option);
    }, (commandLine, environment) -> new ToHoa(environment.annotations(), commandLine.hasOption("state-acceptance")));
    public static final OwlModule<OwlModule.OutputWriter> NULL_MODULE = OwlModule.of("null", "Discards the output - useful for performance testing", (commandLine, environment) -> (writer, object) -> writer.flush());
    public static final OwlModule<OwlModule.OutputWriter> TO_STRING_MODULE = OwlModule.of("string", "Prints the toString() representation of all passed objects", (commandLine, environment) -> (writer, object) -> {
        writer.write(object.toString());
        writer.write(System.lineSeparator());
    });

    private OutputWriters() {
    }

    public static class ToHoa
    implements OwlModule.OutputWriter {
        private final boolean annotations;
        private final boolean stateAcceptance;

        public ToHoa(boolean annotations, boolean stateAcceptance) {
            this.annotations = annotations;
            this.stateAcceptance = stateAcceptance;
        }

        @Override
        public void write(Writer writer, Object object) {
            HOAConsumerPrint printer = new HOAConsumerPrint(writer);
            HOAConsumerPrint wrappedPrinter = this.stateAcceptance ? new HOAIntermediateStoreAndManipulate((HOAConsumer)printer, new StoredAutomatonManipulator[]{new ToStateAcceptanceFixed()}) : printer;
            EnumSet<HoaWriter.HoaOption> options = this.annotations ? EnumSet.of(HoaWriter.HoaOption.ANNOTATIONS) : EnumSet.noneOf(HoaWriter.HoaOption.class);
            HoaWriter.write((Automaton)object, (HOAConsumer)wrappedPrinter, options);
        }
    }

    public static class AutomatonStats
    implements OwlModule.OutputWriter {
        private static final Map<Pattern, Function<Automaton<?, ?>, String>> patterns = Map.of(Pattern.compile("%G", 18), automaton -> ((OmegaAcceptance)automaton.acceptance()).booleanExpression().toString(), Pattern.compile("%A", 18), automaton -> String.valueOf(((OmegaAcceptance)automaton.acceptance()).acceptanceSets()), Pattern.compile("%D", 18), automaton -> automaton.is(Automaton.Property.DETERMINISTIC) ? "1" : "0", Pattern.compile("%H", 18), automaton -> HoaWriter.toString(automaton).replace('\n', ' '), Pattern.compile("%M", 18), Automaton::name, Pattern.compile("%S", 18), automaton -> String.valueOf(automaton.size()), Pattern.compile("%X", 18), automaton -> String.valueOf(automaton.factory().atomicPropositions().size()), Pattern.compile("%C", 18), automaton -> String.valueOf(SccDecomposition.of(automaton).sccs().size()), Pattern.compile("%n", 16), automaton -> "\n");
        private final String formatString;

        public AutomatonStats(String formatString) {
            this.formatString = formatString;
        }

        @Override
        public void write(Writer writer, Object object) throws IOException {
            Preconditions.checkArgument((boolean)(object instanceof Automaton));
            Automaton automaton = (Automaton)object;
            String result = this.formatString;
            for (Map.Entry<Pattern, Function<Automaton<?, ?>, String>> pattern : patterns.entrySet()) {
                Matcher matcher = pattern.getKey().matcher(result);
                if (!matcher.find()) continue;
                String replacement = Matcher.quoteReplacement(pattern.getValue().apply(automaton));
                result = matcher.replaceAll(replacement);
            }
            writer.write(result);
        }
    }
}

