/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.delag.DelagBuilder;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.ltl2dra.SymmetricDRAConstruction;

public final class LTL2DAFunction
implements Function<LabelledFormula, Automaton<?, ?>> {
    private static final Set<Class<? extends OmegaAcceptance>> SUPPORTED_ACCEPTANCE_CONDITIONS = Set.of(EmersonLeiAcceptance.class, GeneralizedRabinAcceptance.class, RabinAcceptance.class, ParityAcceptance.class, OmegaAcceptance.class);
    private final Function<LabelledFormula, ? extends Automaton<?, ?>> fallback;
    private final DeterministicConstructionsPortfolio<?> portfolio;

    public LTL2DAFunction(Environment environment) {
        this(OmegaAcceptance.class, environment);
    }

    public LTL2DAFunction(Class<? extends OmegaAcceptance> acceptance, Environment environment) {
        Preconditions.checkArgument((boolean)SUPPORTED_ACCEPTANCE_CONDITIONS.contains(acceptance), (String)"%s is not in the set %s of supported acceptance conditions.", acceptance, SUPPORTED_ACCEPTANCE_CONDITIONS);
        this.portfolio = new DeterministicConstructionsPortfolio<OmegaAcceptance>(acceptance, environment);
        if (OmegaAcceptance.class.equals(acceptance) || EmersonLeiAcceptance.class.equals(acceptance)) {
            this.fallback = new DelagBuilder(environment);
        } else if (GeneralizedRabinAcceptance.class.equals(acceptance)) {
            this.fallback = SymmetricDRAConstruction.of(environment, GeneralizedRabinAcceptance.class, true);
        } else if (RabinAcceptance.class.equals(acceptance)) {
            this.fallback = SymmetricDRAConstruction.of(environment, RabinAcceptance.class, true);
        } else {
            assert (ParityAcceptance.class.equals(acceptance));
            this.fallback = new LTL2DPAFunction(environment, EnumSet.copyOf(LTL2DPAFunction.RECOMMENDED_ASYMMETRIC_CONFIG));
        }
    }

    @Override
    public Automaton<?, ?> apply(LabelledFormula formula) {
        Optional<Automaton<?, ?>> portfolioResult = this.portfolio.apply(formula);
        if (portfolioResult.isPresent()) {
            return portfolioResult.orElseThrow();
        }
        return this.fallback.apply(formula);
    }
}

