/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.visitors.Visitor;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Predicates;

public final class Selector {
    private Selector() {
    }

    public static Set<Fixpoints> selectAsymmetric(Formula formula, boolean all) {
        if (all) {
            return Sets.powerSet(Selector.selectGreatestFixpoints(formula)).stream().map(x -> Fixpoints.of(Set.of(), x)).collect(Collectors.toSet());
        }
        return NormalForms.toDnf(formula, NormalForms.SYNTHETIC_CO_SAFETY_LITERAL).stream().flatMap(Selector::selectAsymmetricFromClause).collect(Collectors.toSet());
    }

    public static Set<Fixpoints> selectSymmetric(Formula formula, boolean all) {
        if (all) {
            return Sets.powerSet(Selector.selectAllFixpoints(formula)).stream().map(Fixpoints::of).collect(Collectors.toSet());
        }
        return NormalForms.toDnf(formula, NormalForms.SYNTHETIC_CO_SAFETY_LITERAL).stream().flatMap(Selector::selectSymmetricFromClause).collect(Collectors.toSet());
    }

    private static Stream<Fixpoints> selectAsymmetricFromClause(Set<Formula> clause) {
        ArrayList<Set> elementSets = new ArrayList<Set>();
        for (Formula element : clause) {
            assert (Selector.isClauseElement(element));
            Set<Formula.TemporalOperator> fixpoints = Selector.selectGreatestFixpoints(element);
            if (fixpoints.isEmpty()) continue;
            elementSets.add(Sets.powerSet(fixpoints));
        }
        ArrayList<Fixpoints> fixpointsList = new ArrayList<Fixpoints>();
        for (List combination : Sets.cartesianProduct(elementSets)) {
            HashSet union = new HashSet();
            combination.forEach(union::addAll);
            fixpointsList.add(Fixpoints.of(Set.of(), union));
        }
        return fixpointsList.stream();
    }

    private static Stream<Fixpoints> selectSymmetricFromClause(Set<Formula> clause) {
        ArrayList<Fixpoints> fixpointsList = new ArrayList<Fixpoints>();
        ArrayList<Set> elementSets = new ArrayList<Set>();
        for (Formula element : clause) {
            assert (Selector.isClauseElement(element));
            if (SyntacticFragments.isCoSafety(element)) continue;
            HashSet<Formula.TemporalOperator> fixpoints = new HashSet<Formula.TemporalOperator>();
            UnscopedVisitor visitor = new UnscopedVisitor(fixpoints);
            element.accept(visitor);
            elementSets.add(Sets.powerSet(fixpoints));
        }
        for (List combination : Sets.cartesianProduct(elementSets)) {
            HashSet union = new HashSet();
            combination.forEach(union::addAll);
            fixpointsList.add(Fixpoints.of(union));
        }
        return fixpointsList.stream();
    }

    private static boolean isClauseElement(Formula formula) {
        return SyntacticFragments.isCoSafety(formula) || formula instanceof Formula.TemporalOperator;
    }

    private static Set<Formula.TemporalOperator> selectAllFixpoints(Formula formula) {
        return formula.subformulas(Predicates.IS_FIXPOINT, Formula.TemporalOperator.class::cast);
    }

    private static Set<Formula.TemporalOperator> selectGreatestFixpoints(Formula formula) {
        return formula.subformulas(Predicates.IS_GREATEST_FIXPOINT, Formula.TemporalOperator.class::cast);
    }

    private static class GScopedVisitor
    extends AbstractSymmetricVisitor {
        private final Set<Formula.TemporalOperator> fixpoints;

        private GScopedVisitor(Set<Formula.TemporalOperator> fixpoints) {
            this.fixpoints = fixpoints;
        }

        @Override
        public Void visit(FOperator fOperator) {
            this.fixpoints.addAll(Selector.selectAllFixpoints(fOperator));
            return null;
        }

        @Override
        public Void visit(GOperator gOperator) {
            return gOperator.operand().accept(this);
        }

        @Override
        public Void visit(MOperator mOperator) {
            this.fixpoints.addAll(Selector.selectAllFixpoints(mOperator));
            return null;
        }

        @Override
        public Void visit(ROperator rOperator) {
            rOperator.leftOperand().accept(this);
            rOperator.rightOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(UOperator uOperator) {
            this.fixpoints.addAll(Selector.selectAllFixpoints(uOperator));
            return null;
        }

        @Override
        public Void visit(WOperator wOperator) {
            wOperator.leftOperand().accept(this);
            wOperator.rightOperand().accept(this);
            return null;
        }
    }

    private static final class UnscopedVisitor
    extends AbstractSymmetricVisitor {
        private final GScopedVisitor gScopedVisitor;

        private UnscopedVisitor(Set<Formula.TemporalOperator> fixpoints) {
            this.gScopedVisitor = new GScopedVisitor(fixpoints);
        }

        @Override
        public Void visit(FOperator fOperator) {
            return fOperator.operand().accept(this);
        }

        @Override
        public Void visit(GOperator gOperator) {
            return gOperator.operand().accept(this.gScopedVisitor);
        }

        @Override
        public Void visit(MOperator mOperator) {
            mOperator.leftOperand().accept(this);
            mOperator.rightOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(ROperator rOperator) {
            rOperator.leftOperand().accept(this);
            rOperator.rightOperand().accept(this.gScopedVisitor);
            return null;
        }

        @Override
        public Void visit(UOperator uOperator) {
            uOperator.leftOperand().accept(this);
            uOperator.rightOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(WOperator wOperator) {
            wOperator.leftOperand().accept(this.gScopedVisitor);
            wOperator.rightOperand().accept(this);
            return null;
        }
    }

    private static abstract class AbstractSymmetricVisitor
    implements Visitor<Void> {
        private AbstractSymmetricVisitor() {
        }

        @Override
        public Void visit(Conjunction conjunction) {
            conjunction.operands.forEach(x -> x.accept(this));
            return null;
        }

        @Override
        public Void visit(Disjunction disjunction) {
            disjunction.operands.forEach(x -> x.accept(this));
            return null;
        }

        @Override
        public final Void visit(Literal literal) {
            return null;
        }

        @Override
        public final Void visit(XOperator xOperator) {
            return xOperator.operand().accept(this);
        }
    }
}

