/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.run.Environment;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.ltl2dra.SymmetricDRAConstruction;
import owl.translations.modules.AbstractLTL2DRAModule;
import owl.translations.modules.AbstractLTL2PortfolioModule;
import owl.translations.rabinizer.RabinizerBuilder;
import owl.translations.rabinizer.RabinizerConfiguration;

public final class LTL2DGRAModule {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("ltl2dgra", "Translate LTL to deterministic generalized Rabin automata using either a symmetric construction (default) based on a unified approach using the Master Theorem or an asymmetric construction, also known as the \"Rabinizer construction\".", AbstractLTL2DRAModule.options(), (commandLine, environment) -> {
        RabinizerConfiguration configuration = AbstractLTL2DRAModule.parseAsymmetric(commandLine);
        boolean useSymmetric = configuration == null;
        boolean usePortfolio = AbstractLTL2PortfolioModule.usePortfolio(commandLine);
        return OwlModule.LabelledFormulaTransformer.of(LTL2DGRAModule.translation(environment, useSymmetric, usePortfolio, configuration));
    });

    private LTL2DGRAModule() {
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.LTL_INPUT_MODULE, List.of(SimplifierTransformer.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    public static Function<LabelledFormula, Automaton<?, GeneralizedRabinAcceptance>> translation(Environment environment, boolean useSymmetric, boolean usePortfolio, @Nullable RabinizerConfiguration configuration) {
        Function<LabelledFormula, Automaton> construction;
        if (useSymmetric) {
            construction = SymmetricDRAConstruction.of(environment, GeneralizedRabinAcceptance.class, true)::apply;
        } else {
            assert (configuration != null);
            construction = labelledFormula -> RabinizerBuilder.build(labelledFormula, environment, configuration);
        }
        DeterministicConstructionsPortfolio<GeneralizedRabinAcceptance> portfolio = usePortfolio ? new DeterministicConstructionsPortfolio<GeneralizedRabinAcceptance>(GeneralizedRabinAcceptance.class, environment) : null;
        return labelledFormula -> {
            Optional automaton;
            if (portfolio != null && (automaton = portfolio.apply((LabelledFormula)labelledFormula)).isPresent()) {
                return automaton.orElseThrow();
            }
            return (Automaton)construction.apply((LabelledFormula)labelledFormula);
        };
    }
}

