/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.run.Environment;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.modules.AbstractLTL2LDBAModule;
import owl.translations.modules.AbstractLTL2PortfolioModule;

public final class LTL2DPAModule {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("ltl2dpa", "Translate LTL to deterministic parity automata, using LDBA constructions.", LTL2DPAModule.options(), (commandLine, environment) -> {
        boolean useSymmetric = commandLine.hasOption(AbstractLTL2LDBAModule.symmetric().getOpt());
        boolean useComplement = !commandLine.hasOption("disable-complement");
        boolean usePortfolio = AbstractLTL2PortfolioModule.usePortfolio(commandLine);
        return OwlModule.LabelledFormulaTransformer.of(LTL2DPAModule.translation(environment, useSymmetric, useComplement, usePortfolio));
    });

    private LTL2DPAModule() {
    }

    private static Options options() {
        return new Options().addOptionGroup(AbstractLTL2LDBAModule.getOptionGroup()).addOption(null, "disable-complement", false, "Disable the parallel computation of a DPA for the negation of the formula. If the parallel computation is left not disabled, then two DPAs are computed and the smaller (number of states) is returned.").addOption(AbstractLTL2PortfolioModule.disablePortfolio());
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.LTL_INPUT_MODULE, List.of(SimplifierTransformer.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    public static Function<LabelledFormula, Automaton<?, ParityAcceptance>> translation(Environment environment, boolean useSymmetric, boolean useComplement, boolean usePortfolio) {
        EnumSet<LTL2DPAFunction.Configuration> configuration = EnumSet.of(LTL2DPAFunction.Configuration.OPTIMISE_INITIAL_STATE);
        if (useComplement) {
            configuration.add(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_EXACT);
        }
        if (useSymmetric) {
            configuration.add(LTL2DPAFunction.Configuration.SYMMETRIC);
        }
        configuration.add(LTL2DPAFunction.Configuration.COMPRESS_COLOURS);
        LTL2DPAFunction construction = new LTL2DPAFunction(environment, configuration);
        DeterministicConstructionsPortfolio<ParityAcceptance> portfolio = usePortfolio ? new DeterministicConstructionsPortfolio<ParityAcceptance>(ParityAcceptance.class, environment) : null;
        return labelledFormula -> {
            Optional automaton;
            if (portfolio != null && (automaton = portfolio.apply((LabelledFormula)labelledFormula)).isPresent()) {
                return automaton.orElseThrow();
            }
            return construction.apply((LabelledFormula)labelledFormula);
        };
    }
}

