/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.common.collect.BiMap;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import owl.collections.Pair;
import owl.util.BitSetUtil;

final class SubsumedStatesMap {
    private final Map<Integer, BitSet> mask;

    private SubsumedStatesMap(Map<Integer, BitSet> mask) {
        this.mask = mask;
    }

    public void removeSubsumed(int i, BitSet bs) {
        if (!this.mask.containsKey(i)) {
            return;
        }
        bs.andNot(this.mask.get(i));
    }

    public void addSubsumed(int i, BitSet bs) {
        if (!this.mask.containsKey(i)) {
            return;
        }
        bs.or(this.mask.get(i));
    }

    public static <S> SubsumedStatesMap of(BiMap<S, Integer> stateMap, Set<Pair<S, S>> incls) {
        HashMap<Integer, BitSet> mask = new HashMap<Integer, BitSet>();
        incls.forEach(p -> {
            int b;
            int a = (Integer)stateMap.get(p.fst());
            if (a != (b = ((Integer)stateMap.get(p.snd())).intValue())) {
                if (!mask.containsKey(b)) {
                    mask.put(b, new BitSet());
                }
                ((BitSet)mask.get(b)).set(a);
            }
        });
        return new SubsumedStatesMap(mask);
    }

    public static SubsumedStatesMap empty() {
        return new SubsumedStatesMap(new HashMap<Integer, BitSet>());
    }

    public boolean isEmpty() {
        return this.mask.isEmpty();
    }

    public <S> String toString(Function<Integer, S> stmap) {
        StringBuilder sb = new StringBuilder();
        this.mask.entrySet().stream().map(e -> stmap.apply((Integer)e.getKey()) + " > " + BitSetUtil.toSet((BitSet)e.getValue(), stmap) + "\n").forEach(sb::append);
        return sb.toString();
    }
}

