/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.EdgeMapAutomatonMixin;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.ltl.GOperator;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MonitorState;

class MonitorAutomaton
implements EdgeMapAutomatonMixin<MonitorState, AllAcceptance> {
    private final Automaton<MonitorState, ParityAcceptance> anyAutomaton;
    private final Map<GSet, Automaton<MonitorState, ParityAcceptance>> automata;
    private final GSet base;
    private final GOperator formula;

    MonitorAutomaton(GOperator formula, Map<GSet, Automaton<MonitorState, ParityAcceptance>> automata) {
        this.automata = Map.copyOf(automata);
        this.formula = formula;
        HashSet<GOperator> baseBuilder = new HashSet<GOperator>();
        for (GSet relevantSet : this.automata.keySet()) {
            baseBuilder.addAll(relevantSet);
        }
        this.base = new GSet(baseBuilder);
        this.anyAutomaton = automata.values().iterator().next();
    }

    @Override
    public AllAcceptance acceptance() {
        return AllAcceptance.INSTANCE;
    }

    Map<GSet, Automaton<MonitorState, ParityAcceptance>> getAutomata() {
        return this.automata;
    }

    public Automaton<MonitorState, ParityAcceptance> getAutomaton(GSet gSet) {
        GSet intersection = this.base.intersection(gSet);
        Automaton<MonitorState, ParityAcceptance> result = this.automata.get(intersection);
        assert (result != null) : String.format("No automaton found for gSet %s with base %s", gSet, this.base);
        return result;
    }

    @Override
    public ValuationSetFactory factory() {
        return this.anyAutomaton.factory();
    }

    @Override
    public Set<MonitorState> initialStates() {
        return this.anyAutomaton.initialStates();
    }

    @Override
    public Map<Edge<MonitorState>, ValuationSet> edgeMap(MonitorState state) {
        return Collections3.transformMap(this.anyAutomaton.edgeMap(state), Edge::withoutAcceptance);
    }

    @Override
    public String name() {
        return "Monitor for " + this.formula + " with base " + this.base;
    }

    @Override
    public Set<MonitorState> states() {
        return this.anyAutomaton.states();
    }

    @Override
    @Nullable
    public MonitorState successor(MonitorState state, BitSet valuation) {
        return this.anyAutomaton.successor(state, valuation);
    }

    @Override
    public Set<MonitorState> successors(MonitorState state) {
        return this.anyAutomaton.successors(state);
    }
}

