/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;

public final class BooleanExpressions {
    private BooleanExpressions() {
    }

    public static <T extends Atom> boolean evaluate(BooleanExpression<T> expression, Predicate<T> valuation) {
        if (expression.isTRUE()) {
            return true;
        }
        if (expression.isFALSE()) {
            return true;
        }
        if (expression.isAtom()) {
            return valuation.test(expression.getAtom());
        }
        if (expression.isNOT()) {
            return !BooleanExpressions.evaluate(expression.getLeft(), valuation);
        }
        if (expression.isAND()) {
            return BooleanExpressions.evaluate(expression.getLeft(), valuation) && BooleanExpressions.evaluate(expression.getRight(), valuation);
        }
        if (expression.isOR()) {
            return BooleanExpressions.evaluate(expression.getLeft(), valuation) || BooleanExpressions.evaluate(expression.getRight(), valuation);
        }
        throw new AssertionError((Object)("Encountered unknown expression " + expression));
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Iterable<BooleanExpression<T>> conjuncts) {
        return BooleanExpressions.createConjunction(conjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Stream<BooleanExpression<T>> conjuncts) {
        return BooleanExpressions.createConjunction(conjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Iterator<BooleanExpression<T>> conjuncts) {
        if (!conjuncts.hasNext()) {
            return new BooleanExpression(true);
        }
        BooleanExpression conjunction = conjuncts.next();
        while (conjuncts.hasNext()) {
            conjunction = conjunction.and(conjuncts.next());
        }
        return conjunction;
    }

    public static <T extends Atom> BooleanExpression<T> createDisjunction(Iterable<BooleanExpression<T>> disjuncts) {
        return BooleanExpressions.createDisjunction(disjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createDisjunction(Stream<BooleanExpression<T>> disjuncts) {
        return BooleanExpressions.createDisjunction(disjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createDisjunction(Iterator<BooleanExpression<T>> disjuncts) {
        if (!disjuncts.hasNext()) {
            return new BooleanExpression(false);
        }
        BooleanExpression disjunction = disjuncts.next();
        while (disjuncts.hasNext()) {
            disjunction = disjunction.or(disjuncts.next());
        }
        return disjunction;
    }

    public static <T extends Atom> List<BooleanExpression<T>> getConjuncts(BooleanExpression<T> exp) {
        if (exp.isTRUE()) {
            return new ArrayList<BooleanExpression<T>>();
        }
        if (!exp.isAND()) {
            return new ArrayList<BooleanExpression<T>>(List.of(exp));
        }
        List<BooleanExpression<T>> conjuncts = BooleanExpressions.getConjuncts(exp.getLeft());
        conjuncts.addAll(BooleanExpressions.getConjuncts(exp.getRight()));
        return conjuncts;
    }

    public static <T extends Atom> List<BooleanExpression<T>> getDisjuncts(BooleanExpression<T> exp) {
        if (exp.isFALSE()) {
            return new ArrayList<BooleanExpression<T>>();
        }
        if (!exp.isOR()) {
            return new ArrayList<BooleanExpression<T>>(List.of(exp));
        }
        List<BooleanExpression<T>> disjuncts = BooleanExpressions.getDisjuncts(exp.getLeft());
        disjuncts.addAll(BooleanExpressions.getDisjuncts(exp.getRight()));
        return disjuncts;
    }

    public static BooleanExpression<AtomAcceptance> mkFin(int number) {
        return new BooleanExpression((Atom)new AtomAcceptance(AtomAcceptance.Type.TEMPORAL_FIN, Integer.valueOf(number), false));
    }

    public static BooleanExpression<AtomAcceptance> mkInf(int number) {
        return new BooleanExpression((Atom)new AtomAcceptance(AtomAcceptance.Type.TEMPORAL_INF, Integer.valueOf(number), false));
    }

    public static BooleanExpression<AtomAcceptance> shift(BooleanExpression<AtomAcceptance> expression, int offset) {
        if (offset == 0) {
            return expression;
        }
        if (expression.isTRUE() || expression.isFALSE()) {
            return expression;
        }
        if (expression.isAtom()) {
            AtomAcceptance atom = (AtomAcceptance)expression.getAtom();
            AtomAcceptance shiftedAtom = new AtomAcceptance(atom.getType(), Integer.valueOf(atom.getAcceptanceSet() + offset), atom.isNegated());
            return new BooleanExpression((Atom)shiftedAtom);
        }
        if (expression.isNOT()) {
            return BooleanExpressions.shift((BooleanExpression<AtomAcceptance>)expression.getLeft(), offset).not();
        }
        if (expression.isAND()) {
            return BooleanExpressions.shift((BooleanExpression<AtomAcceptance>)expression.getLeft(), offset).and(BooleanExpressions.shift((BooleanExpression<AtomAcceptance>)expression.getRight(), offset));
        }
        if (expression.isOR()) {
            return BooleanExpressions.shift((BooleanExpression<AtomAcceptance>)expression.getLeft(), offset).or(BooleanExpressions.shift((BooleanExpression<AtomAcceptance>)expression.getRight(), offset));
        }
        throw new AssertionError((Object)("Encountered unknown expression " + expression));
    }

    private static boolean isConjunctive(BooleanExpression<AtomAcceptance> acc) {
        switch (acc.getType()) {
            case EXP_FALSE: 
            case EXP_TRUE: 
            case EXP_ATOM: {
                return true;
            }
            case EXP_AND: {
                return BooleanExpressions.isConjunctive((BooleanExpression<AtomAcceptance>)acc.getLeft()) && BooleanExpressions.isConjunctive((BooleanExpression<AtomAcceptance>)acc.getRight());
            }
            case EXP_OR: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition " + acc);
    }

    private static List<BooleanExpression<AtomAcceptance>> toDnf(BooleanExpression<AtomAcceptance> acc, Map<BooleanExpression<AtomAcceptance>, BooleanExpression<AtomAcceptance>> uniqueTable) {
        if (BooleanExpressions.isConjunctive(acc)) {
            return List.of(uniqueTable.computeIfAbsent(acc, Function.identity()));
        }
        ArrayList<BooleanExpression<AtomAcceptance>> dnf = new ArrayList<BooleanExpression<AtomAcceptance>>();
        switch (acc.getType()) {
            case EXP_AND: {
                List<BooleanExpression<AtomAcceptance>> left = BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getLeft(), uniqueTable);
                List<BooleanExpression<AtomAcceptance>> right = BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getRight(), uniqueTable);
                for (BooleanExpression<AtomAcceptance> l : left) {
                    for (BooleanExpression<AtomAcceptance> r : right) {
                        BooleanExpression conjunction = l.and(r);
                        dnf.add(uniqueTable.computeIfAbsent((BooleanExpression<AtomAcceptance>)conjunction, Function.identity()));
                    }
                }
                return dnf;
            }
            case EXP_OR: {
                dnf.addAll(BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getLeft(), uniqueTable));
                dnf.addAll(BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getRight(), uniqueTable));
                return dnf;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition: " + acc);
    }

    public static List<BooleanExpression<AtomAcceptance>> toDnf(BooleanExpression<AtomAcceptance> acc) {
        return BooleanExpressions.toDnf(acc, new HashMap<BooleanExpression<AtomAcceptance>, BooleanExpression<AtomAcceptance>>());
    }
}

