/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimization;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;

public final class ParityAcceptanceOptimizations {
    private ParityAcceptanceOptimizations() {
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> setAcceptingSets(MutableAutomaton<S, ParityAcceptance> automaton) {
        int maximalAcceptance = automaton.states().stream().map(automaton::edges).flatMap(Collection::stream).mapToInt(Edge::largestAcceptanceSet).max().orElse(-1);
        automaton.acceptance(((ParityAcceptance)automaton.acceptance()).withAcceptanceSets(maximalAcceptance + 1));
        return automaton;
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> minimizePriorities(MutableAutomaton<S, ParityAcceptance> automaton) {
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        List<Set<S>> sccs = SccDecomposition.of(automaton).sccs();
        int usedAcceptanceSets = 0;
        for (Set<S> scc : sccs) {
            Int2IntOpenHashMap reductionMapping = new Int2IntOpenHashMap();
            reductionMapping.defaultReturnValue(-1);
            TreeSet<Integer> usedPriorities = new TreeSet<Integer>();
            for (S state : scc) {
                for (Edge<S> edge : automaton.edges(state)) {
                    if (!edge.hasAcceptanceSets() || !scc.contains(edge.successor())) continue;
                    usedPriorities.add(edge.smallestAcceptanceSet());
                }
            }
            int currentTarget = usedPriorities.isEmpty() ? 0 : (Integer)usedPriorities.first() % 2;
            Iterator iterator = usedPriorities.iterator();
            while (iterator.hasNext()) {
                int currentPriority = (Integer)iterator.next();
                if (currentTarget % 2 != currentPriority % 2) {
                    ++currentTarget;
                }
                reductionMapping.put(currentPriority, currentTarget);
                usedAcceptanceSets = Math.max(usedAcceptanceSets, currentTarget + 1);
            }
            automaton.updateEdges(scc, (arg_0, arg_1) -> ParityAcceptanceOptimizations.lambda$minimizePriorities$0(scc, (Int2IntMap)reductionMapping, arg_0, arg_1));
            automaton.trim();
        }
        automaton.acceptance(acceptance.withAcceptanceSets(usedAcceptanceSets));
        return automaton;
    }

    private static /* synthetic */ Edge lambda$minimizePriorities$0(Set scc, Int2IntMap reductionMapping, Object state, Edge edge) {
        return scc.contains(edge.successor()) && edge.hasAcceptanceSets() ? edge.withAcceptance(reductionMapping.get(edge.smallestAcceptanceSet())) : edge.withoutAcceptance();
    }
}

