/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.AutoValue_Transition;
import owl.automaton.edge.Edge;
import owl.util.BitSetUtil;

@AutoValue
public abstract class Transition<S> {
    abstract int valuation();

    abstract S target();

    abstract boolean flag();

    static <S> Transition<S> of(int valuation, S target, boolean flag) {
        return new AutoValue_Transition<S>(valuation, target, flag);
    }

    static <S> Transition<S> of(BitSet valuation, S target, boolean flag) {
        return Transition.of(BitSetUtil.toInt(valuation), target, flag);
    }

    List<Transition<S>> append(Transition<S> ext) {
        return ImmutableList.of((Object)this, ext);
    }

    List<Transition<S>> append(List<Transition<S>> ext) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)this), ext));
    }

    static <S> List<Transition<S>> concat(List<Transition<S>> l1, List<Transition<S>> l2) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(l1, l2));
    }

    static <S> Set<Transition<S>> universe(S state, Automaton<S, BuchiAcceptance> aut, BitSet val) {
        return aut.edgeTree(state).get(val).stream().map(e -> Transition.of(BitSetUtil.toInt(val), e.successor(), ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)e))).collect(Collectors.toSet());
    }

    static <S> Set<Transition<S>> universe(S state, Automaton<S, BuchiAcceptance> aut) {
        HashSet out = new HashSet();
        aut.edgeMap(state).forEach((edge, valSet) -> valSet.forEach(val -> out.add(Transition.of(val, edge.successor(), ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)edge)))));
        return out;
    }

    static <S> Set<List<Transition<S>>> universe(S state, Automaton<S, BuchiAcceptance> aut, int k) {
        Set<List<Transition<S>>> out = Transition.universe(state, aut).stream().map(ImmutableList::of).collect(Collectors.toSet());
        for (int i = 1; i < k; ++i) {
            HashSet toAdd = new HashSet();
            out.forEach(t -> {
                Transition last = (Transition)t.get(t.size() - 1);
                Transition.universe(last.target(), aut).forEach(tt -> toAdd.add(Transition.concat(t, ImmutableList.of((Object)tt))));
            });
            out.addAll(toAdd);
        }
        return out;
    }

    private static <S> boolean directMatching(List<Transition<S>> original, List<Transition<S>> candidate) {
        return Streams.zip(original.stream(), candidate.stream(), (t1, t2) -> (!t1.flag() || t2.flag()) && t1.valuation() == t2.valuation()).allMatch(b -> b);
    }

    static <S> Set<List<Transition<S>>> directMatching(S state, Automaton<S, BuchiAcceptance> aut, List<Transition<S>> moves) {
        Set<List<Transition<S>>> possible = Transition.universe(state, aut, moves.size());
        return possible.stream().filter(p -> Transition.directMatching(moves, p)).collect(Collectors.toSet());
    }

    public static <S> S end(List<Transition<S>> moves) {
        return Transition.at(moves, moves.size());
    }

    public static <S> S at(List<Transition<S>> moves, int pos) {
        return moves.get(pos - 1).target();
    }

    public String toString() {
        return "-" + (this.flag() ? ">>" : ">") + this.target();
    }

    public boolean isValid(S base, Automaton<S, BuchiAcceptance> aut) {
        return aut.successors(base, BitSetUtil.fromInt(this.valuation())).contains(this.target()) && aut.edges(base, BitSetUtil.fromInt(this.valuation())).stream().anyMatch(e -> ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)e)) == this.flag();
    }
}

