/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class TrieMap<K, V> {
    @Nullable
    private V value;
    public final Map<K, TrieMap<K, V>> suc = new HashMap<K, TrieMap<K, V>>();

    public static <K, V> TrieMap<K, V> create() {
        return new TrieMap<K, V>();
    }

    public boolean isEmpty() {
        return this.value == null && this.suc.isEmpty();
    }

    public Optional<TrieMap<K, V>> traverse(List<K> ks, boolean create) {
        TrieMap<K, V> curr = this;
        for (K k : ks) {
            if (!curr.suc.containsKey(k)) {
                if (!create) {
                    return Optional.empty();
                }
                curr.suc.put(k, TrieMap.create());
            }
            curr = curr.suc.get(k);
        }
        return Optional.of(curr);
    }

    public void put(List<K> ks, V val) {
        TrieMap<K, V> curr = this.traverse(ks, true).orElseThrow();
        curr.value = val;
    }

    public boolean has(List<K> ks, boolean inSubtree) {
        return this.get(ks, inSubtree).isPresent();
    }

    public Optional<V> get(List<K> ks, boolean any) {
        Optional<TrieMap<K, V>> curr = this.traverse(ks, false);
        if (curr.isEmpty()) {
            return Optional.empty();
        }
        TrieMap<K, V> tr = curr.get();
        if (!any && tr.value == null) {
            return Optional.empty();
        }
        while (tr.value == null) {
            if (tr.suc.isEmpty()) {
                return Optional.empty();
            }
            tr = tr.suc.values().iterator().next();
        }
        return Optional.of(tr.value);
    }

    public Optional<V> getRootValue() {
        return this.value == null ? Optional.empty() : Optional.of(this.value);
    }

    public int size() {
        int sz = this.value == null ? 0 : 1;
        for (TrieMap<K, V> sub : this.suc.values()) {
            sz += sub.size();
        }
        return sz;
    }
}

