/*
 * Decompiled with CFR 0.152.
 */
package owl.game.algorithms;

import java.util.HashSet;
import java.util.Set;
import owl.automaton.acceptance.ParityAcceptance;
import owl.game.Game;

public interface ParityGameSolver {
    public <S> boolean realizable(Game<S, ParityAcceptance> var1);

    public <S> WinningRegions<S> solve(Game<S, ParityAcceptance> var1);

    public static final class WinningRegions<S> {
        final Set<S> player1;
        final Set<S> player2;

        WinningRegions(Set<S> s, Game.Owner o) {
            if (Game.Owner.PLAYER_1 == o) {
                this.player1 = new HashSet<S>(s);
                this.player2 = new HashSet<S>();
            } else {
                this.player1 = new HashSet<S>();
                this.player2 = new HashSet<S>(s);
            }
        }

        void addAll(Set<S> s, Game.Owner o) {
            if (Game.Owner.PLAYER_1 == o) {
                this.player1.addAll(s);
            } else {
                this.player2.addAll(s);
            }
        }

        Set<S> winningRegion(Game.Owner o) {
            return Game.Owner.PLAYER_1 == o ? this.player1 : this.player2;
        }

        public Set<S> playerEven() {
            return this.player2;
        }

        public Set<S> playerOdd() {
            return this.player1;
        }

        public static <S> WinningRegions<S> of(Set<S> region, Game.Owner owner) {
            return new WinningRegions<S>(region, owner);
        }
    }
}

