/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import owl.collections.Collections3;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.Negation;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.SyntacticFairnessSimplifier;
import owl.ltl.visitors.Visitor;

public final class SyntacticSimplifier
implements Visitor<Formula>,
UnaryOperator<Formula> {
    static final SyntacticSimplifier INSTANCE = new SyntacticSimplifier();

    private SyntacticSimplifier() {
    }

    @Override
    public Formula visit(Biconditional biconditional) {
        return Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
    }

    @Override
    public Formula visit(BooleanConstant booleanConstant) {
        return booleanConstant;
    }

    @Override
    public Formula visit(Literal literal) {
        return literal;
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        return SyntacticSimplifier.visitConjunction(conjunction.map(x -> x.accept(this)), true);
    }

    @Override
    public Formula visit(Disjunction disjunction) {
        TreeSet<Formula> newDisjunction = new TreeSet<Formula>(disjunction.map(x -> x.accept(this)));
        if (newDisjunction.stream().anyMatch(x -> newDisjunction.contains(x.not()))) {
            return BooleanConstant.TRUE;
        }
        for (FOperator fOperator : SyntacticSimplifier.filter(newDisjunction, FOperator.class)) {
            newDisjunction.remove(fOperator.operand());
            if (!newDisjunction.contains(fOperator.operand().not())) continue;
            return BooleanConstant.TRUE;
        }
        for (GOperator gOperator : SyntacticSimplifier.filter(newDisjunction, GOperator.class)) {
            if (newDisjunction.contains(gOperator.operand())) {
                newDisjunction.remove(gOperator);
            }
            for (MOperator mOperator : SyntacticSimplifier.filter(newDisjunction, MOperator.class, x -> gOperator.operand().equals(x.rightOperand()))) {
                newDisjunction.remove(gOperator);
                newDisjunction.remove(mOperator);
                newDisjunction.add(ROperator.of(mOperator.leftOperand(), mOperator.rightOperand()));
            }
            for (UOperator uOperator : SyntacticSimplifier.filter(newDisjunction, UOperator.class, x -> gOperator.operand().equals(x.leftOperand()))) {
                newDisjunction.remove(gOperator);
                newDisjunction.remove(uOperator);
                newDisjunction.add(WOperator.of(uOperator.leftOperand(), uOperator.rightOperand()));
            }
        }
        for (Formula.BinaryTemporalOperator operator : SyntacticSimplifier.filter(newDisjunction, Formula.BinaryTemporalOperator.class, x -> x instanceof MOperator || x instanceof ROperator)) {
            if (!newDisjunction.contains(operator.rightOperand())) continue;
            newDisjunction.remove(operator);
        }
        for (Formula.BinaryTemporalOperator operator : SyntacticSimplifier.filter(newDisjunction, Formula.BinaryTemporalOperator.class, x -> x instanceof UOperator || x instanceof WOperator)) {
            if (!newDisjunction.contains(operator.leftOperand())) continue;
            newDisjunction.remove(operator);
            newDisjunction.add(operator.rightOperand());
        }
        for (Conjunction conjunction : SyntacticSimplifier.filter(newDisjunction, Conjunction.class)) {
            Formula newConjunction = Conjunction.of(conjunction.operands.stream().filter(x -> !newDisjunction.contains(x.not())));
            newDisjunction.remove(conjunction);
            newDisjunction.add(newConjunction);
        }
        return Disjunction.of(newDisjunction);
    }

    @Override
    public Formula visit(FOperator fOperator) {
        Formula formula;
        Formula operand = fOperator.operand();
        if (SyntacticFairnessSimplifier.isApplicable2(fOperator)) {
            formula = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_OPERATOR.apply(fOperator);
            assert (formula instanceof FOperator);
            operand = ((FOperator)formula).operand();
        }
        if ((operand = operand.accept(this)).isPureEventual() || operand.isSuspendable()) {
            return operand;
        }
        if (operand instanceof ROperator) {
            ROperator rOperator = (ROperator)operand;
            return Disjunction.of(FOperator.of(Conjunction.of(rOperator.leftOperand(), rOperator.rightOperand())), FOperator.of(GOperator.of(rOperator.rightOperand())));
        }
        if (operand instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)operand;
            HashSet<Formula> suspendable = new HashSet<Formula>();
            HashSet others = new HashSet();
            conjunction.operands.forEach(x -> {
                if (x.isSuspendable()) {
                    suspendable.add((Formula)x);
                } else {
                    others.add(x);
                }
            });
            if (!suspendable.isEmpty()) {
                suspendable.add(FOperator.of(Conjunction.of(others)));
                return Conjunction.of(suspendable).accept(this);
            }
            if (others.stream().allMatch(Formula::isPureUniversal)) {
                return Conjunction.of(others.stream().map(FOperator::of)).accept(this);
            }
        }
        if (SyntacticFairnessSimplifier.isApplicable(formula = FOperator.of(operand))) {
            Formula almostAllOperand = SyntacticFairnessSimplifier.getAlmostAllOperand(formula);
            assert (almostAllOperand != null);
            Formula normalisedX = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_OPERATOR.apply(almostAllOperand);
            return normalisedX.accept(SyntacticFairnessSimplifier.ALMOST_ALL_VISITOR);
        }
        return formula;
    }

    @Override
    public Formula visit(GOperator gOperator) {
        Formula formula;
        Formula operand = gOperator.operand();
        if (SyntacticFairnessSimplifier.isApplicable2(gOperator)) {
            formula = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_OPERATOR.apply(gOperator);
            assert (formula instanceof GOperator);
            operand = ((GOperator)formula).operand();
        }
        if ((operand = operand.accept(this)).isPureUniversal() || operand.isSuspendable()) {
            return operand;
        }
        if (operand instanceof UOperator) {
            UOperator uOperator = (UOperator)operand;
            return Conjunction.of(GOperator.of(Disjunction.of(uOperator.leftOperand(), uOperator.rightOperand())), GOperator.of(FOperator.of(uOperator.rightOperand())));
        }
        if (operand instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)operand;
            HashSet<Formula> suspendable = new HashSet<Formula>();
            HashSet others = new HashSet();
            disjunction.operands.forEach(x -> {
                if (x.isSuspendable()) {
                    suspendable.add((Formula)x);
                } else {
                    others.add(x);
                }
            });
            if (!suspendable.isEmpty()) {
                suspendable.add(GOperator.of(Disjunction.of(others)));
                return Disjunction.of(suspendable).accept(this);
            }
            if (others.stream().allMatch(Formula::isPureEventual)) {
                return Disjunction.of(others.stream().map(GOperator::of)).accept(this);
            }
        }
        if (SyntacticFairnessSimplifier.isApplicable(formula = GOperator.of(operand))) {
            Formula infinitelyOftenOperand = SyntacticFairnessSimplifier.getInfinitelyOftenOperand(formula);
            assert (infinitelyOftenOperand != null);
            Formula normalisedX = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_OPERATOR.apply(infinitelyOftenOperand);
            return normalisedX.accept(SyntacticFairnessSimplifier.INFINITELY_OFTEN_VISITOR);
        }
        return formula;
    }

    @Override
    public Formula visit(MOperator mOperator) {
        Formula right;
        Formula left = mOperator.leftOperand().accept(this);
        if (left.equals((right = mOperator.rightOperand().accept(this)).not())) {
            return BooleanConstant.FALSE;
        }
        if (right.isPureUniversal()) {
            return Conjunction.of(FOperator.of(left), right);
        }
        if (right instanceof Disjunction) {
            HashSet<Formula> pureUniversal = new HashSet<Formula>();
            HashSet other = new HashSet();
            right.operands.forEach(x -> {
                if (x.isPureUniversal()) {
                    pureUniversal.add((Formula)x);
                } else {
                    other.add(x);
                }
            });
            Formula otherDisjunction = Disjunction.of(other);
            if (left.not().equals(otherDisjunction)) {
                pureUniversal.add(otherDisjunction);
                return Conjunction.of(FOperator.of(left), GOperator.of(Disjunction.of(pureUniversal)));
            }
        }
        if (left.isPureEventual()) {
            return Conjunction.of(left, right);
        }
        return MOperator.of(left, right);
    }

    @Override
    public Formula visit(ROperator rOperator) {
        Formula right;
        Formula left = rOperator.leftOperand().accept(this);
        if (left.equals((right = rOperator.rightOperand().accept(this)).not())) {
            return GOperator.of(right);
        }
        if (right.isPureUniversal()) {
            return right;
        }
        if (right instanceof FOperator && left.equals(((FOperator)right).operand())) {
            return right;
        }
        if (right instanceof Disjunction) {
            HashSet<Formula> pureUniversal = new HashSet<Formula>();
            HashSet other = new HashSet();
            right.operands.forEach(x -> {
                if (x.isPureUniversal()) {
                    pureUniversal.add((Formula)x);
                } else {
                    other.add(x);
                }
            });
            Formula otherDisjunction = Disjunction.of(other);
            if (left.not().equals(otherDisjunction)) {
                pureUniversal.add(otherDisjunction);
                return GOperator.of(Disjunction.of(pureUniversal));
            }
        }
        if (left.isPureEventual()) {
            return Disjunction.of(Conjunction.of(left, right), GOperator.of(right));
        }
        return ROperator.of(left, right);
    }

    @Override
    public Formula visit(UOperator uOperator) {
        Formula right;
        Formula left = uOperator.leftOperand().accept(this);
        if (left.equals((right = uOperator.rightOperand().accept(this)).not())) {
            return FOperator.of(right);
        }
        if (right.isPureEventual()) {
            return right;
        }
        if (right instanceof Conjunction) {
            HashSet<Formula> pureEventual = new HashSet<Formula>();
            HashSet other = new HashSet();
            right.operands.forEach(x -> {
                if (x.isPureEventual()) {
                    pureEventual.add((Formula)x);
                } else {
                    other.add(x);
                }
            });
            Formula otherConjunction = Conjunction.of(other);
            if (left.not().equals(otherConjunction)) {
                pureEventual.add(otherConjunction);
                return FOperator.of(Conjunction.of(pureEventual));
            }
        }
        if (left.isPureUniversal()) {
            return Conjunction.of(Disjunction.of(left, right), FOperator.of(right));
        }
        return UOperator.of(left, right);
    }

    @Override
    public Formula visit(WOperator wOperator) {
        Formula right;
        Formula left = wOperator.leftOperand().accept(this);
        if (left.equals((right = wOperator.rightOperand().accept(this)).not())) {
            return BooleanConstant.TRUE;
        }
        if (right.isPureEventual()) {
            return Disjunction.of(GOperator.of(left), right);
        }
        if (right instanceof Conjunction) {
            HashSet<Formula> pureEventual = new HashSet<Formula>();
            HashSet other = new HashSet();
            right.operands.forEach(x -> {
                if (x.isPureEventual()) {
                    pureEventual.add((Formula)x);
                } else {
                    other.add(x);
                }
            });
            Formula otherConjunction = Conjunction.of(other);
            if (left.not().equals(otherConjunction)) {
                pureEventual.add(otherConjunction);
                return Disjunction.of(GOperator.of(left), FOperator.of(Conjunction.of(pureEventual)));
            }
        }
        if (left.isPureUniversal()) {
            return Disjunction.of(left, right);
        }
        return WOperator.of(left, right);
    }

    @Override
    public Formula visit(XOperator xOperator) {
        Formula operand = xOperator.operand().accept(this);
        if (operand.isSuspendable()) {
            return operand;
        }
        if (operand instanceof Formula.NaryPropositionalOperator) {
            Set suspendable = operand.operands.stream().filter(Formula::isSuspendable).collect(Collectors.toSet());
            Sets.SetView others = Sets.difference(new HashSet<Formula>(operand.operands), suspendable);
            if (!suspendable.isEmpty()) {
                if (operand instanceof Conjunction) {
                    return Conjunction.of(Collections3.add(suspendable, XOperator.of(Conjunction.of((Collection<? extends Formula>)others))));
                }
                assert (operand instanceof Disjunction);
                return Disjunction.of(Collections3.add(suspendable, XOperator.of(Disjunction.of((Collection<? extends Formula>)others))));
            }
        }
        if (operand.equals(xOperator.operand())) {
            return xOperator;
        }
        return XOperator.of(operand);
    }

    public static Formula visitConjunction(Collection<Formula> oldConjunction, boolean allowNewFormulas) {
        TreeSet<Formula> conjunction = new TreeSet<Formula>(oldConjunction);
        if (conjunction.stream().anyMatch(x -> conjunction.contains(x.not()))) {
            return BooleanConstant.FALSE;
        }
        for (GOperator gOperator : SyntacticSimplifier.filter(conjunction, GOperator.class)) {
            Iterator operand = gOperator.operand();
            conjunction.remove(operand);
            EventuallySatisfied visitor = new EventuallySatisfied(((Formula)((Object)operand)).not());
            if (conjunction.stream().anyMatch(visitor::apply)) {
                return BooleanConstant.FALSE;
            }
            conjunction.removeIf(arg_0 -> SyntacticSimplifier.lambda$visitConjunction$15((Formula)((Object)operand), arg_0));
            conjunction.removeIf(arg_0 -> SyntacticSimplifier.lambda$visitConjunction$16((Formula)((Object)operand), arg_0));
            conjunction.removeIf(formula -> formula instanceof XOperator && SyntacticSimplifier.unwrapX((XOperator)formula).equals(operand));
            conjunction.removeIf(formula -> formula instanceof XOperator && SyntacticSimplifier.unwrapX((XOperator)formula).equals(gOperator));
        }
        for (FOperator fOperator : SyntacticSimplifier.filter(conjunction, FOperator.class)) {
            if (conjunction.contains(fOperator.operand())) {
                conjunction.remove(fOperator);
            }
            if (!allowNewFormulas) continue;
            for (ROperator rOperator : SyntacticSimplifier.filter(conjunction, ROperator.class, x -> fOperator.operand().equals(x.leftOperand()))) {
                conjunction.remove(fOperator);
                conjunction.remove(rOperator);
                conjunction.add(MOperator.of(rOperator.leftOperand(), rOperator.rightOperand()));
            }
            for (WOperator wOperator : SyntacticSimplifier.filter(conjunction, WOperator.class, x -> fOperator.operand().equals(x.rightOperand()))) {
                conjunction.remove(fOperator);
                conjunction.remove(wOperator);
                conjunction.add(UOperator.of(wOperator.leftOperand(), wOperator.rightOperand()));
            }
        }
        for (Formula.BinaryTemporalOperator operator : SyntacticSimplifier.filter(conjunction, Formula.BinaryTemporalOperator.class, x -> x instanceof UOperator || x instanceof WOperator)) {
            if (!conjunction.contains(operator.rightOperand())) continue;
            conjunction.remove(operator);
        }
        for (Formula.BinaryTemporalOperator operator : SyntacticSimplifier.filter(conjunction, Formula.BinaryTemporalOperator.class, x -> x instanceof MOperator || x instanceof ROperator)) {
            if (!conjunction.contains(operator.leftOperand())) continue;
            conjunction.remove(operator);
            conjunction.add(operator.rightOperand());
        }
        for (Disjunction disjunction : SyntacticSimplifier.filter(conjunction, Disjunction.class)) {
            Formula newDisjunction = Disjunction.of(disjunction.operands.stream().filter(x -> !conjunction.contains(x.not())));
            conjunction.remove(disjunction);
            conjunction.add(newDisjunction);
        }
        return Conjunction.of(conjunction);
    }

    private static <T extends Formula> SortedSet<T> filter(SortedSet<Formula> sortedSet, Class<T> clazz) {
        return SyntacticSimplifier.filter(sortedSet, clazz, x -> true);
    }

    private static <T extends Formula> SortedSet<T> filter(SortedSet<Formula> sortedSet, Class<T> clazz, Predicate<T> predicate) {
        TreeSet operators = new TreeSet();
        sortedSet.forEach(x -> {
            if (clazz.isInstance(x) && predicate.test((Formula)clazz.cast(x))) {
                operators.add((Formula)clazz.cast(x));
            }
        });
        return operators;
    }

    private static Formula unwrapX(XOperator xOperator) {
        Formula returnValue = xOperator.operand();
        while (returnValue instanceof XOperator) {
            returnValue = ((XOperator)returnValue).operand();
        }
        return returnValue;
    }

    private static /* synthetic */ boolean lambda$visitConjunction$16(Formula operand, Formula formula) {
        return formula instanceof WOperator && ((WOperator)formula).leftOperand().equals(operand);
    }

    private static /* synthetic */ boolean lambda$visitConjunction$15(Formula operand, Formula formula) {
        return formula instanceof ROperator && ((ROperator)formula).rightOperand().equals(operand);
    }

    private static class EventuallySatisfied
    implements Visitor<Boolean> {
        private final Formula targetFormula;

        private EventuallySatisfied(Formula targetFormula) {
            this.targetFormula = targetFormula;
        }

        @Override
        public Boolean visit(Biconditional biconditional) {
            return false;
        }

        @Override
        public Boolean visit(BooleanConstant booleanConstant) {
            return false;
        }

        @Override
        public Boolean visit(Conjunction conjunction) {
            return this.targetFormula.equals(conjunction) || conjunction.operands.stream().anyMatch(this::apply);
        }

        @Override
        public Boolean visit(Disjunction disjunction) {
            return this.targetFormula.equals(disjunction) || disjunction.operands.stream().allMatch(this::apply);
        }

        @Override
        public Boolean visit(Literal literal) {
            return this.targetFormula.equals(literal);
        }

        @Override
        public Boolean visit(Negation negation) {
            return false;
        }

        @Override
        public Boolean visit(FOperator fOperator) {
            return this.targetFormula.equals(fOperator) || fOperator.operand().accept(this) != false;
        }

        @Override
        public Boolean visit(GOperator gOperator) {
            return this.targetFormula.equals(gOperator) || gOperator.operand().accept(this) != false;
        }

        @Override
        public Boolean visit(MOperator mOperator) {
            return this.targetFormula.equals(mOperator) || mOperator.leftOperand().accept(this) != false || mOperator.rightOperand().accept(this) != false;
        }

        @Override
        public Boolean visit(ROperator rOperator) {
            return this.targetFormula.equals(rOperator) || rOperator.rightOperand().accept(this) != false;
        }

        @Override
        public Boolean visit(UOperator uOperator) {
            return this.targetFormula.equals(uOperator) || uOperator.rightOperand().accept(this) != false;
        }

        @Override
        public Boolean visit(WOperator wOperator) {
            return this.targetFormula.equals(wOperator) || wOperator.leftOperand().accept(this) != false && wOperator.rightOperand().accept(this) != false;
        }

        @Override
        public Boolean visit(XOperator xOperator) {
            return this.targetFormula.equals(xOperator) || xOperator.operand().accept(this) != false;
        }
    }
}

