/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import java.util.Set;
import java.util.function.UnaryOperator;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public abstract class Converter
implements Visitor<Formula>,
UnaryOperator<Formula> {
    private final Set<Class<? extends Formula>> supportedCases;

    protected Converter(SyntacticFragment fragment) {
        this(fragment.classes());
    }

    protected Converter(Set<Class<? extends Formula>> supportedCases) {
        this.supportedCases = Set.copyOf(supportedCases);
    }

    @Override
    public Formula visit(Biconditional biconditional) {
        this.checkSupportedCase(Biconditional.class);
        return Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
    }

    @Override
    public Formula visit(BooleanConstant booleanConstant) {
        this.checkSupportedCase(BooleanConstant.class);
        return booleanConstant;
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        this.checkSupportedCase(Conjunction.class);
        return Conjunction.of(conjunction.map(c -> c.accept(this)));
    }

    @Override
    public Formula visit(Disjunction disjunction) {
        this.checkSupportedCase(Disjunction.class);
        return Disjunction.of(disjunction.map(c -> c.accept(this)));
    }

    @Override
    public Formula visit(FOperator fOperator) {
        this.checkSupportedCase(FOperator.class);
        return FOperator.of(fOperator.operand().accept(this));
    }

    @Override
    public Formula visit(GOperator gOperator) {
        this.checkSupportedCase(GOperator.class);
        return GOperator.of(gOperator.operand().accept(this));
    }

    @Override
    public Formula visit(Literal literal) {
        this.checkSupportedCase(Literal.class);
        return literal;
    }

    @Override
    public Formula visit(MOperator mOperator) {
        this.checkSupportedCase(MOperator.class);
        return MOperator.of(mOperator.leftOperand().accept(this), mOperator.rightOperand().accept(this));
    }

    @Override
    public Formula visit(ROperator rOperator) {
        this.checkSupportedCase(ROperator.class);
        return ROperator.of(rOperator.leftOperand().accept(this), rOperator.rightOperand().accept(this));
    }

    @Override
    public Formula visit(UOperator uOperator) {
        this.checkSupportedCase(UOperator.class);
        return UOperator.of(uOperator.leftOperand().accept(this), uOperator.rightOperand().accept(this));
    }

    @Override
    public Formula visit(WOperator wOperator) {
        this.checkSupportedCase(WOperator.class);
        return WOperator.of(wOperator.leftOperand().accept(this), wOperator.rightOperand().accept(this));
    }

    @Override
    public Formula visit(XOperator xOperator) {
        this.checkSupportedCase(XOperator.class);
        return XOperator.of(xOperator.operand().accept(this));
    }

    private void checkSupportedCase(Class<? extends Formula> clazz) {
        if (!this.supportedCases.contains(clazz)) {
            throw new UnsupportedOperationException("Unsupported case: " + clazz);
        }
    }
}

