/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.Option;
import owl.util.OwlVersion;

public final class RunUtil {
    private static final Logger logger = Logger.getLogger(RunUtil.class.getName());

    private RunUtil() {
    }

    public static Option getDefaultAnnotationOption() {
        return new Option("a", "annotations", false, "Gather additional labels etc. (where supported)");
    }

    public static AssertionError failWithMessage(String message) {
        System.err.println(message);
        System.exit(1);
        return new AssertionError((Object)"Unreachable");
    }

    public static AssertionError failWithMessage(String message, Throwable cause) {
        System.err.println(message);
        logger.log(Level.FINE, "Stacktrace:", cause);
        System.exit(1);
        return new AssertionError("Unreachable", cause);
    }

    public static void checkForVersion(String[] args) {
        if (Arrays.asList(args).contains("-v") || Arrays.asList(args).contains("--version")) {
            OwlVersion.NameAndVersion nameAndVersion = OwlVersion.getNameAndVersion();
            System.out.println(String.format("Name: %s \nVersion: %s", nameAndVersion.name(), nameAndVersion.version()));
            System.exit(0);
        }
    }
}

