/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.run.modules.AutoValue_OwlModule;

@AutoValue
public abstract class OwlModule<M extends Instance> {
    public abstract String key();

    public abstract String description();

    public abstract Options options();

    public abstract Constructor<M> constructor();

    public static <M extends Instance> OwlModule<M> of(String key, String description, Constructor<M> constructor) {
        return OwlModule.of(key, description, new Options(), constructor);
    }

    public static <M extends Instance> OwlModule<M> of(String key, String description, Supplier<Options> supplier, Constructor<M> constructor) {
        return OwlModule.of(key, description, supplier.get(), constructor);
    }

    public static <M extends Instance> OwlModule<M> of(String key, String description, Option option, Constructor<M> constructor) {
        return OwlModule.of(key, description, new Options().addOption(option), constructor);
    }

    public static <M extends Instance> OwlModule<M> of(String key, String description, Options options, Constructor<M> constructor) {
        return new AutoValue_OwlModule<M>(key, description, options, constructor);
    }

    @FunctionalInterface
    public static interface OutputWriter
    extends Instance {
        public void write(Writer var1, Object var2) throws IOException;
    }

    @FunctionalInterface
    public static interface LabelledFormulaTransformer
    extends Transformer {
        public Object transform(LabelledFormula var1);

        @Override
        default public Object transform(Object object) {
            Preconditions.checkArgument((boolean)(object instanceof LabelledFormula), (Object)String.format("Cannot cast %s to LabelledFormula.", object.getClass().getSimpleName()));
            return this.transform((LabelledFormula)object);
        }

        public static <R> LabelledFormulaTransformer of(Function<LabelledFormula, R> function) {
            return function::apply;
        }
    }

    @FunctionalInterface
    public static interface AutomatonTransformer
    extends Transformer {
        public Object transform(Automaton<Object, ?> var1);

        @Override
        default public Object transform(Object object) {
            Preconditions.checkArgument((boolean)(object instanceof Automaton), (Object)String.format("Cannot cast %s to Automaton.", object.getClass().getSimpleName()));
            return this.transform((Automaton)object);
        }

        public static <R> AutomatonTransformer of(Function<Automaton<Object, ?>, R> function) {
            return function::apply;
        }

        public static <A extends OmegaAcceptance, R> AutomatonTransformer of(Function<Automaton<Object, A>, R> function, Class<A> acceptanceBound) {
            return object -> function.apply((Automaton)OmegaAcceptanceCast.cast(object, acceptanceBound));
        }
    }

    @FunctionalInterface
    public static interface Transformer
    extends Instance {
        public Object transform(Object var1);
    }

    @FunctionalInterface
    public static interface InputReader
    extends Instance {
        public void read(Reader var1, Consumer<Object> var2, Supplier<Boolean> var3) throws IOException;
    }

    public static interface Instance {
    }

    @FunctionalInterface
    public static interface Constructor<M> {
        public M newInstance(CommandLine var1, Environment var2) throws ParseException;
    }
}

