/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import org.apache.commons.cli.Options;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.SingletonAutomaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.edge.Edge;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.run.Environment;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ExternalTranslator;
import owl.translations.LTL2DAFunction;
import owl.translations.delag.DependencyTree;
import owl.translations.delag.DependencyTreeFactory;
import owl.translations.delag.History;
import owl.translations.delag.ProductState;
import owl.translations.delag.State;

public class DelagBuilder
implements Function<LabelledFormula, Automaton<State<Object>, EmersonLeiAcceptance>> {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("delag", "Translates LTL to deterministic Emerson-Lei automata", new Options().addOption("f", "fallback", true, "Fallback tool for input outside the fragment. If no tool is specified an internal LTL to DGRA translation is used."), (commandLine, environment) -> {
        String command = commandLine.getOptionValue("fallback");
        if (command == null) {
            return OwlModule.LabelledFormulaTransformer.of(new DelagBuilder(environment));
        }
        return OwlModule.LabelledFormulaTransformer.of(new DelagBuilder(environment, new ExternalTranslator(command, ExternalTranslator.InputMode.STDIN, environment)));
    });
    private final Environment environment;
    private final Function<LabelledFormula, ? extends Automaton<?, ?>> fallback;
    @Nullable
    private LoadingCache<ProductState<Object>, History> requiredHistoryCache;

    public DelagBuilder(Environment environment) {
        this.environment = environment;
        this.fallback = new LTL2DAFunction(GeneralizedRabinAcceptance.class, environment);
    }

    private DelagBuilder(Environment environment, ExternalTranslator fallback) {
        this.environment = environment;
        this.fallback = fallback;
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.LTL_INPUT_MODULE, List.of(SimplifierTransformer.MODULE), MODULE, List.of(), OutputWriters.HOA_OUTPUT_MODULE));
    }

    @Override
    public Automaton<State<Object>, EmersonLeiAcceptance> apply(LabelledFormula inputFormula) {
        LabelledFormula formula = inputFormula.nnf();
        Factories factories = this.environment.factorySupplier().getFactories(formula.atomicPropositions());
        if (formula.formula().equals(BooleanConstant.FALSE)) {
            return EmptyAutomaton.of(factories.vsFactory, new EmersonLeiAcceptance(0, (BooleanExpression<AtomAcceptance>)new BooleanExpression(false)));
        }
        if (formula.formula().equals(BooleanConstant.TRUE)) {
            return SingletonAutomaton.of(factories.vsFactory, new State(), new EmersonLeiAcceptance(0, (BooleanExpression<AtomAcceptance>)new BooleanExpression(true)), Set.of());
        }
        DependencyTreeFactory treeConverter = new DependencyTreeFactory(factories, x -> this.fallback.apply((LabelledFormula)x));
        final DependencyTree tree = (DependencyTree)formula.formula().accept(treeConverter);
        BooleanExpression<AtomAcceptance> expression = tree.getAcceptanceExpression();
        int sets = treeConverter.setNumber;
        this.requiredHistoryCache = CacheBuilder.newBuilder().maximumSize(1024L).build(CacheLoader.from(key -> History.create(tree.getRequiredHistory(key))));
        ProductState<Object> initialProduct = treeConverter.buildInitialState();
        State<Object> initialState = new State<Object>(initialProduct, this.getHistory(null, new BitSet(), initialProduct));
        return new AbstractImmutableAutomaton.SemiDeterministicEdgesAutomaton<State<Object>, EmersonLeiAcceptance>(factories.vsFactory, Set.of(initialState), new EmersonLeiAcceptance(sets, expression)){

            @Override
            public Edge<State<Object>> edge(State<Object> state, BitSet valuation) {
                return DelagBuilder.this.edge(tree, state, valuation);
            }
        };
    }

    private History getHistory(@Nullable History past, BitSet present, ProductState<Object> state) {
        assert (this.requiredHistoryCache != null);
        try {
            History requiredHistory = (History)this.requiredHistoryCache.getUnchecked(state);
            return History.stepHistory(past, present, requiredHistory);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new UnsupportedOperationException(e);
        }
    }

    @Nullable
    private Edge<State<Object>> edge(DependencyTree<Object> tree, State<Object> state, BitSet valuation) {
        ProductState.Builder builder = ProductState.builder();
        Boolean acc = tree.buildSuccessor(state, valuation, builder);
        if (acc != null && !acc.booleanValue()) {
            return null;
        }
        ProductState<Object> successor = builder.build();
        History history = this.getHistory(state.past, valuation, successor);
        return Edge.of(new State<Object>(successor, history), tree.getAcceptance(state, valuation, acc));
    }
}

