/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.run.Environment;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.modules.AbstractLTL2LDBAModule;
import owl.translations.modules.AbstractLTL2PortfolioModule;

public final class LTL2LDBAModule {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("ltl2ldba", "Translate LTL to limit-deterministic B\u00fcchi automata.", AbstractLTL2LDBAModule.options(), (commandLine, environment) -> {
        boolean useSymmetric = commandLine.hasOption(AbstractLTL2LDBAModule.symmetric().getOpt());
        boolean usePortfolio = AbstractLTL2PortfolioModule.usePortfolio(commandLine);
        return OwlModule.LabelledFormulaTransformer.of(LTL2LDBAModule.translation(environment, useSymmetric, usePortfolio));
    });

    private LTL2LDBAModule() {
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.LTL_INPUT_MODULE, List.of(SimplifierTransformer.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    public static Function<LabelledFormula, Automaton<?, BuchiAcceptance>> translation(Environment environment, boolean useSymmetric, boolean usePortfolio) {
        Function construction = useSymmetric ? SymmetricLDBAConstruction.of(environment, BuchiAcceptance.class)::applyWithShortcuts : AsymmetricLDBAConstruction.of(environment, BuchiAcceptance.class).andThen(AnnotatedLDBA::copyAsMutable);
        DeterministicConstructionsPortfolio<BuchiAcceptance> portfolio = usePortfolio ? new DeterministicConstructionsPortfolio<BuchiAcceptance>(BuchiAcceptance.class, environment) : null;
        return labelledFormula -> {
            Optional automaton;
            if (portfolio != null && (automaton = portfolio.apply((LabelledFormula)labelledFormula)).isPresent()) {
                return automaton.orElseThrow();
            }
            return (Automaton)construction.apply(labelledFormula);
        };
    }
}

