/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.collections.Either;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.run.Environment;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.canonical.NonDeterministicConstructionsPortfolio;
import owl.translations.ltl2nba.ProductState;
import owl.translations.ltl2nba.SymmetricNBAConstruction;
import owl.translations.modules.AbstractLTL2PortfolioModule;

public final class LTL2NGBAModule {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("ltl2ngba", "Translate LTL to non-deterministic generalized-B\u00fcchi automata. The construction is based on the symmetric approach from [EKS: LICS'18].", AbstractLTL2PortfolioModule.disablePortfolio(), (commandLine, environment) -> OwlModule.LabelledFormulaTransformer.of(LTL2NGBAModule.translation(environment, AbstractLTL2PortfolioModule.usePortfolio(commandLine))));

    private LTL2NGBAModule() {
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.LTL_INPUT_MODULE, List.of(SimplifierTransformer.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    public static Function<LabelledFormula, Automaton<?, GeneralizedBuchiAcceptance>> translation(Environment environment, boolean usePortfolio) {
        Function<LabelledFormula, Automaton<Either<Formula, ProductState>, GeneralizedBuchiAcceptance>> construction = SymmetricNBAConstruction.of(environment, GeneralizedBuchiAcceptance.class);
        NonDeterministicConstructionsPortfolio<GeneralizedBuchiAcceptance> portfolio = usePortfolio ? new NonDeterministicConstructionsPortfolio<GeneralizedBuchiAcceptance>(GeneralizedBuchiAcceptance.class, environment) : null;
        return labelledFormula -> {
            Optional automaton;
            if (portfolio != null && (automaton = portfolio.apply((LabelledFormula)labelledFormula)).isPresent()) {
                return automaton.orElseThrow();
            }
            return (Automaton)construction.apply((LabelledFormula)labelledFormula);
        };
    }
}

