/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2dpa;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.BooleanOperations;
import owl.automaton.EdgesAutomatonMixin;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.algorithm.LanguageContainment;
import owl.automaton.edge.Edge;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.nba2dpa.RankingState;
import owl.translations.nba2ldba.NBA2LDBA;

public final class NBA2DPA
implements Function<Automaton<?, ?>, Automaton<?, ParityAcceptance>> {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("nba2dpa", "Converts a non-deterministic generalized B\u00fcchi automaton into a deterministic parity automaton", (commandLine, environment) -> OwlModule.AutomatonTransformer.of(automaton -> new NBA2DPA().apply((Automaton<?, ?>)automaton)));

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.HOA_INPUT_MODULE, List.of(AcceptanceOptimizations.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    @Override
    public Automaton<?, ParityAcceptance> apply(Automaton<?, ?> nba) {
        AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton<?, BuchiAcceptance> ldba = NBA2LDBA.applyLDBA(nba);
        Set<?> initialComponent = Set.copyOf(ldba.initialComponent());
        ParityAcceptance acceptance = new ParityAcceptance(2 * Math.max(1, ldba.automaton().states().size() - initialComponent.size()) + 1, ParityAcceptance.Parity.MIN_ODD);
        RankingState initialState = RankingState.of(Set.copyOf(Sets.intersection(ldba.automaton().initialStates(), initialComponent)), List.copyOf(Sets.difference(ldba.automaton().initialStates(), initialComponent)));
        return new RankingAutomaton(ldba, initialState, acceptance);
    }

    private static final class RankingAutomaton<S>
    extends AbstractImmutableAutomaton<RankingState<S>, ParityAcceptance>
    implements EdgesAutomatonMixin<RankingState<S>, ParityAcceptance> {
        private final Automaton<S, BuchiAcceptance> nba;
        private final Set<S> initialComponent;
        private final LoadingCache<Map.Entry<Set<S>, S>, Boolean> greaterOrEqualCache;

        RankingAutomaton(AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton<S, BuchiAcceptance> LDGBA, RankingState<S> initialState, ParityAcceptance acceptance) {
            super(LDGBA.automaton().factory(), Set.of(initialState), acceptance);
            this.nba = LDGBA.automaton();
            this.initialComponent = Set.copyOf(LDGBA.initialComponent());
            this.greaterOrEqualCache = CacheBuilder.newBuilder().maximumSize(500000L).expireAfterAccess(60L, TimeUnit.SECONDS).build(new CacheLoader<Map.Entry<Set<S>, S>, Boolean>(){

                public Boolean load(Map.Entry<Set<S>, S> entry) {
                    return LanguageContainment.contains(Views.filtered(nba, Views.Filter.of(Set.of(entry.getValue()))), OmegaAcceptanceCast.cast(BooleanOperations.unionBuchi(entry.getKey().stream().map(x -> Views.filtered(nba, Views.Filter.of(Set.of(x)))).collect(Collectors.toList())), BuchiAcceptance.class));
                }
            });
        }

        @Override
        public Set<Edge<RankingState<S>>> edges(RankingState<S> state, BitSet valuation) {
            HashSet<S> initialComponentSuccessors = new HashSet<S>();
            HashSet<S> acceptingComponentSuccessors = new HashSet<S>();
            for (S initialComponentState : state.initialComponentStates()) {
                Set<S> successors = this.nba.successors(initialComponentState, valuation);
                initialComponentSuccessors.addAll(this.onlyInitialComponent(successors));
                acceptingComponentSuccessors.addAll(this.onlyAcceptingComponent(successors));
            }
            int edgeColor = 2 * state.acceptingComponentStates().size();
            ArrayList<Object> ranking = new ArrayList<Object>(state.acceptingComponentStates().size());
            ListIterator<S> iterator = state.acceptingComponentStates().listIterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)Iterables.getOnlyElement(this.nba.edges(iterator.next(), valuation), null);
                if (edge == null) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                Object successor = edge.successor();
                if (this.languageContainedIn(successor, ranking)) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                ranking.add(successor);
                if (!edge.inSet(0)) continue;
                edgeColor = Math.min(2 * iterator.previousIndex() + 1, edgeColor);
            }
            for (Object accState : acceptingComponentSuccessors) {
                if (this.languageContainedIn(accState, ranking)) continue;
                ranking.add(accState);
            }
            if (initialComponentSuccessors.isEmpty() && ranking.isEmpty()) {
                return Set.of();
            }
            Edge dpaEdge = Edge.of(RankingState.of(initialComponentSuccessors, ranking), edgeColor);
            assert (dpaEdge.largestAcceptanceSet() < ((ParityAcceptance)this.acceptance).acceptanceSets());
            return Set.of(dpaEdge);
        }

        private boolean languageContainedIn(S language2, List<S> language1) {
            if (language1.contains(language2)) {
                return true;
            }
            if (language1.isEmpty()) {
                return false;
            }
            return (Boolean)this.greaterOrEqualCache.getUnchecked(Map.entry(Set.copyOf(language1), language2));
        }

        private Set<S> onlyInitialComponent(Set<S> states) {
            return Sets.intersection(states, this.initialComponent);
        }

        private Set<S> onlyAcceptingComponent(Set<S> states) {
            return Sets.difference(states, this.initialComponent);
        }
    }
}

