/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.util.HashMap;
import java.util.List;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAIntermediate;

public class HOAIntermediateResolveAliases
extends HOAIntermediate {
    HashMap<String, BooleanExpression<AtomLabel>> aliases = new HashMap();

    public HOAIntermediateResolveAliases(HOAConsumer next) {
        super(next);
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAIntermediateResolveAliases(next.getNewHOAConsumer());
            }
        };
    }

    private boolean containsAliases(BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        switch (labelExpr.getType()) {
            case EXP_FALSE: 
            case EXP_TRUE: {
                return false;
            }
            case EXP_AND: 
            case EXP_OR: {
                if (this.containsAliases(labelExpr.getLeft())) {
                    return true;
                }
                return this.containsAliases(labelExpr.getRight());
            }
            case EXP_NOT: {
                return this.containsAliases(labelExpr.getLeft());
            }
            case EXP_ATOM: {
                return labelExpr.getAtom().isAlias();
            }
        }
        throw new HOAConsumerException("Unhandled boolean expression type");
    }

    private void checkAliasDefinedness(BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        switch (labelExpr.getType()) {
            case EXP_FALSE: 
            case EXP_TRUE: {
                return;
            }
            case EXP_AND: 
            case EXP_OR: {
                this.checkAliasDefinedness(labelExpr.getLeft());
                this.checkAliasDefinedness(labelExpr.getRight());
                return;
            }
            case EXP_NOT: {
                this.checkAliasDefinedness(labelExpr.getLeft());
                return;
            }
            case EXP_ATOM: {
                String aliasName;
                if (labelExpr.getAtom().isAlias() && !this.aliases.containsKey(aliasName = labelExpr.getAtom().getAliasName())) {
                    throw new HOAConsumerException("Expression " + labelExpr + " uses undefined alias @" + aliasName);
                }
                return;
            }
        }
        throw new HOAConsumerException("Unhandled boolean expression type");
    }

    private BooleanExpression<AtomLabel> resolveAliases(BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        switch (labelExpr.getType()) {
            case EXP_FALSE: 
            case EXP_TRUE: {
                return labelExpr;
            }
            case EXP_AND: 
            case EXP_OR: {
                return new BooleanExpression<AtomLabel>(labelExpr.getType(), this.resolveAliases(labelExpr.getLeft()), this.resolveAliases(labelExpr.getRight()));
            }
            case EXP_NOT: {
                return new BooleanExpression<AtomLabel>(labelExpr.getType(), this.resolveAliases(labelExpr.getLeft()), null);
            }
            case EXP_ATOM: {
                if (!labelExpr.getAtom().isAlias()) {
                    return labelExpr;
                }
                BooleanExpression<AtomLabel> resolved = this.aliases.get(labelExpr.getAtom().getAliasName());
                if (resolved == null) {
                    throw new HOAConsumerException("Can not resolve alias @" + labelExpr.getAtom().getAliasName());
                }
                if (this.containsAliases(resolved)) {
                    resolved = this.resolveAliases(resolved);
                }
                return resolved;
            }
        }
        throw new HOAConsumerException("Unhandled boolean expression type");
    }

    @Override
    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        if (this.aliases.containsKey(name)) {
            throw new HOAConsumerException("Alias " + name + " is defined multiple times!");
        }
        if (this.containsAliases(labelExpr)) {
            this.checkAliasDefinedness(labelExpr);
            labelExpr = this.resolveAliases(labelExpr);
        }
        this.aliases.put(name, labelExpr);
    }

    @Override
    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) throws HOAConsumerException {
        if (labelExpr != null && this.containsAliases(labelExpr)) {
            labelExpr = this.resolveAliases(labelExpr);
        }
        this.next.addState(id, info, labelExpr, accSignature);
    }

    @Override
    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        if (labelExpr != null && this.containsAliases(labelExpr)) {
            labelExpr = this.resolveAliases(labelExpr);
        }
        this.next.addEdgeWithLabel(stateId, labelExpr, conjSuccessors, accSignature);
    }
}

