/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;

final class BitSetIterator
implements IntIterator {
    private final BitSet bitSet;
    private int current = -1;
    private int next;

    BitSetIterator(BitSet bitSet) {
        this.bitSet = bitSet;
        this.next = this.getNext(0);
    }

    private int getNext(int index) {
        return this.bitSet.nextSetBit(index);
    }

    public boolean hasNext() {
        return this.next != -1;
    }

    public int nextInt() {
        if (this.next == -1) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = this.getNext(this.next + 1);
        return this.current;
    }

    public void remove() {
        if (this.current == -1) {
            throw new IllegalStateException();
        }
        assert (this.bitSet.get(this.current));
        this.bitSet.clear(this.current);
    }
}

