/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class PowerBitSetIterator
implements Iterator<BitSet> {
    private final BitSet baseSet;
    private final BitSet iteration;
    private final int baseCardinality;
    private int numSetBits = -1;

    PowerBitSetIterator(BitSet baseSet) {
        this.baseSet = baseSet;
        this.baseCardinality = baseSet.cardinality();
        this.iteration = new BitSet(baseSet.length());
    }

    @Override
    public boolean hasNext() {
        return this.numSetBits < this.baseCardinality;
    }

    @Override
    public BitSet next() {
        if (this.numSetBits == -1) {
            this.numSetBits = 0;
            return this.iteration;
        }
        if (this.numSetBits == this.baseCardinality) {
            throw new NoSuchElementException("No next element");
        }
        IntIterator iterator = BitSets.iterator(this.baseSet);
        while (iterator.hasNext()) {
            int index = iterator.nextInt();
            if (this.iteration.get(index)) {
                this.iteration.clear(index);
                --this.numSetBits;
                continue;
            }
            this.iteration.set(index);
            ++this.numSetBits;
            break;
        }
        return this.iteration;
    }
}

