/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.AbstractNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.ints.IntCollection;
import javax.annotation.Nonnegative;

public abstract class AbstractBoundedNatBitSet
extends AbstractNatBitSet
implements BoundedNatBitSet {
    @Nonnegative
    private final int domainSize;

    protected AbstractBoundedNatBitSet(@Nonnegative int domainSize) {
        if (domainSize <= 0) {
            throw new IllegalArgumentException(String.format("Invalid domain size %d", domainSize));
        }
        this.domainSize = domainSize;
    }

    @Override
    @Nonnegative
    public int domainSize() {
        return this.domainSize;
    }

    @Override
    public boolean add(int index) {
        this.checkInDomain(index);
        return super.add(index);
    }

    @Override
    public void clearFrom(int from) {
        if (from >= this.domainSize) {
            return;
        }
        this.clear(from, this.domainSize);
    }

    @Override
    public void orNot(IntCollection indices) {
        if (indices.isEmpty()) {
            this.set(0, this.domainSize);
        } else {
            for (int i = 0; i < this.domainSize(); ++i) {
                if (indices.contains(i)) continue;
                this.set(i);
            }
        }
    }

    @Override
    public AbstractBoundedNatBitSet clone() {
        return (AbstractBoundedNatBitSet)super.clone();
    }

    public String toString() {
        return this.domainSize + (this.isComplement() ? "(C)" : "") + super.toString();
    }

    abstract boolean isComplement();

    protected boolean inDomain(int index) {
        return 0 <= index && index < this.domainSize;
    }

    protected void checkInDomain(int from, int to) {
        NatBitSetsUtil.checkInDomain(this.domainSize, from, to);
    }

    protected void checkInDomain(int index) {
        NatBitSetsUtil.checkInDomain(this.domainSize, index);
    }
}

