/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.LongNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnegative;

public interface NatBitSetFactory {
    public NatBitSet set(int var1, int var2);

    default public NatBitSet set() {
        return this.set(-1, -1);
    }

    default public NatBitSet setWithExpectedLength(@Nonnegative int expectedLength) {
        return this.set(-1, expectedLength);
    }

    default public NatBitSet setWithExpectedSize(@Nonnegative int expectedSize) {
        return this.set(expectedSize, -1);
    }

    default public NatBitSet setWithMaximalLength(int maximalLength) {
        if (maximalLength < LongNatBitSet.maximalSize()) {
            return new LongNatBitSet();
        }
        return this.set(-1, maximalLength);
    }

    default public NatBitSet copyOf(Collection<Integer> indices) {
        NatBitSet copy;
        if (indices.isEmpty()) {
            copy = NatBitSets.emptySet();
        } else if (indices instanceof NatBitSet) {
            copy = ((NatBitSet)indices).clone();
        } else if (indices instanceof IntSortedSet) {
            copy = this.set(indices.size(), ((IntSortedSet)indices).lastInt());
            copy.or((IntCollection)((IntSortedSet)indices));
        } else {
            copy = this.set(indices.size(), -1);
            copy.addAll((Collection)indices);
        }
        if (!1.$assertionsDisabled && !copy.equals(indices instanceof Set ? indices : new IntAVLTreeSet((Collection)indices))) {
            throw new AssertionError();
        }
        return copy;
    }

    default public NatBitSet modifiableCopyOf(NatBitSet set) {
        return this.modifiableCopyOf(set, Integer.MAX_VALUE);
    }

    default public NatBitSet modifiableCopyOf(NatBitSet set, @Nonnegative int length) {
        if (NatBitSets.isModifiable(set, length)) {
            return set.clone();
        }
        if (set instanceof BoundedNatBitSet && length <= ((BoundedNatBitSet)set).domainSize()) {
            return this.modifiableCopyOf((BoundedNatBitSet)set);
        }
        NatBitSet copy = this.set(set.size(), length);
        copy.or((IntCollection)set);
        if (!(1.$assertionsDisabled || NatBitSets.isModifiable(copy, length) && copy.equals(set))) {
            throw new AssertionError();
        }
        return copy;
    }

    default public boolean isModifiable(NatBitSet set) {
        return this.isModifiable(set, Integer.MAX_VALUE);
    }

    public boolean isModifiable(NatBitSet var1, @Nonnegative int var2);

    default public NatBitSet ensureModifiable(NatBitSet set) {
        return NatBitSets.isModifiable(set) ? set : this.modifiableCopyOf(set);
    }

    default public NatBitSet ensureModifiable(NatBitSet set, @Nonnegative int length) {
        return NatBitSets.isModifiable(set, length) ? set : this.modifiableCopyOf(set, length);
    }

    public BoundedNatBitSet boundedSet(int var1, int var2);

    default public BoundedNatBitSet boundedSet(int domainSize) {
        return this.boundedSet(domainSize, -1);
    }

    default public BoundedNatBitSet boundedFilledSet(int domainSize) {
        return this.boundedFilledSet(domainSize, -1);
    }

    default public BoundedNatBitSet boundedFilledSet(int domainSize, int expectedSize) {
        return this.boundedSet(domainSize, expectedSize).complement();
    }

    default public BoundedNatBitSet modifiableCopyOf(BoundedNatBitSet set) {
        if (NatBitSets.isModifiable(set)) {
            return set.clone();
        }
        BoundedNatBitSet copy = this.boundedSet(set.domainSize(), set.size());
        copy.or((IntCollection)set);
        if (!(1.$assertionsDisabled || NatBitSets.isModifiable(copy, set.domainSize()) && copy.equals(set))) {
            throw new AssertionError();
        }
        return copy;
    }

    public boolean isModifiable(BoundedNatBitSet var1);

    public BoundedNatBitSet ensureBounded(NatBitSet var1, @Nonnegative int var2);

    default public NatBitSet ensureModifiable(BoundedNatBitSet set) {
        return NatBitSets.isModifiable(set) ? set : this.modifiableCopyOf(set);
    }

    default public NatBitSet compact(NatBitSet set) {
        return this.compact(set, false);
    }

    public NatBitSet compact(NatBitSet var1, boolean var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

