/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.AbstractBdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import de.tum.in.jbdd.PowerIterator;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;

class BddRecursive
extends AbstractBdd {
    BddRecursive(int nodeSize) {
        this(nodeSize, ImmutableBddConfiguration.builder().build());
    }

    BddRecursive(int nodeSize, BddConfiguration configuration) {
        super(nodeSize, configuration);
    }

    @Override
    protected void afterVariableCountChanged() {
    }

    @Override
    public Iterator<BitSet> solutionIterator(int node) {
        if (node == 0) {
            return Collections.emptyIterator();
        }
        if (node == 1) {
            return new PowerIterator(this.numberOfVariables);
        }
        return new AbstractBdd.NodeSolutionIterator(this, node);
    }

    @Override
    public void forEachPath(int node, int highestVariable, BiConsumer<BitSet, BitSet> action) {
        int depthLimit;
        int bitSetSize;
        assert (this.isNodeValidOrRoot(node) && highestVariable >= 0);
        if (node == 0) {
            return;
        }
        if (node == 1) {
            action.accept(new BitSet(0), new BitSet(0));
            return;
        }
        int numberOfVariables = this.numberOfVariables();
        if (highestVariable >= numberOfVariables) {
            bitSetSize = numberOfVariables;
            depthLimit = Integer.MAX_VALUE;
        } else {
            bitSetSize = highestVariable;
            depthLimit = highestVariable;
        }
        BitSet path = new BitSet(bitSetSize);
        BitSet pathSupport = new BitSet(bitSetSize);
        this.forEachPathRecursive(node, depthLimit, path, pathSupport, action);
    }

    private void forEachPathRecursive(int node, int highestVariable, BitSet path, BitSet pathSupport, BiConsumer<BitSet, BitSet> action) {
        int highNode;
        assert (this.isNodeValid(node) || node == 1);
        if (node == 1) {
            action.accept(path, pathSupport);
            return;
        }
        long store = this.getNodeStore(node);
        int variable = (int)BddRecursive.getVariableFromStore(store);
        if (variable > highestVariable) {
            action.accept(path, pathSupport);
            return;
        }
        pathSupport.set(variable);
        int lowNode = (int)BddRecursive.getLowFromStore(store);
        if (lowNode != 0) {
            this.forEachPathRecursive(lowNode, highestVariable, path, pathSupport, action);
        }
        if ((highNode = (int)BddRecursive.getHighFromStore(store)) != 0) {
            path.set(variable);
            this.forEachPathRecursive(highNode, highestVariable, path, pathSupport, action);
            path.clear(variable);
        }
        assert (pathSupport.get(variable));
        pathSupport.clear(variable);
    }

    @Override
    public void support(int node, BitSet bitSet, int variableCutoff) {
        assert (this.isNodeValidOrRoot(node));
        assert (0 <= variableCutoff);
        this.supportRecursive(node, bitSet, variableCutoff);
        this.unMarkAllBelow(node);
    }

    private void supportRecursive(int node, BitSet bitSet, int variableCutoff) {
        if (this.isNodeRoot(node)) {
            return;
        }
        long nodeStore = this.getNodeStore(node);
        if (BddRecursive.isNodeStoreMarked(nodeStore)) {
            return;
        }
        int variable = (int)BddRecursive.getVariableFromStore(nodeStore);
        if (variable < variableCutoff) {
            bitSet.set(variable);
            this.markNode(node);
            this.supportRecursive((int)BddRecursive.getLowFromStore(nodeStore), bitSet, variableCutoff);
            this.supportRecursive((int)BddRecursive.getHighFromStore(nodeStore), bitSet, variableCutoff);
        }
    }

    @Override
    public BigInteger countSatisfyingAssignments(int node) {
        if (node == 0) {
            return BigInteger.ZERO;
        }
        if (node == 1) {
            return TWO.pow(this.numberOfVariables);
        }
        long nodeStore = this.getNodeStore(node);
        int variable = (int)BddRecursive.getVariableFromStore(nodeStore);
        return TWO.pow(variable).multiply(this.countSatisfyingAssignmentsRecursive(node));
    }

    private BigInteger countSatisfyingAssignmentsRecursive(int node) {
        if (node == 0) {
            return BigInteger.ZERO;
        }
        if (node == 1) {
            return BigInteger.ONE;
        }
        BigInteger cacheLookup = this.cache.lookupSatisfaction(node);
        if (cacheLookup != null) {
            return cacheLookup;
        }
        int hash = this.cache.getLookupHash();
        long nodeStore = this.getNodeStore(node);
        int nodeVar = (int)BddRecursive.getVariableFromStore(nodeStore);
        BigInteger lowCount = this.doCountSatisfyingAssignments((int)BddRecursive.getLowFromStore(nodeStore), nodeVar);
        BigInteger highCount = this.doCountSatisfyingAssignments((int)BddRecursive.getHighFromStore(nodeStore), nodeVar);
        BigInteger result = lowCount.add(highCount);
        this.cache.putSatisfaction(hash, node, result);
        return result;
    }

    private BigInteger doCountSatisfyingAssignments(int subNode, int currentVar) {
        if (subNode == 0) {
            return BigInteger.ZERO;
        }
        if (subNode == 1) {
            return TWO.pow(this.numberOfVariables - currentVar - 1);
        }
        long subStore = this.getNodeStore(subNode);
        int subVar = (int)BddRecursive.getVariableFromStore(subStore);
        BigInteger multiplier = TWO.pow(subVar - currentVar - 1);
        return multiplier.multiply(this.countSatisfyingAssignmentsRecursive(subNode));
    }

    @Override
    public int conjunction(int ... variables) {
        int node = 1;
        for (int variable : variables) {
            this.pushToWorkStack(node);
            node = this.andRecursive(node, this.variableNodes[variable]);
            this.popWorkStack();
        }
        return node;
    }

    @Override
    public int conjunction(BitSet variables) {
        int node = 1;
        int currentVariableNumber = variables.nextSetBit(0);
        while (currentVariableNumber != -1) {
            this.pushToWorkStack(node);
            node = this.andRecursive(node, this.variableNodes[currentVariableNumber]);
            this.popWorkStack();
            currentVariableNumber = variables.nextSetBit(currentVariableNumber + 1);
        }
        return node;
    }

    @Override
    public int disjunction(int ... variables) {
        int node = 0;
        for (int variable : variables) {
            this.pushToWorkStack(node);
            node = this.orRecursive(node, this.variableNodes[variable]);
            this.popWorkStack();
        }
        return node;
    }

    @Override
    public int disjunction(BitSet variables) {
        int node = 0;
        int currentVariableNumber = variables.nextSetBit(0);
        while (currentVariableNumber != -1) {
            this.pushToWorkStack(node);
            node = this.orRecursive(node, this.variableNodes[currentVariableNumber]);
            this.popWorkStack();
            currentVariableNumber = variables.nextSetBit(currentVariableNumber + 1);
        }
        return node;
    }

    @Override
    public int and(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.andRecursive(node1, node2);
        this.popWorkStack(2);
        return result;
    }

    private int andRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        if (node1 == node2 || node2 == 1) {
            return node1;
        }
        if (node1 == 0 || node2 == 0) {
            return 0;
        }
        if (node1 == 1) {
            return node2;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        int node2var = (int)BddRecursive.getVariableFromStore(node2store);
        if (node2var < node1var || node2var == node1var && node2 < node1) {
            int nodeSwap = node1;
            node1 = node2;
            node2 = nodeSwap;
            int varSwap = node1var;
            node1var = node2var;
            node2var = varSwap;
            long storeSwap = node1store;
            node1store = node2store;
            node2store = storeSwap;
        }
        if (this.cache.lookupAnd(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.andRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.andRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store));
            this.pushToWorkStack(highNode);
        } else {
            lowNode = this.pushToWorkStack(this.andRecursive((int)BddRecursive.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.andRecursive((int)BddRecursive.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putAnd(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int compose(int node, int[] variableNodes) {
        int hash;
        assert (variableNodes.length <= this.numberOfVariables);
        if (node == 1 || node == 0) {
            return node;
        }
        this.pushToWorkStack(node);
        int workStackCount = 1;
        for (int i = 0; i < variableNodes.length; ++i) {
            if (variableNodes[i] == -1) {
                variableNodes[i] = this.variableNodes[i];
                continue;
            }
            assert (this.isNodeValidOrRoot(variableNodes[i]));
            if (this.isNodeSaturated(variableNodes[i])) continue;
            this.pushToWorkStack(variableNodes[i]);
            ++workStackCount;
        }
        int highestReplacedVariable = variableNodes.length - 1;
        for (int i = variableNodes.length - 1; i >= 0; --i) {
            if (variableNodes[i] == this.variableNodes[i]) continue;
            highestReplacedVariable = i;
            break;
        }
        if (highestReplacedVariable == -1) {
            return node;
        }
        if (this.getConfiguration().useGlobalComposeCache()) {
            if (this.cache.lookupCompose(node, variableNodes)) {
                return this.cache.getLookupResult();
            }
            hash = this.cache.getLookupHash();
        } else {
            hash = -1;
        }
        this.cache.clearVolatileCache();
        int result = this.composeRecursive(node, variableNodes, highestReplacedVariable);
        this.popWorkStack(workStackCount);
        if (this.getConfiguration().useGlobalComposeCache()) {
            this.cache.putCompose(hash, node, variableNodes, result);
        }
        return result;
    }

    private int composeRecursive(int node, int[] variableNodes, int highestReplacedVariable) {
        int resultNode;
        if (node == 1 || node == 0) {
            return node;
        }
        long nodeStore = this.getNodeStore(node);
        int nodeVariable = (int)BddRecursive.getVariableFromStore(nodeStore);
        if (nodeVariable > highestReplacedVariable) {
            return node;
        }
        if (this.cache.lookupVolatile(node)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        int variableReplacementNode = variableNodes[nodeVariable];
        if (variableReplacementNode == 1) {
            resultNode = this.composeRecursive((int)BddRecursive.getHighFromStore(nodeStore), variableNodes, highestReplacedVariable);
        } else if (variableReplacementNode == 0) {
            resultNode = this.composeRecursive((int)BddRecursive.getLowFromStore(nodeStore), variableNodes, highestReplacedVariable);
        } else {
            int lowCompose = this.pushToWorkStack(this.composeRecursive((int)BddRecursive.getLowFromStore(nodeStore), variableNodes, highestReplacedVariable));
            int highCompose = this.pushToWorkStack(this.composeRecursive((int)BddRecursive.getHighFromStore(nodeStore), variableNodes, highestReplacedVariable));
            resultNode = this.ifThenElseRecursive(variableReplacementNode, highCompose, lowCompose);
            this.popWorkStack(2);
        }
        this.cache.putVolatile(hash, node, resultNode);
        return resultNode;
    }

    @Override
    public int equivalence(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.equivalenceRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int equivalenceRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        if (node1 == node2) {
            return 1;
        }
        if (node1 == 0) {
            return this.notRecursive(node2);
        }
        if (node1 == 1) {
            return node2;
        }
        if (node2 == 0) {
            return this.notRecursive(node1);
        }
        if (node2 == 1) {
            return node1;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        int node2var = (int)BddRecursive.getVariableFromStore(node2store);
        if (node2var < node1var || node2var == node1var && node2 < node1) {
            int nodeSwap = node1;
            node1 = node2;
            node2 = nodeSwap;
            int varSwap = node1var;
            node1var = node2var;
            node2var = varSwap;
            long storeSwap = node1store;
            node1store = node2store;
            node2store = storeSwap;
        }
        if (this.cache.lookupEquivalence(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.equivalenceRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.equivalenceRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store));
            this.pushToWorkStack(highNode);
        } else {
            lowNode = this.pushToWorkStack(this.equivalenceRecursive((int)BddRecursive.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.equivalenceRecursive((int)BddRecursive.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putEquivalence(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int exists(int node, BitSet quantifiedVariables) {
        return this.getConfiguration().useShannonExists() ? this.existsShannon(node, quantifiedVariables) : this.existsSelfSubstitution(node, quantifiedVariables);
    }

    @Override
    int existsSelfSubstitution(int node, BitSet quantifiedVariables) {
        assert (quantifiedVariables.previousSetBit(quantifiedVariables.length()) <= this.numberOfVariables);
        if (quantifiedVariables.cardinality() == this.numberOfVariables) {
            return 1;
        }
        if (node == 1 || node == 0) {
            return node;
        }
        this.pushToWorkStack(node);
        int[] replacementArray = new int[quantifiedVariables.length()];
        System.arraycopy(this.variableNodes, 0, replacementArray, 0, replacementArray.length);
        int quantifiedNode = node;
        int workStackElements = 1;
        for (int i = 0; i < quantifiedVariables.length(); ++i) {
            if (!quantifiedVariables.get(i)) continue;
            int variableNode = replacementArray[i];
            replacementArray[i] = 1;
            this.cache.clearVolatileCache();
            replacementArray[i] = this.pushToWorkStack(this.composeRecursive(quantifiedNode, replacementArray, i));
            this.cache.clearVolatileCache();
            quantifiedNode = this.composeRecursive(quantifiedNode, replacementArray, i);
            this.popWorkStack();
            replacementArray[i] = variableNode;
            this.pushToWorkStack(quantifiedNode);
            ++workStackElements;
        }
        this.popWorkStack(workStackElements);
        return quantifiedNode;
    }

    @Override
    int existsShannon(int node, BitSet quantifiedVariables) {
        assert (quantifiedVariables.previousSetBit(quantifiedVariables.length()) <= this.numberOfVariables);
        if (quantifiedVariables.cardinality() == this.numberOfVariables) {
            return 1;
        }
        this.pushToWorkStack(node);
        int quantifiedVariablesConjunction = this.conjunction(quantifiedVariables);
        this.pushToWorkStack(quantifiedVariablesConjunction);
        int result = this.existsShannonRecursive(node, quantifiedVariablesConjunction);
        this.popWorkStack(2);
        return result;
    }

    private int existsShannonRecursive(int node, int quantifiedVariableCube) {
        if (node == 1 || node == 0) {
            return node;
        }
        if (quantifiedVariableCube == 1) {
            return node;
        }
        long nodeStore = this.getNodeStore(node);
        int nodeVariable = (int)BddRecursive.getVariableFromStore(nodeStore);
        int currentCubeNode = quantifiedVariableCube;
        long currentCubeNodeStore = this.getNodeStore(currentCubeNode);
        int currentCubeNodeVariable = (int)BddRecursive.getVariableFromStore(currentCubeNodeStore);
        while (currentCubeNodeVariable < nodeVariable) {
            currentCubeNode = (int)BddRecursive.getHighFromStore(currentCubeNodeStore);
            if (currentCubeNode == 1) {
                return node;
            }
            currentCubeNodeStore = this.getNodeStore(currentCubeNode);
            currentCubeNodeVariable = (int)BddRecursive.getVariableFromStore(currentCubeNodeStore);
        }
        if (BddRecursive.isVariableOrNegatedStore(nodeStore)) {
            if (nodeVariable == currentCubeNodeVariable) {
                return 1;
            }
            return node;
        }
        if (this.cache.lookupExists(node, currentCubeNode)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        int lowExists = this.pushToWorkStack(this.existsShannonRecursive((int)BddRecursive.getLowFromStore(nodeStore), currentCubeNode));
        int highExists = this.pushToWorkStack(this.existsShannonRecursive((int)BddRecursive.getHighFromStore(nodeStore), currentCubeNode));
        int resultNode = currentCubeNodeVariable > nodeVariable ? this.makeNode(nodeVariable, lowExists, highExists) : this.orRecursive(lowExists, highExists);
        this.popWorkStack(2);
        this.cache.putExists(hash, node, currentCubeNode, resultNode);
        return resultNode;
    }

    @Override
    public int ifThenElse(int ifNode, int thenNode, int elseNode) {
        assert (this.isNodeValidOrRoot(ifNode) && this.isNodeValidOrRoot(thenNode) && this.isNodeValidOrRoot(elseNode));
        this.pushToWorkStack(ifNode);
        this.pushToWorkStack(thenNode);
        this.pushToWorkStack(elseNode);
        int result = this.ifThenElseRecursive(ifNode, thenNode, elseNode);
        this.popWorkStack(3);
        return result;
    }

    private int ifThenElseRecursive(int ifNode, int thenNode, int elseNode) {
        int elseHighNode;
        int elseLowNode;
        int thenHighNode;
        int thenLowNode;
        int ifHighNode;
        int ifLowNode;
        int elseVar;
        int thenVar;
        int minVar;
        if (ifNode == 1) {
            return thenNode;
        }
        if (ifNode == 0) {
            return elseNode;
        }
        if (thenNode == elseNode) {
            return thenNode;
        }
        if (thenNode == 1) {
            if (elseNode == 0) {
                return ifNode;
            }
            return this.orRecursive(ifNode, elseNode);
        }
        if (thenNode == 0) {
            if (elseNode == 1) {
                return this.notRecursive(ifNode);
            }
            int result = this.andRecursive(this.pushToWorkStack(this.notRecursive(ifNode)), elseNode);
            this.popWorkStack();
            return result;
        }
        if (elseNode == 1) {
            int result = this.notAndRecursive(ifNode, this.pushToWorkStack(this.notRecursive(thenNode)));
            this.popWorkStack();
            return result;
        }
        if (elseNode == 0) {
            return this.andRecursive(ifNode, thenNode);
        }
        if (ifNode == thenNode) {
            return this.orRecursive(ifNode, elseNode);
        }
        if (ifNode == elseNode) {
            return this.andRecursive(ifNode, thenNode);
        }
        if (this.cache.lookupIfThenElse(ifNode, thenNode, elseNode)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        long ifStore = this.getNodeStore(ifNode);
        long thenStore = this.getNodeStore(thenNode);
        long elseStore = this.getNodeStore(elseNode);
        int ifVar = (int)BddRecursive.getVariableFromStore(ifStore);
        if (ifVar == (minVar = Math.min(ifVar, Math.min(thenVar = (int)BddRecursive.getVariableFromStore(thenStore), elseVar = (int)BddRecursive.getVariableFromStore(elseStore))))) {
            ifLowNode = (int)BddRecursive.getLowFromStore(ifStore);
            ifHighNode = (int)BddRecursive.getHighFromStore(ifStore);
        } else {
            ifLowNode = ifNode;
            ifHighNode = ifNode;
        }
        if (thenVar == minVar) {
            thenLowNode = (int)BddRecursive.getLowFromStore(thenStore);
            thenHighNode = (int)BddRecursive.getHighFromStore(thenStore);
        } else {
            thenLowNode = thenNode;
            thenHighNode = thenNode;
        }
        if (elseVar == minVar) {
            elseLowNode = (int)BddRecursive.getLowFromStore(elseStore);
            elseHighNode = (int)BddRecursive.getHighFromStore(elseStore);
        } else {
            elseLowNode = elseNode;
            elseHighNode = elseNode;
        }
        int lowNode = this.pushToWorkStack(this.ifThenElseRecursive(ifLowNode, thenLowNode, elseLowNode));
        int highNode = this.pushToWorkStack(this.ifThenElseRecursive(ifHighNode, thenHighNode, elseHighNode));
        int result = this.makeNode(minVar, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putIfThenElse(hash, ifNode, thenNode, elseNode, result);
        return result;
    }

    @Override
    public int implication(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.implicationRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int implicationRecursive(int node1, int node2) {
        int decisionVar;
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == 0 || node2 == 1 || node1 == node2) {
            return 1;
        }
        if (node1 == 1) {
            return node2;
        }
        if (node2 == 0) {
            return this.notRecursive(node1);
        }
        if (this.cache.lookupImplication(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddRecursive.getVariableFromStore(node2store))) {
            lowNode = this.pushToWorkStack(this.implicationRecursive(node1, (int)BddRecursive.getLowFromStore(node2store)));
            highNode = this.pushToWorkStack(this.implicationRecursive(node1, (int)BddRecursive.getHighFromStore(node2store)));
            decisionVar = node2var;
        } else if (node1var == node2var) {
            lowNode = this.pushToWorkStack(this.implicationRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store)));
            highNode = this.pushToWorkStack(this.implicationRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store)));
            decisionVar = node1var;
        } else {
            lowNode = this.pushToWorkStack(this.implicationRecursive((int)BddRecursive.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.implicationRecursive((int)BddRecursive.getHighFromStore(node1store), node2));
            decisionVar = node1var;
        }
        int resultNode = this.makeNode(decisionVar, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putImplication(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public boolean implies(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        return this.impliesRecursive(node1, node2);
    }

    private boolean impliesRecursive(int node1, int node2) {
        int node2var;
        if (node1 == 0) {
            return true;
        }
        if (node2 == 0) {
            return false;
        }
        if (node2 == 1) {
            return true;
        }
        if (node1 == 1) {
            return false;
        }
        if (node1 == node2) {
            return true;
        }
        if (this.cache.lookupImplication(node1, node2)) {
            return this.cache.getLookupResult() == 1;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        if (node1var == (node2var = (int)BddRecursive.getVariableFromStore(node2store))) {
            return this.impliesRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store)) && this.impliesRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store));
        }
        if (node1var < node2var) {
            return this.impliesRecursive((int)BddRecursive.getLowFromStore(node1store), node2) && this.impliesRecursive((int)BddRecursive.getHighFromStore(node1store), node2);
        }
        return this.impliesRecursive(node1, (int)BddRecursive.getLowFromStore(node2store)) && this.impliesRecursive(node1, (int)BddRecursive.getHighFromStore(node2store));
    }

    @Override
    public int not(int node) {
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        int ret = this.notRecursive(node);
        this.popWorkStack();
        return ret;
    }

    private int notRecursive(int node) {
        if (node == 0) {
            return 1;
        }
        if (node == 1) {
            return 0;
        }
        if (this.cache.lookupNot(node)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        long nodeStore = this.getNodeStore(node);
        int lowNode = this.pushToWorkStack(this.notRecursive((int)BddRecursive.getLowFromStore(nodeStore)));
        int highNode = this.pushToWorkStack(this.notRecursive((int)BddRecursive.getHighFromStore(nodeStore)));
        int resultNode = this.makeNode((int)BddRecursive.getVariableFromStore(nodeStore), lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putNot(hash, node, resultNode);
        return resultNode;
    }

    @Override
    public int notAnd(int node1, int node2) {
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.notAndRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int notAndRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        if (node1 == 0 || node2 == 0) {
            return 1;
        }
        if (node1 == 1 || node1 == node2) {
            return this.notRecursive(node2);
        }
        if (node2 == 1) {
            return this.notRecursive(node1);
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        int node2var = (int)BddRecursive.getVariableFromStore(node2store);
        if (node2var < node1var || node2var == node1var && node2 < node1) {
            int nodeSwap = node1;
            node1 = node2;
            node2 = nodeSwap;
            int varSwap = node1var;
            node1var = node2var;
            node2var = varSwap;
            long storeSwap = node1store;
            node1store = node2store;
            node2store = storeSwap;
        }
        if (this.cache.lookupNAnd(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.notAndRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.notAndRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store));
            this.pushToWorkStack(highNode);
        } else {
            lowNode = this.pushToWorkStack(this.notAndRecursive((int)BddRecursive.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.notAndRecursive((int)BddRecursive.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putNAnd(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int or(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.orRecursive(node1, node2);
        this.popWorkStack(2);
        return result;
    }

    private int orRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        if (node1 == 1 || node2 == 1) {
            return 1;
        }
        if (node1 == 0 || node1 == node2) {
            return node2;
        }
        if (node2 == 0) {
            return node1;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        int node2var = (int)BddRecursive.getVariableFromStore(node2store);
        if (node2var < node1var || node2var == node1var && node2 < node1) {
            int nodeSwap = node1;
            node1 = node2;
            node2 = nodeSwap;
            int varSwap = node1var;
            node1var = node2var;
            node2var = varSwap;
            long storeSwap = node1store;
            node1store = node2store;
            node2store = storeSwap;
        }
        if (this.cache.lookupOr(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.orRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.pushToWorkStack(this.orRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store)));
        } else {
            lowNode = this.pushToWorkStack(this.orRecursive((int)BddRecursive.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.orRecursive((int)BddRecursive.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putOr(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int restrict(int node, BitSet restrictedVariables, BitSet restrictedVariableValues) {
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        this.cache.clearVolatileCache();
        int resultNode = this.restrictRecursive(node, restrictedVariables, restrictedVariableValues);
        this.popWorkStack();
        return resultNode;
    }

    private int restrictRecursive(int node, BitSet restrictedVariables, BitSet restrictedVariableValues) {
        int resultNode;
        if (node == 1 || node == 0) {
            return node;
        }
        long nodeStore = this.getNodeStore(node);
        int nodeVariable = (int)BddRecursive.getVariableFromStore(nodeStore);
        if (nodeVariable >= restrictedVariables.length()) {
            return node;
        }
        if (this.cache.lookupVolatile(node)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (restrictedVariables.get(nodeVariable)) {
            resultNode = restrictedVariableValues.get(nodeVariable) ? this.restrictRecursive((int)BddRecursive.getHighFromStore(nodeStore), restrictedVariables, restrictedVariableValues) : this.restrictRecursive((int)BddRecursive.getLowFromStore(nodeStore), restrictedVariables, restrictedVariableValues);
        } else {
            int lowRestrict = this.pushToWorkStack(this.restrictRecursive((int)BddRecursive.getLowFromStore(nodeStore), restrictedVariables, restrictedVariableValues));
            int highRestrict = this.pushToWorkStack(this.restrictRecursive((int)BddRecursive.getHighFromStore(nodeStore), restrictedVariables, restrictedVariableValues));
            resultNode = this.makeNode(nodeVariable, lowRestrict, highRestrict);
            this.popWorkStack(2);
        }
        this.cache.putVolatile(hash, node, resultNode);
        return resultNode;
    }

    @Override
    public int xor(int node1, int node2) {
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.xorRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int xorRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        if (node1 == node2) {
            return 0;
        }
        if (node1 == 0) {
            return node2;
        }
        if (node2 == 0) {
            return node1;
        }
        if (node1 == 1) {
            return this.notRecursive(node2);
        }
        if (node2 == 1) {
            return this.notRecursive(node1);
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddRecursive.getVariableFromStore(node1store);
        int node2var = (int)BddRecursive.getVariableFromStore(node2store);
        if (node2var < node1var || node2var == node1var && node2 < node1) {
            int nodeSwap = node1;
            node1 = node2;
            node2 = nodeSwap;
            int varSwap = node1var;
            node1var = node2var;
            node2var = varSwap;
            long storeSwap = node1store;
            node1store = node2store;
            node2store = storeSwap;
        }
        if (this.cache.lookupXor(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.xorRecursive((int)BddRecursive.getLowFromStore(node1store), (int)BddRecursive.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.pushToWorkStack(this.xorRecursive((int)BddRecursive.getHighFromStore(node1store), (int)BddRecursive.getHighFromStore(node2store)));
        } else {
            lowNode = this.pushToWorkStack(this.xorRecursive((int)BddRecursive.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.xorRecursive((int)BddRecursive.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putXor(hash, node1, node2, resultNode);
        return resultNode;
    }
}

