/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import owl.collections.ImmutableBitSet;

public final class UltimatelyPeriodicWord {
    public final List<ImmutableBitSet> prefix;
    public final List<ImmutableBitSet> period;

    public UltimatelyPeriodicWord(List<BitSet> prefix, List<BitSet> period) {
        this.prefix = prefix.stream().map(ImmutableBitSet::copyOf).collect(Collectors.toUnmodifiableList());
        this.period = period.stream().map(ImmutableBitSet::copyOf).collect(Collectors.toUnmodifiableList());
        Preconditions.checkArgument((!this.period.isEmpty() ? 1 : 0) != 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UltimatelyPeriodicWord)) {
            return false;
        }
        UltimatelyPeriodicWord that = (UltimatelyPeriodicWord)o;
        return this.prefix.equals(that.prefix) && this.period.equals(that.period);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.period);
    }
}

