/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnegative;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

public class GeneralizedRabinAcceptance
extends EmersonLeiAcceptance {
    protected final List<RabinPair> pairs;

    GeneralizedRabinAcceptance(List<RabinPair> pairs) {
        super(GeneralizedRabinAcceptance.validate(pairs));
        this.pairs = List.copyOf(pairs);
        assert (pairs == this.pairs) : "List.copyOf() created a copy, but pairs should have been already immutable.";
    }

    private static int validate(List<RabinPair> pairs) {
        int count = 0;
        for (RabinPair pair : pairs) {
            Preconditions.checkArgument((count == pair.finIndex ? 1 : 0) != 0);
            Preconditions.checkArgument((pair.finIndex <= pair.infIndex ? 1 : 0) != 0);
            count += pair.infSetCount() + 1;
        }
        return count;
    }

    @Override
    public Optional<ImmutableBitSet> acceptingSet() {
        if (this.pairs.isEmpty()) {
            return Optional.empty();
        }
        BitSet set = new BitSet();
        this.pairs.get(0).forEachInfSet(set::set);
        return Optional.of(ImmutableBitSet.copyOf(set));
    }

    @Override
    public Optional<ImmutableBitSet> rejectingSet() {
        BitSet set = new BitSet();
        this.pairs.forEach(x -> set.set(x.finIndex));
        return Optional.of(ImmutableBitSet.copyOf(set));
    }

    public static GeneralizedRabinAcceptance of(RabinPair ... pairs) {
        return GeneralizedRabinAcceptance.of(List.of(pairs));
    }

    public static GeneralizedRabinAcceptance of(List<RabinPair> pairs) {
        return new GeneralizedRabinAcceptance(List.copyOf(pairs));
    }

    public static Optional<? extends GeneralizedRabinAcceptance> ofPartial(PropositionalFormula<Integer> expression) {
        TreeMap<Integer, Range> rabinPairs = new TreeMap<Integer, Range>();
        for (PropositionalFormula<Integer> dis : PropositionalFormula.disjuncts(expression)) {
            int fin = -1;
            BitSet infSets = new BitSet();
            for (PropositionalFormula<Integer> element : PropositionalFormula.conjuncts(dis)) {
                if (element instanceof PropositionalFormula.Variable) {
                    infSets.set((Integer)((PropositionalFormula.Variable)element).variable);
                    continue;
                }
                if (element instanceof PropositionalFormula.Negation) {
                    if (fin != -1) {
                        return Optional.empty();
                    }
                    fin = (Integer)((PropositionalFormula.Variable)((PropositionalFormula.Negation)element).operand).variable;
                    continue;
                }
                return Optional.empty();
            }
            if (fin < 0 || rabinPairs.containsKey(fin)) {
                return Optional.empty();
            }
            int lower = infSets.nextSetBit(0);
            int upper = infSets.previousSetBit(infSets.length());
            if (lower == -1) {
                rabinPairs.put(fin, Range.closedOpen((Comparable)Integer.valueOf(fin + 1), (Comparable)Integer.valueOf(fin + 1)));
                continue;
            }
            if (infSets.cardinality() != upper + 1 - lower) {
                return Optional.empty();
            }
            rabinPairs.put(fin, Range.closedOpen((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper + 1)));
        }
        Builder builder = new Builder();
        int setCount = 0;
        for (Map.Entry entry : rabinPairs.entrySet()) {
            int fin = (Integer)entry.getKey();
            Range infs = (Range)entry.getValue();
            assert (infs.lowerBoundType() == BoundType.CLOSED && infs.upperBoundType() == BoundType.OPEN);
            if (fin != setCount || (Integer)infs.lowerEndpoint() != fin + 1) {
                return Optional.empty();
            }
            setCount = (Integer)infs.upperEndpoint();
            builder.add((Integer)infs.upperEndpoint() - (Integer)infs.lowerEndpoint());
        }
        return Optional.of(builder.build());
    }

    @Override
    public PropositionalFormula<Integer> lazyBooleanExpression() {
        return PropositionalFormula.Disjunction.of(this.pairs.stream().map(rec$ -> ((RabinPair)rec$).booleanExpression()).collect(Collectors.toList()));
    }

    @Override
    public String name() {
        return "generalized-Rabin";
    }

    @Override
    public List<Object> nameExtra() {
        ArrayList<Object> extra = new ArrayList<Object>(this.pairs.size() + 1);
        extra.add(this.pairs.size());
        for (RabinPair pair : this.pairs) {
            extra.add(pair.infSetCount());
        }
        return extra;
    }

    public List<RabinPair> pairs() {
        return this.pairs;
    }

    public GeneralizedRabinAcceptance filter(IntPredicate predicate) {
        ArrayList<RabinPair> newPairs = new ArrayList<RabinPair>(this.pairs.size());
        int removedIndices = 0;
        for (RabinPair pair : this.pairs) {
            if (predicate.test(pair.finIndex)) {
                removedIndices += pair.infSetCount() + 1;
                continue;
            }
            int removedInfIndices = 0;
            for (int i = pair.finIndex + 1; i <= pair.infIndex; ++i) {
                if (!predicate.test(i)) continue;
                ++removedInfIndices;
            }
            assert (pair.finIndex >= removedIndices);
            assert (pair.infIndex >= removedIndices + removedInfIndices);
            newPairs.add(new RabinPair(pair.finIndex - removedIndices, pair.infIndex - (removedIndices + removedInfIndices)));
            removedIndices += removedInfIndices;
        }
        if (newPairs.stream().allMatch(x -> x.infSetCount() == 1)) {
            return RabinAcceptance.of(newPairs);
        }
        return GeneralizedRabinAcceptance.of(newPairs);
    }

    public static final class Builder {
        private final List<RabinPair> pairs = new ArrayList<RabinPair>();
        private int sets = 0;

        public RabinPair add(@Nonnegative int infSets) {
            RabinPair pair = new RabinPair(this.sets, this.sets + infSets);
            this.pairs.add(pair);
            this.sets += 1 + infSets;
            return pair;
        }

        public GeneralizedRabinAcceptance build() {
            return GeneralizedRabinAcceptance.of(this.pairs);
        }
    }

    public static final class RabinPair
    implements Comparable<RabinPair> {
        @Nonnegative
        final int finIndex;
        @Nonnegative
        final int infIndex;

        RabinPair(@Nonnegative int finIndex, int infIndex) {
            assert (infIndex >= finIndex);
            this.finIndex = finIndex;
            this.infIndex = infIndex;
        }

        public static RabinPair of(@Nonnegative int finIndex) {
            return RabinPair.ofGeneralized(finIndex, 1);
        }

        public static RabinPair ofGeneralized(@Nonnegative int finIndex, @Nonnegative int infSets) {
            return new RabinPair(finIndex, finIndex + infSets);
        }

        public boolean contains(ImmutableBitSet indices) {
            return !indices.copyInto(new BitSet()).get(this.finIndex, this.infIndex + 1).isEmpty();
        }

        public boolean contains(Edge<?> edge) {
            return edge.colours().contains(this.finIndex) || this.containsInfinite(edge);
        }

        public boolean containsInfinite(Edge<?> edge) {
            for (int i = this.finIndex + 1; i <= this.infIndex; ++i) {
                if (!edge.colours().contains(i)) continue;
                return true;
            }
            return false;
        }

        public void forEachIndex(IntConsumer action) {
            action.accept(this.finIndex);
            this.forEachInfSet(action);
        }

        public void forEachInfSet(IntConsumer action) {
            for (int i = this.finIndex + 1; i <= this.infIndex; ++i) {
                action.accept(i);
            }
        }

        private PropositionalFormula<Integer> booleanExpression() {
            ArrayList<PropositionalFormula<Integer>> conjuncts = new ArrayList<PropositionalFormula<Integer>>();
            conjuncts.add(PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(this.finIndex)));
            for (int index = this.finIndex + 1; index <= this.infIndex; ++index) {
                conjuncts.add(PropositionalFormula.Variable.of(index));
            }
            return PropositionalFormula.Conjunction.of(conjuncts);
        }

        @Nonnegative
        public int finSet() {
            return this.finIndex;
        }

        @Nonnegative
        public int infSet(int number) {
            assert (this.finIndex + number < this.infIndex);
            return this.finIndex + 1 + number;
        }

        @Nonnegative
        public int infSetCount() {
            return this.infIndex - this.finIndex;
        }

        public boolean hasInfSet() {
            return this.infSetCount() > 0;
        }

        public IntStream infSetStream() {
            return IntStream.rangeClosed(this.finIndex + 1, this.infIndex);
        }

        public boolean isInfinite(int i) {
            return this.finIndex < i && i <= this.infIndex;
        }

        public int infSet() {
            Preconditions.checkState((this.infSetCount() == 1 ? 1 : 0) != 0);
            return this.infIndex;
        }

        public String toString() {
            return "(" + this.finIndex + ", " + this.infIndex + ")";
        }

        @Override
        public int compareTo(RabinPair o) {
            return Comparator.comparingInt(x -> x.finIndex).thenComparingInt(x -> x.infIndex).compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RabinPair)) {
                return false;
            }
            RabinPair rabinPair = (RabinPair)o;
            return this.finIndex == rabinPair.finIndex && this.infIndex == rabinPair.infIndex;
        }

        public int hashCode() {
            return Objects.hash(this.finIndex, this.infIndex);
        }
    }
}

