/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimization;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;

public final class ParityAcceptanceOptimizations {
    private ParityAcceptanceOptimizations() {
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> setAcceptingSets(MutableAutomaton<S, ParityAcceptance> automaton) {
        int maximalAcceptance = automaton.states().stream().map(automaton::edges).flatMap(Collection::stream).flatMapToInt(sEdge -> sEdge.colours().last().stream()).max().orElse(-1);
        automaton.acceptance(((ParityAcceptance)automaton.acceptance()).withAcceptanceSets(maximalAcceptance + 1));
        return automaton;
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> minimizePriorities(MutableAutomaton<S, ParityAcceptance> automaton) {
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        List<Set<S>> sccs = SccDecomposition.of(automaton).sccs();
        int usedAcceptanceSets = 0;
        boolean max = ((ParityAcceptance)automaton.acceptance()).parity().max();
        for (Set scc : sccs) {
            HashMap<Integer, Integer> reductionMapping = new HashMap<Integer, Integer>();
            TreeSet usedPriorities = new TreeSet();
            for (S state2 : scc) {
                for (Edge<S> edge2 : automaton.edges(state2)) {
                    if (!scc.contains(edge2.successor())) continue;
                    if (max) {
                        edge2.colours().last().ifPresent(usedPriorities::add);
                        continue;
                    }
                    edge2.colours().first().ifPresent(usedPriorities::add);
                }
            }
            int currentTarget = usedPriorities.isEmpty() ? 0 : (Integer)usedPriorities.first() % 2;
            Iterator iterator = usedPriorities.iterator();
            while (iterator.hasNext()) {
                int currentPriority = (Integer)iterator.next();
                if (currentTarget % 2 != currentPriority % 2) {
                    ++currentTarget;
                }
                reductionMapping.put(currentPriority, currentTarget);
                usedAcceptanceSets = Math.max(usedAcceptanceSets, currentTarget + 1);
            }
            automaton.updateEdges(scc, (state, edge) -> scc.contains(edge.successor()) && !edge.colours().isEmpty() ? edge.withAcceptance(reductionMapping.getOrDefault(edge.colours().first().orElseThrow(), -1)) : edge.withoutAcceptance());
            automaton.trim();
        }
        automaton.acceptance(acceptance.withAcceptanceSets(usedAcceptanceSets));
        return automaton;
    }
}

