/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.SuccessorFunction;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.algorithm.AutoValue_SccDecomposition;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.algorithm.Tarjan;
import owl.automaton.edge.Edge;
import owl.collections.ImmutableBitSet;

@AutoValue
public abstract class SccDecomposition<S> {
    protected abstract Set<S> initialStates();

    protected abstract SuccessorFunction<S> successorFunction();

    @Nullable
    protected abstract Automaton<S, ?> automaton();

    public static <S> SccDecomposition<S> of(Automaton<S, ?> automaton) {
        return new AutoValue_SccDecomposition<Object>(Set.copyOf(automaton.initialStates()), automaton::successors, automaton);
    }

    public static <S> SccDecomposition<S> of(Set<? extends S> initialStates, SuccessorFunction<S> successorFunction) {
        return new AutoValue_SccDecomposition<S>(Set.copyOf(initialStates), successorFunction, null);
    }

    public boolean anyMatch(Predicate<? super Set<S>> predicate) {
        Tarjan<S> tarjan = new Tarjan<S>(this.successorFunction(), predicate);
        return this.initialStates().stream().anyMatch(tarjan::run);
    }

    public boolean allMatch(Predicate<? super Set<S>> predicate) {
        return !this.anyMatch(predicate.negate());
    }

    @Memoized
    public List<Set<S>> sccs() {
        SuccessorFunction successorFunction = this.successorFunction();
        ArrayDeque topologicalSortedSccs = new ArrayDeque();
        ArrayList<Set> localTopologicalSortedSccs = new ArrayList<Set>();
        HashSet seenStates = new HashSet();
        AtomicBoolean insertBefore = new AtomicBoolean(false);
        Tarjan<Object> tarjan = new Tarjan<Object>(x -> {
            Object successors = successorFunction.apply(x);
            if (!seenStates.isEmpty() && !Collections.disjoint(seenStates, successors)) {
                insertBefore.set(true);
            }
            return successorFunction.apply(x);
        }, x -> {
            localTopologicalSortedSccs.add(Set.copyOf(x));
            return false;
        });
        for (S initialState : this.initialStates()) {
            localTopologicalSortedSccs.forEach(seenStates::addAll);
            localTopologicalSortedSccs.clear();
            tarjan.run(initialState);
            if (insertBefore.get()) {
                localTopologicalSortedSccs.forEach(topologicalSortedSccs::addFirst);
                insertBefore.set(false);
                continue;
            }
            topologicalSortedSccs.addAll(Lists.reverse(localTopologicalSortedSccs));
        }
        return List.copyOf(topologicalSortedSccs);
    }

    @Memoized
    public List<Set<S>> sccsWithoutTransient() {
        List<Set<S>> sccs = this.sccs();
        ArrayList<Set<S>> nonTransientSccs = new ArrayList<Set<S>>(sccs.size());
        for (Set<S> scc : sccs) {
            if (this.isTransientScc(scc)) continue;
            nonTransientSccs.add(scc);
        }
        return List.copyOf(nonTransientSccs);
    }

    public int index(S state) {
        return this.indexMap().getOrDefault(state, -1);
    }

    public Set<S> scc(S state) {
        int index = this.indexMap().get(state);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        return this.sccs().get(index);
    }

    @Memoized
    public Map<S, Integer> indexMap() {
        HashMap<S, Integer> indexMap = new HashMap<S, Integer>();
        List<Set<S>> sccs = this.sccs();
        int s = sccs.size();
        for (int i = 0; i < s; ++i) {
            Integer iObject = i;
            for (S state : sccs.get(i)) {
                indexMap.put(state, iObject);
            }
        }
        return Map.copyOf(indexMap);
    }

    @Memoized
    public ImmutableGraph<Integer> condensation() {
        ImmutableGraph.Builder builder = GraphBuilder.directed().allowsSelfLoops(true).immutable();
        int i = 0;
        for (Set<S> scc : this.sccs()) {
            builder.addNode((Object)i);
            for (S state : scc) {
                Iterator iterator = this.successorFunction().apply((Object)state).iterator();
                while (iterator.hasNext()) {
                    Object successor = iterator.next();
                    builder.putEdge((Object)i, (Object)this.index(successor));
                }
            }
            ++i;
        }
        return builder.build();
    }

    @Memoized
    public ImmutableBitSet bottomSccs() {
        ImmutableGraph<Integer> graph = this.condensation();
        BitSet bottomSccs = new BitSet();
        for (Integer scc : graph.nodes()) {
            if (!Set.of(scc).containsAll(graph.successors((Object)scc))) continue;
            bottomSccs.set(scc);
        }
        return ImmutableBitSet.copyOf(bottomSccs);
    }

    public boolean isBottomScc(Set<S> scc) {
        int index = this.sccs().indexOf(scc);
        return Set.of(Integer.valueOf(index)).containsAll(this.condensation().successors((Object)index));
    }

    @Memoized
    public ImmutableBitSet transientSccs() {
        ImmutableGraph<Integer> graph = this.condensation();
        BitSet transientSccs = new BitSet();
        for (Integer scc : graph.nodes()) {
            if (graph.hasEdgeConnecting((Object)scc, (Object)scc)) continue;
            transientSccs.set(scc);
        }
        return ImmutableBitSet.copyOf(transientSccs);
    }

    public boolean isTransientScc(Set<? extends S> scc) {
        if (scc.size() > 1) {
            return false;
        }
        int index = this.index(Iterables.getOnlyElement(scc));
        return !this.condensation().hasEdgeConnecting((Object)index, (Object)index);
    }

    public boolean pathExists(S source, S target) {
        int sourceIndex = this.index(source);
        int targetIndex = this.index(target);
        if (sourceIndex < 0 || targetIndex < 0 || targetIndex < sourceIndex) {
            return false;
        }
        if (sourceIndex == targetIndex) {
            return !this.transientSccs().contains(sourceIndex);
        }
        return Graphs.reachableNodes(this.condensation(), (Object)sourceIndex).contains(targetIndex);
    }

    private String sccToString(int i) {
        return this.sccs().get(i).toString() + ":" + (this.transientSccs().contains(i) ? "T" : "") + (this.bottomSccs().contains(i) ? "B" : "") + (this.deterministicSccs().contains(i) ? "D" : "") + (this.rejectingSccs().contains(i) ? "R" : "") + (this.acceptingSccs().contains(i) ? "A" : "");
    }

    public String toString() {
        return IntStream.range(0, this.sccs().size()).mapToObj(this::sccToString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Memoized
    public ImmutableBitSet deterministicSccs() {
        Preconditions.checkState((this.automaton() != null ? 1 : 0) != 0, (Object)"This decomposition only has access to a graph and not an automaton.");
        BitSet deterministicSccs = new BitSet();
        int s = this.sccs().size();
        for (int i = 0; i < s; ++i) {
            Set<S> scc = this.sccs().get(i);
            Views.Filter<Object> sccFilter = Views.Filter.of(scc, scc::contains);
            if (!Views.filtered(this.automaton(), sccFilter).is(Automaton.Property.SEMI_DETERMINISTIC)) continue;
            deterministicSccs.set(i);
        }
        return ImmutableBitSet.copyOf(deterministicSccs);
    }

    @Memoized
    public ImmutableBitSet acceptingSccs() {
        Preconditions.checkState((this.automaton() != null ? 1 : 0) != 0, (Object)"This decomposition only has access to a graph and not an automaton.");
        BitSet acceptingSccs = new BitSet();
        Preconditions.checkState((boolean)(this.automaton().acceptance() instanceof BuchiAcceptance));
        int s = this.sccs().size();
        for (int i = 0; i < s; ++i) {
            if (this.transientSccs().contains(i) || this.rejectingSccs().contains(i)) continue;
            Set<S> scc = this.sccs().get(i);
            Views.Filter<Object> justRej = Views.Filter.builder().initialStates(scc).stateFilter(scc::contains).edgeFilter((state, e) -> !((EmersonLeiAcceptance)this.automaton().acceptance()).isAcceptingEdge((Edge<?>)e)).build();
            Automaton<Object, ?> rejSubAut = Views.filtered(this.automaton(), justRej);
            SccDecomposition<Object> sccScci = SccDecomposition.of(rejSubAut);
            boolean noRejLoops = sccScci.sccs().stream().allMatch(sccScci::isTransientScc);
            if (!noRejLoops || this.transientSccs().contains(i)) continue;
            acceptingSccs.set(i);
        }
        return ImmutableBitSet.copyOf(acceptingSccs);
    }

    @Memoized
    public ImmutableBitSet rejectingSccs() {
        Preconditions.checkState((this.automaton() != null ? 1 : 0) != 0, (Object)"This decomposition only has access to a graph and not an automaton.");
        BitSet rejectingSccs = new BitSet();
        int s = this.sccs().size();
        for (int i = 0; i < s; ++i) {
            Set<S> scc = this.sccs().get(i);
            Views.Filter<Object> sccFilter = Views.Filter.of(Set.of(scc.iterator().next()), scc::contains);
            if (!LanguageEmptiness.isEmpty(Views.filtered(this.automaton(), sccFilter))) continue;
            rejectingSccs.set(i);
        }
        return ImmutableBitSet.copyOf(rejectingSccs);
    }
}

