/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.Pair;

public class BackwardDirectSimulation<S>
implements SimulationType<S, SimulationStates.MultipebbleSimulationState<S>> {
    final Automaton<S, ? extends BuchiAcceptance> leftAutomaton;
    final Automaton<S, ? extends BuchiAcceptance> rightAutomaton;
    final S leftState;
    final S rightState;
    final SimulationStates.MultipebbleSimulationState<S> initialState;
    final SimulationStates.MultipebbleSimulationState<S> sinkState;
    final int pebbleCount;
    final Set<Pair<S, S>> knownPairs;

    public BackwardDirectSimulation(Automaton<S, ? extends BuchiAcceptance> leftAutomaton, Automaton<S, ? extends BuchiAcceptance> rightAutomaton, S left, S right, int pebbleCount, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.pebbleCount = pebbleCount;
        this.knownPairs = known;
        this.initialState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, false), MultiPebble.of(right, false, pebbleCount));
        this.sinkState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, true), MultiPebble.of(List.of(), pebbleCount));
    }

    @Override
    public Set<Edge<SimulationStates.MultipebbleSimulationState<S>>> edges(SimulationStates.MultipebbleSimulationState<S> state) {
        if (state.equals(this.sinkState)) {
            return Set.of(Edge.of(this.sinkState, 1));
        }
        HashSet out = new HashSet();
        if (state.owner().isOdd()) {
            if (state.even().isSingleton() && this.knownPairs.contains(Pair.of(state.odd().state(), state.even().onlyState()))) {
                return Set.of(Edge.of(state, 0));
            }
            boolean containsInitial = state.even().pebbles().stream().anyMatch(p -> this.rightAutomaton.initialStates().contains(p.state()));
            if (!containsInitial && this.leftAutomaton.initialStates().contains(state.odd().state()) || !state.even().flag() && state.odd().flag()) {
                return Set.of(Edge.of(this.sinkState, 1));
            }
            Set<S> predecessors = this.leftAutomaton.predecessors(state.odd().state());
            if (predecessors.isEmpty()) {
                return Set.of(Edge.of(state, 0));
            }
            predecessors.forEach(pred -> this.leftAutomaton.edgeMap(pred).forEach((e, vS) -> {
                if (e.successor().equals(state.odd().state())) {
                    vS.iterator(this.leftAutomaton.atomicPropositions().size()).forEachRemaining(val -> state.odd().predecessors((Automaton<S, BuchiAcceptance>)this.leftAutomaton, (BitSet)val).forEach(p -> {
                        SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(p, state.even().setFlag(false), val);
                        out.add(Edge.of(target, 0));
                    }));
                }
            }));
        } else {
            Set<MultiPebble<S>> possibilities = state.even().predecessors(this.leftAutomaton, BitSet2.fromInt(state.valuation()));
            if (possibilities.isEmpty()) {
                return Set.of(Edge.of(this.sinkState, 1));
            }
            possibilities.forEach(p -> {
                if (!state.odd().flag() || p.flag()) {
                    SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(state.odd(), p);
                    out.add(Edge.of(target, 0));
                } else {
                    out.add(Edge.of(this.sinkState, 1));
                }
            });
        }
        return out;
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(2, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }
}

