/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.Pair;

public class ForwardDirectSimulation<S>
implements SimulationType<S, SimulationStates.MultipebbleSimulationState<S>> {
    final Automaton<S, ? extends BuchiAcceptance> leftAutomaton;
    final Automaton<S, ? extends BuchiAcceptance> rightAutomaton;
    final S leftState;
    final S rightState;
    final SimulationStates.MultipebbleSimulationState<S> initialState;
    final SimulationStates.MultipebbleSimulationState<S> sinkState;
    final int pebbleCount;
    final Set<Pair<S, S>> knownPairs;

    public ForwardDirectSimulation(Automaton<S, ? extends BuchiAcceptance> leftAutomaton, Automaton<S, ? extends BuchiAcceptance> rightAutomaton, S left, S right, int pebbleCount, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.pebbleCount = pebbleCount;
        this.knownPairs = Set.copyOf(known);
        this.initialState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, false), MultiPebble.of(List.of(Pebble.of(right, false)), pebbleCount));
        this.sinkState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, true), MultiPebble.of(List.of(), pebbleCount));
    }

    @Override
    public Set<Edge<SimulationStates.MultipebbleSimulationState<S>>> edges(SimulationStates.MultipebbleSimulationState<S> state) {
        if (state.equals(this.sinkState)) {
            return Set.of(Edge.of(this.sinkState, 1));
        }
        HashSet<Edge<SimulationStates.MultipebbleSimulationState<S>>> out = new HashSet<Edge<SimulationStates.MultipebbleSimulationState<S>>>();
        if (state.owner().isOdd()) {
            if (1 == state.even().count() && this.knownPairs.contains(Pair.of(state.odd().state(), state.even().onlyState()))) {
                return Set.of(Edge.of(state, 0));
            }
            if (!state.even().flag() && state.odd().flag()) {
                return Set.of(Edge.of(this.sinkState, 1));
            }
            this.leftAutomaton.edgeMap(state.odd().state()).forEach((edge, valSet) -> valSet.iterator(this.leftAutomaton.atomicPropositions().size()).forEachRemaining(valuation -> {
                SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(Pebble.of(edge.successor(), this.leftAutomaton.acceptance().isAcceptingEdge((Edge<?>)edge)), state.even().setFlag(false), valuation);
                out.add(Edge.of(target, 0));
            }));
        } else {
            if (state.valuation() < 0) {
                throw new AssertionError((Object)"Valuation should not be negative here.");
            }
            Set<MultiPebble<S>> possibilities = state.even().successors(this.rightAutomaton, BitSet2.fromInt(state.valuation()));
            if (possibilities.isEmpty()) {
                return Set.of(Edge.of(this.sinkState, 1));
            }
            possibilities.forEach(p -> {
                HashSet ensureSucc = new HashSet();
                state.even().pebbles().forEach(ps -> ensureSucc.addAll(this.rightAutomaton.successors(ps.state())));
                p.pebbles().forEach(peb -> {
                    if (!ensureSucc.contains(peb.state())) {
                        throw new AssertionError((Object)"successor calculation broken");
                    }
                });
                if (!state.odd().flag() || p.flag()) {
                    SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(state.odd(), p);
                    out.add(Edge.of(target, 0));
                } else {
                    out.add(Edge.of(this.sinkState, 1));
                }
            });
        }
        return out;
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(2, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }
}

