/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.determinization;

import com.google.auto.value.AutoValue;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.determinization.AutoValue_Determinization_BreakpointState;
import owl.automaton.edge.Edge;

public class Determinization {
    private Determinization() {
    }

    public static <S> Automaton<Set<S>, AllAcceptance> determinizeAllAcceptance(final Automaton<S, ? extends AllAcceptance> automaton) {
        return new AbstractMemoizingAutomaton.EdgeImplementation<Set<S>, AllAcceptance>(automaton.atomicPropositions(), automaton.factory(), Set.of(automaton.initialStates()), AllAcceptance.INSTANCE){

            @Override
            public Edge<Set<S>> edgeImpl(Set<S> state, BitSet valuation) {
                Set successors = state.stream().flatMap(x -> automaton.successors(x, valuation).stream()).collect(Collectors.toUnmodifiableSet());
                return successors.isEmpty() ? null : Edge.of(successors);
            }
        };
    }

    public static <S> Automaton<BreakpointState<S>, CoBuchiAcceptance> determinizeCoBuchiAcceptance(final Automaton<S, ? extends CoBuchiAcceptance> ncw) {
        return new AbstractMemoizingAutomaton.EdgeImplementation<BreakpointState<S>, CoBuchiAcceptance>(ncw.atomicPropositions(), ncw.factory(), Set.of(BreakpointState.of(ncw.initialStates(), ncw.initialStates())), CoBuchiAcceptance.INSTANCE){

            @Override
            public Edge<BreakpointState<S>> edgeImpl(BreakpointState<S> breakpointState, BitSet valuation) {
                HashSet successors = new HashSet();
                HashSet rejectingSuccessors = new HashSet();
                for (Object state : breakpointState.states()) {
                    for (Edge edge : ncw.edges(state, valuation)) {
                        successors.add(edge.successor());
                    }
                }
                for (Object rejectingState : breakpointState.rejecting()) {
                    for (Edge edge : ncw.edges(rejectingState, valuation)) {
                        if (edge.colours().contains(0)) continue;
                        rejectingSuccessors.add(edge.successor());
                    }
                }
                if (successors.isEmpty()) {
                    return null;
                }
                if (rejectingSuccessors.isEmpty()) {
                    return Edge.of(BreakpointState.of(successors, successors), 0);
                }
                return Edge.of(BreakpointState.of(successors, rejectingSuccessors));
            }
        };
    }

    @AutoValue
    public static abstract class BreakpointState<S> {
        public abstract Set<S> states();

        public abstract Set<S> rejecting();

        public static <S> BreakpointState<S> of(Set<S> states, Set<S> rejecting) {
            return new AutoValue_Determinization_BreakpointState<S>(Set.copyOf(states), Set.copyOf(rejecting));
        }
    }
}

