/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import com.google.auto.value.AutoValue;
import java.util.BitSet;
import java.util.Collection;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnegative;
import owl.automaton.edge.AutoValue_Edge;
import owl.collections.ImmutableBitSet;

@AutoValue
public abstract class Edge<S> {
    public abstract S successor();

    public abstract ImmutableBitSet colours();

    public static <S> Edge<S> of(S successor) {
        return Edge.of(successor, ImmutableBitSet.of());
    }

    public static <S> Edge<S> of(S successor, @Nonnegative int acceptance) {
        return Edge.of(successor, ImmutableBitSet.of(acceptance));
    }

    public static <S> Edge<S> of(S successor, BitSet acceptance) {
        if (acceptance.isEmpty()) {
            return Edge.of(successor);
        }
        if (acceptance.cardinality() == 1) {
            return Edge.of(successor, acceptance.nextSetBit(0));
        }
        return Edge.of(successor, ImmutableBitSet.copyOf(acceptance));
    }

    public static <S> Edge<S> of(S successor, Collection<Integer> acceptance) {
        return Edge.of(successor, ImmutableBitSet.copyOf(acceptance));
    }

    public static <S> Edge<S> of(S successor, ImmutableBitSet acceptance) {
        return new AutoValue_Edge<S>(successor, acceptance);
    }

    public Edge<S> withAcceptance(int i) {
        return Edge.of(this.successor(), i);
    }

    public Edge<S> withAcceptance(BitSet acceptance) {
        return Edge.of(this.successor(), acceptance);
    }

    public Edge<S> withAcceptance(ImmutableBitSet acceptance) {
        return Edge.of(this.successor(), acceptance);
    }

    public Edge<S> mapAcceptance(IntUnaryOperator transformer) {
        PrimitiveIterator.OfInt iter = this.colours().intIterator();
        int first = -1;
        while (first < 0 && iter.hasNext()) {
            first = transformer.applyAsInt(iter.next());
        }
        if (!iter.hasNext()) {
            return first < 0 ? this.withoutAcceptance() : this.withAcceptance(first);
        }
        BitSet acceptanceSet = new BitSet();
        acceptanceSet.set(first);
        iter.forEachRemaining(x -> {
            int e = transformer.applyAsInt(x);
            if (0 <= e) {
                acceptanceSet.set(e);
            }
        });
        return this.withAcceptance(acceptanceSet);
    }

    public Edge<S> withoutAcceptance() {
        return this.colours().isEmpty() ? this : Edge.of(this.successor());
    }

    public <T> Edge<T> withSuccessor(T successor) {
        return Edge.of(successor, this.colours());
    }

    public <T> Edge<T> mapSuccessor(Function<? super S, ? extends T> mapper) {
        return Edge.of(mapper.apply(this.successor()), this.colours());
    }

    public String toString() {
        return "-> " + this.successor() + " " + this.colours();
    }
}

