/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.hoa;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerPrint;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.util.OwlVersion;

public final class HoaWriter {
    private HoaWriter() {
    }

    public static <S> String toString(Automaton<S, ?> automaton) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            HoaWriter.write(automaton, (HOAConsumer)new HOAConsumerPrint((OutputStream)buffer), true);
        }
        catch (HOAConsumerException ex) {
            throw new UncheckedHoaConsumerException(ex);
        }
        return buffer.toString(StandardCharsets.UTF_8);
    }

    public static <S> void write(Automaton<S, ?> automaton, HOAConsumer consumer, boolean stateLabels) throws HOAConsumerException {
        HoaWriter.write(automaton, consumer, stateLabels, null, null, null);
    }

    public static <S> void write(Automaton<S, ?> automaton, HOAConsumer consumer, boolean stateLabels, @Nullable String subcommand, @Nullable List<String> subcommandArgs, @Nullable String automatonName) throws HOAConsumerException {
        consumer.notifyHeaderStart("v1");
        OwlVersion.NameAndVersion nameAndVersion = OwlVersion.getNameAndVersion();
        consumer.setTool((String)(subcommand == null ? nameAndVersion.name() : nameAndVersion.name() + " " + subcommand), nameAndVersion.version());
        if (automatonName != null) {
            consumer.setName(automatonName.replace('\"', '\''));
        }
        if (subcommandArgs != null) {
            List<Object> owlArgsQuoted = Arrays.asList(subcommandArgs.toArray());
            owlArgsQuoted.replaceAll(x -> "\"" + x.toString().replace('\"', '\'') + "\"");
            consumer.addMiscHeader("owlArgs", owlArgsQuoted);
        }
        Numbering<Object> numbering = new Numbering<Object>();
        for (S state : automaton.initialStates()) {
            consumer.addStartStates(List.of(Integer.valueOf(numbering.get(state))));
        }
        Object acceptance = automaton.acceptance();
        if (((EmersonLeiAcceptance)acceptance).name() != null) {
            consumer.provideAcceptanceName(((EmersonLeiAcceptance)acceptance).name(), ((EmersonLeiAcceptance)acceptance).nameExtra());
        }
        consumer.setAcceptanceCondition(((EmersonLeiAcceptance)acceptance).acceptanceSets(), BooleanExpressions.fromPropositionalFormula(((EmersonLeiAcceptance)acceptance).booleanExpression()));
        consumer.addProperties(List.of("trans-acc", "no-univ-branch"));
        if (!automaton.initialStates().isEmpty() && automaton.is(Automaton.Property.DETERMINISTIC)) {
            consumer.addProperties(List.of("deterministic", "unambiguous"));
        }
        if (automaton.is(Automaton.Property.COMPLETE)) {
            consumer.addProperties(List.of("complete"));
        }
        consumer.setAPs(automaton.atomicPropositions());
        consumer.notifyBodyStart();
        ArrayDeque<S> workList = new ArrayDeque<S>(automaton.initialStates());
        HashSet<S> visited = new HashSet<S>(workList);
        while (!workList.isEmpty()) {
            Object state = workList.remove();
            int stateId = numbering.get(state);
            String label = stateLabels ? state.toString() : null;
            consumer.addState(stateId, label, null, null);
            for (Map.Entry<Edge<S>, BddSet> entry : automaton.edgeMap(state).entrySet()) {
                Edge<S> edge = entry.getKey();
                S successor = edge.successor();
                BddSet valuationSet = entry.getValue();
                if (valuationSet.isEmpty()) continue;
                if (visited.add(successor)) {
                    workList.add(successor);
                }
                consumer.addEdgeWithLabel(stateId, BooleanExpressions.fromPropositionalFormula(valuationSet.toExpression(), x -> new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)x))), List.of(Integer.valueOf(numbering.get(edge.successor()))), Arrays.asList((Integer[])edge.colours().toArray(Integer[]::new)));
            }
            consumer.notifyEndOfState(stateId);
        }
        consumer.notifyEnd();
    }

    public static class UncheckedHoaConsumerException
    extends RuntimeException {
        public UncheckedHoaConsumerException(HOAConsumerException cause) {
            super((Throwable)cause);
        }
    }

    static final class Numbering<S> {
        private final Map<S, Integer> stateNumbers = new HashMap<S, Integer>();

        Numbering() {
        }

        private int get(S state) {
            return this.stateNumbers.computeIfAbsent(Objects.requireNonNull(state), k -> this.stateNumbers.size());
        }
    }
}

