/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.symbolic.SequentialVariableAllocationCombiner;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.logic.propositional.PropositionalFormula;

public final class SymbolicBooleanOperations {
    private SymbolicBooleanOperations() {
    }

    public static SymbolicAutomaton<?> deterministicUnion(SymbolicAutomaton<?> ... automata) {
        return SymbolicBooleanOperations.deterministicUnion(List.of(automata));
    }

    public static SymbolicAutomaton<?> deterministicUnion(List<? extends SymbolicAutomaton<?>> automata) {
        return SymbolicBooleanOperations.deterministicProduct(PropositionalFormula.Disjunction.of(IntStream.range(0, automata.size()).mapToObj(PropositionalFormula.Variable::of).collect(Collectors.toList())), automata);
    }

    public static SymbolicAutomaton<?> intersection(SymbolicAutomaton<?> ... automata) {
        return SymbolicBooleanOperations.intersection(List.of(automata));
    }

    public static SymbolicAutomaton<?> intersection(List<? extends SymbolicAutomaton<?>> automata) {
        return SymbolicBooleanOperations.deterministicProduct(PropositionalFormula.Conjunction.of(IntStream.range(0, automata.size()).mapToObj(PropositionalFormula.Variable::of).collect(Collectors.toList())), automata);
    }

    public static SymbolicAutomaton<?> deterministicStructureProduct(SymbolicAutomaton<?> automaton1, SymbolicAutomaton<?> automaton2) {
        return SymbolicBooleanOperations.deterministicProduct(PropositionalFormula.Variable.of(0), List.of(automaton1, automaton2));
    }

    public static SymbolicAutomaton<?> deterministicProduct(PropositionalFormula<Integer> automatonFormula, List<? extends SymbolicAutomaton<?>> automata) {
        Preconditions.checkArgument((boolean)IntStream.range(0, automata.size()).boxed().collect(Collectors.toSet()).containsAll(automatonFormula.variables()));
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0);
        for (SymbolicAutomaton<?> symbolicAutomaton : automata) {
            Preconditions.checkArgument((boolean)symbolicAutomaton.is(Automaton.Property.COMPLETE));
            Preconditions.checkArgument((boolean)symbolicAutomaton.atomicPropositions().equals(automata.get(0).atomicPropositions()));
            Preconditions.checkArgument((boolean)symbolicAutomaton.factory().equals(automata.get(0).factory()));
        }
        SequentialVariableAllocationCombiner allocationCombiner = new SequentialVariableAllocationCombiner(automata.stream().map(SymbolicAutomaton::variableAllocation).collect(Collectors.toList()));
        BddSetFactory bddSetFactory = automata.get(0).factory();
        BddSet productInitialStates = bddSetFactory.of(true);
        BddSet productTransitionRelation = bddSetFactory.of(true);
        for (SymbolicAutomaton<?> automaton2 : automata) {
            productInitialStates = productInitialStates.intersection(automaton2.initialStates().relabel(i -> allocationCombiner.localToGlobal(i, automaton2.variableAllocation())));
            productTransitionRelation = productTransitionRelation.intersection(automaton2.transitionRelation().relabel(i -> allocationCombiner.localToGlobal(i, automaton2.variableAllocation())));
        }
        int[] colourOffsets = new int[automata.size()];
        int currentOffset = 0;
        for (int i2 = 0; i2 < automata.size(); ++i2) {
            colourOffsets[i2] = currentOffset;
            currentOffset += ((EmersonLeiAcceptance)automata.get(i2).acceptance()).acceptanceSets();
        }
        EmersonLeiAcceptance productAcceptance = EmersonLeiAcceptance.of(automatonFormula.substitute(automatonIndex -> ((EmersonLeiAcceptance)((SymbolicAutomaton)automata.get((int)automatonIndex)).acceptance()).booleanExpression().map(i -> colourOffsets[automatonIndex] + i)));
        EnumSet<Automaton.Property> properties = EnumSet.of(Automaton.Property.COMPLETE);
        if (automata.stream().allMatch(automaton -> automaton.is(Automaton.Property.DETERMINISTIC))) {
            properties.add(Automaton.Property.DETERMINISTIC);
        }
        return SymbolicAutomaton.of(automata.get(0).atomicPropositions(), productInitialStates, productTransitionRelation, productAcceptance, allocationCombiner, properties);
    }
}

