/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd.jbdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.tum.in.jbdd.Bdd;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.MtBdd;
import owl.bdd.jbdd.JBddGcManagedFactory;
import owl.bdd.jbdd.JBddSupplier;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.visitors.PrintVisitor;
import owl.ltl.visitors.PropositionalIntVisitor;

final class JBddEquivalenceClassFactory
extends JBddGcManagedFactory<JBddEquivalenceClass>
implements EquivalenceClassFactory {
    private static final List<int[]> LIST_OF_EMPTY = List.of(new int[0]);
    private final List<String> atomicPropositions;
    private final JBddVisitor visitor;
    private final int atomicPropositionsVariables;
    private Formula.TemporalOperator[] temporalOperatorReverseMapping;
    private final Map<Formula.TemporalOperator, Integer> temporalOperatorMapping;
    private final int trueNode;
    private final int falseNode;
    private final EquivalenceClass trueClass;
    private final EquivalenceClass falseClass;
    private final EquivalenceClassFactory.Encoding encoding;
    @Nullable
    private final JBddEquivalenceClassFactory reencodingFactory;
    private final List<EquivalenceClass> protectFromGc = new ArrayList<EquivalenceClass>();
    private final Map<Formula, JBddEquivalenceClass> lookupCache = new HashMap<Formula, JBddEquivalenceClass>();

    JBddEquivalenceClassFactory(Bdd bdd, List<String> atomicPropositions, EquivalenceClassFactory.Encoding encoding) {
        super(bdd);
        this.atomicPropositions = List.copyOf(atomicPropositions);
        this.temporalOperatorMapping = new HashMap<Formula.TemporalOperator, Integer>();
        this.temporalOperatorReverseMapping = new Formula.TemporalOperator[32];
        this.visitor = new JBddVisitor();
        this.encoding = encoding;
        this.atomicPropositionsVariables = 2 * this.atomicPropositions.size();
        this.bdd.createVariables(this.atomicPropositionsVariables);
        if (this.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE) {
            this.reencodingFactory = new JBddEquivalenceClassFactory(JBddSupplier.create(32000), atomicPropositions, EquivalenceClassFactory.Encoding.AP_COMBINED);
        } else {
            assert (this.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED);
            this.reencodingFactory = null;
        }
        this.trueNode = this.bdd.trueNode();
        this.falseNode = this.bdd.falseNode();
        this.trueClass = this.of((Formula)BooleanConstant.TRUE, this.trueNode);
        this.falseClass = this.of((Formula)BooleanConstant.FALSE, this.falseNode);
    }

    @Override
    public EquivalenceClassFactory.Encoding defaultEncoding() {
        return this.encoding;
    }

    @Override
    public void clearCaches() {
        this.protectFromGc.clear();
        this.lookupCache.clear();
    }

    @Override
    public EquivalenceClassFactory withDefaultEncoding(EquivalenceClassFactory.Encoding encoding) {
        if (encoding == this.encoding) {
            return this;
        }
        if (encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE) {
            assert (this.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED);
            throw new IllegalArgumentException("Cannot switch into a coarser encoding.");
        }
        assert (encoding == EquivalenceClassFactory.Encoding.AP_COMBINED);
        assert (this.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
        return Objects.requireNonNull(this.reencodingFactory);
    }

    @Override
    public List<String> atomicPropositions() {
        return this.atomicPropositions;
    }

    @Override
    public EquivalenceClass of(boolean value) {
        return value ? this.trueClass : this.falseClass;
    }

    @Override
    public EquivalenceClass of(Formula formula) {
        return this.of(formula, true);
    }

    private JBddEquivalenceClass of(Formula formula, boolean scanForUnknown) {
        TreeSet newPropositions;
        JBddEquivalenceClass clazz = this.lookupCache.get(formula);
        if (clazz != null) {
            return clazz;
        }
        if (scanForUnknown && !(newPropositions = formula.subformulas(Formula.TemporalOperator.class).stream().filter(y -> !this.temporalOperatorMapping.containsKey(y)).collect(Collectors.toCollection(TreeSet::new))).isEmpty()) {
            int newSize = this.temporalOperatorMapping.size() + newPropositions.size();
            if (this.temporalOperatorReverseMapping.length < newSize) {
                this.temporalOperatorReverseMapping = Arrays.copyOf(this.temporalOperatorReverseMapping, newSize);
            }
            for (Formula.TemporalOperator proposition : newPropositions) {
                int variable = this.bdd.variable(this.bdd.createVariable());
                this.temporalOperatorMapping.put(proposition, variable);
                this.temporalOperatorReverseMapping[variable - this.atomicPropositionsVariables] = proposition;
            }
        }
        return this.of(formula, this.bdd.dereference(formula.accept(this.visitor)));
    }

    private JBddEquivalenceClass of(@Nullable Formula representative, int node) {
        JBddEquivalenceClass clazz = this.canonicalize(new JBddEquivalenceClass(this, node, representative));
        if (representative != null) {
            this.lookupCache.put(representative, clazz);
            if (clazz.representative == null) {
                clazz.representative = representative;
            }
        } else if (clazz.representative == null) {
            this.protectFromGc.add(clazz);
        }
        return clazz;
    }

    @Override
    public EquivalenceClass and(Collection<? extends EquivalenceClass> classes) {
        HashSet<Formula> representatives = new HashSet<Formula>();
        int andNode = this.trueNode;
        for (EquivalenceClass equivalenceClass : classes) {
            JBddEquivalenceClass castedClass = this.cast(equivalenceClass);
            if (castedClass.representative == null) {
                representatives = null;
            } else if (representatives != null) {
                representatives.add(castedClass.representative);
            }
            if ((andNode = this.bdd.updateWith(this.bdd.and(andNode, castedClass.node), andNode)) != this.falseNode) continue;
            return this.falseClass;
        }
        return this.of(representatives == null ? null : Conjunction.of(representatives), this.bdd.dereference(andNode));
    }

    @Override
    public EquivalenceClass or(Collection<? extends EquivalenceClass> classes) {
        HashSet<Formula> representatives = new HashSet<Formula>();
        int orNode = this.falseNode;
        for (EquivalenceClass equivalenceClass : classes) {
            JBddEquivalenceClass castedClass = this.cast(equivalenceClass);
            if (castedClass.representative == null) {
                representatives = null;
            } else if (representatives != null) {
                representatives.add(castedClass.representative);
            }
            if ((orNode = this.bdd.updateWith(this.bdd.or(orNode, castedClass.node), orNode)) != this.trueNode) continue;
            return this.trueClass;
        }
        return this.of(representatives == null ? null : Disjunction.of(representatives), this.bdd.dereference(orNode));
    }

    private JBddEquivalenceClass cast(EquivalenceClass clazz) {
        if (!this.equals(clazz.factory())) {
            throw new IllegalArgumentException("Incompatible factory.");
        }
        return (JBddEquivalenceClass)clazz;
    }

    private List<int[]> zeroPaths(int node) {
        if (node == this.trueNode) {
            return List.of();
        }
        if (node == this.falseNode) {
            return LIST_OF_EMPTY;
        }
        JBddEquivalenceClass wrapper = this.of(null, node);
        if (wrapper.zeroPathsCache != null) {
            return wrapper.zeroPathsCache;
        }
        int variable = this.bdd.variable(node);
        int highNode = this.bdd.high(node);
        int lowNode = this.bdd.low(node);
        List<int[]> highZeroPaths = this.zeroPaths(highNode);
        ArrayList<int[]> lowZeroPaths = new ArrayList<int[]>(this.zeroPaths(lowNode));
        boolean highImpliesLow = this.bdd.implies(highNode, lowNode);
        boolean lowImpliesHigh = this.bdd.implies(lowNode, highNode);
        if (!highImpliesLow) {
            lowZeroPaths.replaceAll(zeroPath -> {
                int[] extendedZeroPath = Arrays.copyOf(zeroPath, ((int[])zeroPath).length + 1);
                extendedZeroPath[zeroPath.length] = -(variable + 1);
                Arrays.sort(extendedZeroPath);
                return extendedZeroPath;
            });
        }
        if (this.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED && variable < this.atomicPropositionsVariables) {
            assert (!highImpliesLow || !lowImpliesHigh);
            if (lowImpliesHigh) {
                lowZeroPaths.addAll(highZeroPaths);
            } else {
                highZeroPaths.forEach(zeroPath -> {
                    int[] extendedZeroPath = Arrays.copyOf(zeroPath, ((int[])zeroPath).length + 1);
                    extendedZeroPath[zeroPath.length] = variable;
                    Arrays.sort(extendedZeroPath);
                    lowZeroPaths.add(extendedZeroPath);
                });
            }
        } else {
            assert (lowImpliesHigh);
            lowZeroPaths.addAll(highZeroPaths);
        }
        List<int[]> zeroPaths = JBddEquivalenceClassFactory.maximalElements((int[][])lowZeroPaths.toArray(x$0 -> new int[x$0][]));
        if (wrapper.zeroPathsCache == null) {
            wrapper.zeroPathsCache = zeroPaths;
        }
        return zeroPaths;
    }

    private static List<int[]> maximalElements(int[][] paths) {
        int removedElements = 0;
        for (int i = 0; i < paths.length; ++i) {
            int[] ei = paths[i];
            if (ei == null) continue;
            for (int j = 0; j < paths.length; ++j) {
                int[] ej;
                if (i == j || (ej = paths[j]) == null || !JBddEquivalenceClassFactory.containsAll(ej, ei)) continue;
                paths[j] = null;
                ++removedElements;
            }
        }
        ArrayList<int[]> prunedPaths = new ArrayList<int[]>(paths.length - removedElements);
        for (int[] path : paths) {
            if (path == null) continue;
            prunedPaths.add(path);
        }
        prunedPaths.sort(Comparator.comparingInt(x -> ((int[])x).length));
        return List.copyOf(prunedPaths);
    }

    private List<int[]> onePaths(int node) {
        if (node == this.trueNode) {
            return LIST_OF_EMPTY;
        }
        if (node == this.falseNode) {
            return List.of();
        }
        JBddEquivalenceClass wrapper = this.of(null, node);
        if (wrapper.onePathsCache != null) {
            return wrapper.onePathsCache;
        }
        int variable = this.bdd.variable(node);
        int highNode = this.bdd.high(node);
        int lowNode = this.bdd.low(node);
        ArrayList<int[]> highOnePaths = new ArrayList<int[]>(this.onePaths(highNode));
        List<int[]> lowOnePaths = this.onePaths(lowNode);
        boolean highImpliesLow = this.bdd.implies(highNode, lowNode);
        boolean lowImpliesHigh = this.bdd.implies(lowNode, highNode);
        if (!highImpliesLow) {
            highOnePaths.replaceAll(onePath -> {
                int[] extendedOnePath = Arrays.copyOf(onePath, ((int[])onePath).length + 1);
                extendedOnePath[onePath.length] = variable;
                Arrays.sort(extendedOnePath);
                return extendedOnePath;
            });
        }
        if (this.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED && variable < this.atomicPropositionsVariables) {
            assert (!highImpliesLow || !lowImpliesHigh);
            if (lowImpliesHigh) {
                highOnePaths.addAll(lowOnePaths);
            } else {
                lowOnePaths.forEach(onePath -> {
                    int[] extendedOnePath = Arrays.copyOf(onePath, ((int[])onePath).length + 1);
                    extendedOnePath[onePath.length] = -(variable + 1);
                    Arrays.sort(extendedOnePath);
                    highOnePaths.add(extendedOnePath);
                });
            }
        } else {
            assert (lowImpliesHigh);
            highOnePaths.addAll(lowOnePaths);
        }
        List<int[]> onePaths = JBddEquivalenceClassFactory.maximalElements((int[][])highOnePaths.toArray(x$0 -> new int[x$0][]));
        if (wrapper.onePathsCache == null) {
            wrapper.onePathsCache = onePaths;
        }
        return onePaths;
    }

    private static boolean containsAll(int[] path, int[] otherPath) {
        if (path.length < otherPath.length) {
            return false;
        }
        if (path.length == otherPath.length) {
            return Arrays.equals(path, otherPath);
        }
        int j = 0;
        for (int i = 0; i < otherPath.length; ++i) {
            if (path.length - j < otherPath.length - i) {
                return false;
            }
            int value = Integer.MIN_VALUE;
            int otherValue = otherPath[i];
            while (value < otherValue && j < path.length) {
                value = path[j];
                ++j;
            }
            if (value == otherValue) continue;
            return false;
        }
        return true;
    }

    private static final class DistinctList<E>
    extends AbstractSet<E> {
        private final List<E> elements;

        private DistinctList(List<E> elements) {
            this.elements = List.copyOf(elements);
        }

        @Override
        public Iterator<E> iterator() {
            return this.elements.iterator();
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.elements.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.elements.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.elements.toArray(array);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.elements.toArray(generator);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.elements.forEach(action);
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this.elements, 1281);
        }
    }

    static final class JBddEquivalenceClass
    implements JBddGcManagedFactory.JBddNode,
    EquivalenceClass {
        private final JBddEquivalenceClassFactory factory;
        private final int node;
        @Nullable
        private Formula representative;
        @Nullable
        private MtBdd<EquivalenceClass> temporalStepTreeCache;
        @Nullable
        private JBddEquivalenceClass unfoldCache;
        @Nullable
        private JBddEquivalenceClass notCache;
        @Nullable
        private List<int[]> zeroPathsCache;
        @Nullable
        private List<int[]> onePathsCache;
        @Nullable
        private Set<Set<Formula>> cnfView;
        @Nullable
        private Set<Set<Formula>> dnfView;
        @Nullable
        private List<Formula> supportCache;
        @Nullable
        private List<Formula> supportCacheIncludeNested;
        @Nullable
        private EquivalenceClass encodeCache;
        private double truenessCache = Double.NaN;

        private JBddEquivalenceClass(JBddEquivalenceClassFactory factory, int node, @Nullable Formula internalRepresentative) {
            this.factory = factory;
            this.node = node;
            this.representative = internalRepresentative;
        }

        @Override
        public EquivalenceClassFactory.Encoding encoding() {
            return this.factory.encoding;
        }

        @Override
        public EquivalenceClass encode(EquivalenceClassFactory.Encoding encoding) {
            if (this.factory.encoding == encoding) {
                return this;
            }
            if (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED) {
                assert (encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
                throw new IllegalArgumentException("Cannot encode into a coarser encoding.");
            }
            assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
            assert (encoding == EquivalenceClassFactory.Encoding.AP_COMBINED);
            if (this.encodeCache == null) {
                this.encodeCache = this.factory.reencodingFactory.of(this.representative());
            }
            return Objects.requireNonNull(this.encodeCache);
        }

        @Override
        public Set<Set<Formula>> conjunctiveNormalForm() {
            if (this.cnfView == null) {
                if (this.zeroPathsCache == null) {
                    this.zeroPathsCache = List.copyOf(this.factory.zeroPaths(this.node));
                }
                ArrayList<DistinctList<Formula>> clauses = new ArrayList<DistinctList<Formula>>(this.zeroPathsCache.size());
                int atomicPropositionsVariables = this.factory.atomicPropositionsVariables;
                Formula.TemporalOperator[] reverseMapping = this.factory.temporalOperatorReverseMapping;
                for (int[] zeroPath : this.zeroPathsCache) {
                    Formula[] clause = new Formula[zeroPath.length];
                    for (int j = 0; j < zeroPath.length; ++j) {
                        int zeroPathVariable = zeroPath[j];
                        assert (zeroPathVariable < atomicPropositionsVariables) : "Node encodes non-negated TemporalOperator";
                        if (0 <= zeroPathVariable) {
                            assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED);
                            assert (zeroPathVariable % 2 == 0);
                            clause[j] = Literal.of(zeroPathVariable / 2, true);
                            continue;
                        }
                        int negatedVariable = -(zeroPathVariable + 1);
                        if (negatedVariable < atomicPropositionsVariables) {
                            if (negatedVariable % 2 == 0) {
                                clause[j] = Literal.of(negatedVariable / 2, false);
                                continue;
                            }
                            assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
                            clause[j] = Literal.of((negatedVariable - 1) / 2, true);
                            continue;
                        }
                        clause[j] = reverseMapping[negatedVariable - atomicPropositionsVariables];
                    }
                    clauses.add(new DistinctList<Formula>(List.of(clause)));
                }
                this.cnfView = new DistinctList<Set<Formula>>(clauses);
            }
            return Objects.requireNonNull(this.cnfView);
        }

        @Override
        public Set<Set<Formula>> disjunctiveNormalForm() {
            if (this.dnfView == null) {
                if (this.onePathsCache == null) {
                    this.onePathsCache = List.copyOf(this.factory.onePaths(this.node));
                }
                ArrayList<DistinctList<Formula>> clauses = new ArrayList<DistinctList<Formula>>(this.onePathsCache.size());
                int atomicPropositionsVariables = this.factory.atomicPropositionsVariables;
                Formula.TemporalOperator[] reverseMapping = this.factory.temporalOperatorReverseMapping;
                for (int[] onePath : this.onePathsCache) {
                    Formula[] clause = new Formula[onePath.length];
                    for (int j = 0; j < onePath.length; ++j) {
                        int onePathVariable = onePath[j];
                        assert (-(atomicPropositionsVariables + 1) <= onePathVariable) : "Node encodes negation of TemporalOperator";
                        if (onePathVariable < 0) {
                            assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED);
                            assert (-(onePathVariable + 1) % 2 == 0);
                            clause[j] = Literal.of(-(onePathVariable + 1) / 2, true);
                            continue;
                        }
                        if (onePathVariable < atomicPropositionsVariables) {
                            if (onePathVariable % 2 == 0) {
                                clause[j] = Literal.of(onePathVariable / 2, false);
                                continue;
                            }
                            assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
                            clause[j] = Literal.of((onePathVariable - 1) / 2, true);
                            continue;
                        }
                        clause[j] = reverseMapping[onePathVariable - atomicPropositionsVariables];
                    }
                    clauses.add(new DistinctList<Formula>(List.of(clause)));
                }
                this.dnfView = new DistinctList<Set<Formula>>(clauses);
            }
            return Objects.requireNonNull(this.dnfView);
        }

        private Formula representative() {
            return Objects.requireNonNull(this.representative);
        }

        @Override
        public int node() {
            return this.node;
        }

        public String toString() {
            return this.representative == null ? String.format("%d", this.node) : PrintVisitor.toString(LabelledFormula.of(this.representative, this.factory.atomicPropositions), false);
        }

        @Override
        public EquivalenceClassFactory factory() {
            return this.factory;
        }

        @Override
        public boolean isFalse() {
            return this.node == this.factory.falseNode;
        }

        @Override
        public boolean isTrue() {
            return this.node == this.factory.trueNode;
        }

        @Override
        public List<Formula> support(boolean includeNested) {
            if (this.supportCache == null || this.supportCacheIncludeNested == null) {
                this.initialiseSupportCaches();
            }
            return Objects.requireNonNull(includeNested ? this.supportCacheIncludeNested : this.supportCache);
        }

        private void initialiseSupportCaches() {
            int atomicPropositionsRegion = this.factory.atomicPropositionsVariables;
            BitSet supportBitSet = this.factory.bdd.support(this.node);
            Object[] support = new Formula[supportBitSet.cardinality()];
            int j = 0;
            int i = supportBitSet.nextSetBit(0);
            while (i >= 0) {
                if (i < atomicPropositionsRegion) {
                    assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE || i % 2 == 0);
                    support[j] = i % 2 == 0 ? Literal.of(i / 2, false) : Literal.of((i - 1) / 2, true);
                } else {
                    support[j] = this.factory.temporalOperatorReverseMapping[i - atomicPropositionsRegion];
                }
                ++j;
                if (i == Integer.MAX_VALUE) {
                    throw new IllegalStateException("Support is too large.");
                }
                i = supportBitSet.nextSetBit(i + 1);
            }
            Arrays.sort(support);
            assert (this.supportCache == null);
            this.supportCache = List.of(support);
            TreeSet<Formula> supportIncludeNested = new TreeSet<Formula>(Formula::compareTo);
            for (Object formula : support) {
                supportIncludeNested.addAll(((Formula)formula).subformulas(x -> x instanceof Literal || x instanceof Formula.TemporalOperator));
            }
            if (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED) {
                HashSet negatedLiterals = new HashSet();
                supportIncludeNested.removeIf(x -> {
                    if (x instanceof Literal && ((Literal)x).isNegated()) {
                        negatedLiterals.add((Literal)x);
                        return true;
                    }
                    return false;
                });
                for (Literal negatedLiteral : negatedLiterals) {
                    supportIncludeNested.add(Literal.of(negatedLiteral.getAtom()));
                }
            }
            assert (this.supportCacheIncludeNested == null);
            this.supportCacheIncludeNested = supportIncludeNested.size() == this.supportCache.size() ? this.supportCache : List.copyOf(supportIncludeNested);
        }

        @Override
        public boolean implies(EquivalenceClass other) {
            return this.factory.bdd.implies(this.node, this.factory.cast((EquivalenceClass)other).node);
        }

        @Override
        public EquivalenceClass and(EquivalenceClass other) {
            JBddEquivalenceClass otherCasted = this.factory.cast(other);
            return this.factory.of(Conjunction.of(this.representative(), otherCasted.representative()), this.factory.bdd.and(this.node, otherCasted.node));
        }

        @Override
        public EquivalenceClass or(EquivalenceClass other) {
            JBddEquivalenceClass otherCasted = this.factory.cast(other);
            return this.factory.of(Disjunction.of(this.representative(), otherCasted.representative()), this.factory.bdd.or(this.node, otherCasted.node));
        }

        @Override
        public EquivalenceClass substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
            Formula newRepresentative = this.representative().substitute(substitution);
            if (newRepresentative.equals(this.representative)) {
                return this;
            }
            return this.factory.of(newRepresentative, true);
        }

        @Override
        public MtBdd<EquivalenceClass> temporalStepTree() {
            if (this.temporalStepTreeCache == null) {
                this.temporalStepTree(this.representative(), new BitSet());
            }
            return Objects.requireNonNull(this.temporalStepTreeCache);
        }

        @Override
        public EquivalenceClass not() {
            if (this.notCache == null) {
                this.notCache = this.factory.cast(this.factory.of(this.representative().not()));
                assert (this.factory.cast((EquivalenceClass)this.notCache).notCache == null);
                this.notCache.notCache = this;
            }
            assert (this.notCache.notCache == this);
            return this.notCache;
        }

        private MtBdd<EquivalenceClass> temporalStepTree(Formula initialRepresentative, BitSet pathTrace) {
            int atom;
            if (this.temporalStepTreeCache != null) {
                return this.temporalStepTreeCache;
            }
            Bdd bdd = this.factory.bdd;
            int n = atom = bdd.isNodeRoot(this.node) ? this.factory.atomicPropositionsVariables : bdd.variable(this.node);
            if (atom >= this.factory.atomicPropositionsVariables) {
                this.temporalStepTreeCache = MtBdd.of(Set.of(this.factory.of(initialRepresentative.temporalStep(pathTrace), false)));
            } else {
                int falseSubTreeNode;
                int trueSubTreeNode;
                int atomicProposition;
                if (atom % 2 == 0) {
                    atomicProposition = atom / 2;
                    trueSubTreeNode = bdd.high(this.node);
                    if (!bdd.isNodeRoot(trueSubTreeNode) && bdd.variable(trueSubTreeNode) == atom + 1) {
                        trueSubTreeNode = bdd.low(trueSubTreeNode);
                    }
                    if (!bdd.isNodeRoot(falseSubTreeNode = bdd.low(this.node)) && bdd.variable(falseSubTreeNode) == atom + 1) {
                        falseSubTreeNode = bdd.high(falseSubTreeNode);
                    }
                } else {
                    assert (this.factory.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
                    atomicProposition = (atom - 1) / 2;
                    trueSubTreeNode = bdd.low(this.node);
                    falseSubTreeNode = bdd.high(this.node);
                }
                pathTrace.set(atomicProposition);
                MtBdd<EquivalenceClass> trueSubTree = this.factory.of(null, trueSubTreeNode).temporalStepTree(initialRepresentative, pathTrace);
                pathTrace.clear(atomicProposition, pathTrace.length());
                MtBdd<EquivalenceClass> falseSubTree = this.factory.of(null, falseSubTreeNode).temporalStepTree(initialRepresentative, pathTrace);
                this.temporalStepTreeCache = MtBdd.of(atomicProposition, trueSubTree, falseSubTree);
            }
            return Objects.requireNonNull(this.temporalStepTreeCache);
        }

        @Override
        public EquivalenceClass unfold() {
            if (this.unfoldCache == null) {
                this.unfoldCache = this.factory.of(this.representative().unfold(), false);
                if (this.unfoldCache.unfoldCache == null) {
                    this.unfoldCache.unfoldCache = this.unfoldCache;
                } else assert (this.unfoldCache.unfoldCache == this.unfoldCache);
            }
            return this.unfoldCache;
        }

        @Override
        public double trueness() {
            if (this.isTrue()) {
                return 1.0;
            }
            if (this.isFalse()) {
                return 0.0;
            }
            if (Double.isNaN(this.truenessCache)) {
                BigDecimal satisfyingAssignments = new BigDecimal(this.factory.bdd.countSatisfyingAssignments(this.node));
                BigDecimal assignments = BigDecimal.valueOf(2L).pow(this.factory.bdd.numberOfVariables());
                this.truenessCache = satisfyingAssignments.divide(assignments, 24, RoundingMode.HALF_DOWN).doubleValue();
            }
            return this.truenessCache;
        }
    }

    private final class JBddVisitor
    extends PropositionalIntVisitor {
        private JBddVisitor() {
        }

        @Override
        public int visit(Literal literal) {
            if (JBddEquivalenceClassFactory.this.encoding == EquivalenceClassFactory.Encoding.AP_COMBINED) {
                Preconditions.checkArgument((literal.getAtom() < JBddEquivalenceClassFactory.this.atomicPropositions.size() ? 1 : 0) != 0);
                int node = JBddEquivalenceClassFactory.this.bdd.variableNode(2 * literal.getAtom());
                return literal.isNegated() ? JBddEquivalenceClassFactory.this.bdd.not(node) : node;
            }
            assert (JBddEquivalenceClassFactory.this.encoding == EquivalenceClassFactory.Encoding.AP_SEPARATE);
            int variable = literal.isNegated() ? 2 * literal.getAtom() + 1 : 2 * literal.getAtom();
            Preconditions.checkArgument((variable < JBddEquivalenceClassFactory.this.atomicPropositionsVariables ? 1 : 0) != 0);
            return JBddEquivalenceClassFactory.this.bdd.variableNode(variable);
        }

        @Override
        protected int visit(Formula.TemporalOperator formula) {
            int variable = JBddEquivalenceClassFactory.this.temporalOperatorMapping.get(formula);
            assert (variable >= 0);
            return JBddEquivalenceClassFactory.this.bdd.variableNode(variable);
        }

        @Override
        public int visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? JBddEquivalenceClassFactory.this.trueNode : JBddEquivalenceClassFactory.this.falseNode;
        }

        @Override
        public int visit(Conjunction conjunction) {
            int x = JBddEquivalenceClassFactory.this.trueNode;
            for (Formula child : Lists.reverse((List)conjunction.operands)) {
                int y = child.accept(this);
                x = JBddEquivalenceClassFactory.this.bdd.consume(JBddEquivalenceClassFactory.this.bdd.and(x, y), x, y);
            }
            return x;
        }

        @Override
        public int visit(Disjunction disjunction) {
            int x = JBddEquivalenceClassFactory.this.falseNode;
            for (Formula child : Lists.reverse((List)disjunction.operands)) {
                int y = child.accept(this);
                x = JBddEquivalenceClassFactory.this.bdd.consume(JBddEquivalenceClassFactory.this.bdd.or(x, y), x, y);
            }
            return x;
        }
    }
}

